
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "docked.h"

char * small_close_xpm[] = {
"12 9 16 1",
" 	c #CCCCCCCCCCCC",
".	c #B6B6B2B2BEBE",
"+	c #BEBEBABAC6C6",
"@	c #AEAEAAAAB6B6",
"#	c #4E4E50505252",
"$	c #828284848686",
"%	c #EEEEEEEEF2F2",
"&	c #222226262A2A",
"*	c #121212121212",
"=	c #A6A6A2A2AEAE",
"-	c #020203030202",
";	c #626264646666",
">	c #424242424242",
",	c #727276767A7A",
"'	c #1A1A1A1A1A1A",
")	c #6A6A6E6E7272",
"            ",
"   .  +@    ",
"   #$%&*=   ",
"    -#-;    ",
"    ;->     ",
"    >--,    ",
"   .*$'-)   ",
"   #= @*#   ",
"            "};

static void on_page_changing( GtkNotebook *notebook, GtkNotebookPage *page, gint page_num, gpointer user_data )
{
  DockNotebook * dock = (DockNotebook *)user_data;
  update_page_labels( dock, page_num );
}

static void on_page_close_button_clicked( GtkButton *button, gpointer user_data )
{
  DockNotebook * dock = (DockNotebook *)user_data;
  int page = gtk_notebook_get_current_page( GTK_NOTEBOOK(dock->notebook) );
  remove_dock_notebook_page( dock, page, true );
}

PageLabel* create_page_label( DockNotebook *dock, const string &page_name )
{
  PageLabel *plabel = new PageLabel();
  GtkWidget* image;
  GdkPixmap* pixmap;
  
  plabel->label = gtk_label_new ( page_name.c_str() );
  gtk_widget_show (plabel->label);
  gtk_label_set_justify (GTK_LABEL (plabel->label), GTK_JUSTIFY_LEFT);
  
  plabel->button = gtk_button_new ();
  gtk_widget_show (plabel->button);
  
  gtk_widget_set_usize (plabel->button, 16, 16);
  GTK_WIDGET_UNSET_FLAGS (plabel->button, GTK_CAN_FOCUS);
  gtk_button_set_relief (GTK_BUTTON (plabel->button), GTK_RELIEF_NONE);

  image = gtk_image_new_from_stock ("gtk-close", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_container_add (GTK_CONTAINER (plabel->button), image);
  
  pixmap = gdk_pixmap_colormap_create_from_xpm_d ( dock->notebook->window, gdk_colormap_get_system(), NULL, NULL, small_close_xpm );  
  plabel->image = gtk_image_new_from_pixmap(pixmap, NULL);
  gtk_widget_show (plabel->image);
  
  plabel->box = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(plabel->box), plabel->label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(plabel->box), plabel->button, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(plabel->box), plabel->image, FALSE, FALSE, 0);
  gtk_widget_show (plabel->box);
  
  gtk_signal_connect( GTK_OBJECT (plabel->button), "clicked",
				              GTK_SIGNAL_FUNC(on_page_close_button_clicked),
				              (gpointer)dock );
  
  return plabel;
}

void update_page_labels( DockNotebook *dock, int page_num )
{
  for ( unsigned int i = 0; i < dock->labels.size(); i++ )
  {
    if ( (int)i == page_num )
    {
      gtk_widget_show( dock->labels[i]->button );
      gtk_widget_hide( dock->labels[i]->image );
    }
    else
    {
      gtk_widget_hide( dock->labels[i]->button );
      gtk_widget_show( dock->labels[i]->image );
    }
  }
}

DockNotebook *create_dock_notebook()
{
  DockNotebook *dock = new DockNotebook();
  
  dock->notebook = gtk_notebook_new ();
  gtk_widget_show (dock->notebook);
  gtk_notebook_set_scrollable( GTK_NOTEBOOK(dock->notebook), TRUE );
  
  gtk_signal_connect( GTK_OBJECT (dock->notebook), "switch_page",
				              GTK_SIGNAL_FUNC(on_page_changing),
				              (gpointer)dock );
  
  return dock;
}

void add_dock_notebook_page( DockNotebook * dock, GraphGUIDockableWindow* window )
{
  int page_pos = find_dock_notebook_page( dock, window );
  
  if ( page_pos < 0 )
  {
    PageLabel* label = create_page_label( dock, window->get_label() );
    unsigned int curr_num = dock->windows.size();
    
    window->make_docked( true );
      
    gtk_notebook_append_page( GTK_NOTEBOOK( dock->notebook ), (GtkWidget*)window->get_dockable(), label->box );
    
    dock->windows.push_back( window );
    dock->labels.push_back( label );
    gtk_notebook_set_current_page( GTK_NOTEBOOK( dock->notebook ), curr_num );
    
    if ( curr_num == 0 )
      gtk_widget_show( dock->notebook );
    
    update_page_labels( dock, curr_num );
  }
  else
    gtk_notebook_set_current_page( GTK_NOTEBOOK( dock->notebook ), page_pos );
}

int get_dock_notebook_page_number( DockNotebook * dock )
{
  return dock->windows.size();
}

GraphGUIDockableWindow* get_dock_notebook_page_window( DockNotebook *dock, int page_pos )
{
  GraphGUIDockableWindow* res = 0;
  
  if ( page_pos >= 0 && page_pos < (int)dock->windows.size() )
    res = dock->windows[page_pos];
  
  return res;
}

void remove_dock_notebook_page( DockNotebook * dock, int page_pos, bool delete_window )
{
  if ( page_pos >= 0 && page_pos < (int)dock->windows.size() )
  {
    GraphGUIDockableWindow* window = dock->windows[page_pos];
    
    dock->windows.erase( dock->windows.begin() + page_pos );
    dock->labels.erase( dock->labels.begin() + page_pos );
    
    gtk_notebook_remove_page( GTK_NOTEBOOK(dock->notebook), page_pos );
    
    if ( delete_window )
      delete window;
    
    if ( page_pos < (int)dock->windows.size() )
    {
      gtk_notebook_set_current_page( GTK_NOTEBOOK( dock->notebook ), page_pos );
      update_page_labels( dock, page_pos );
    }
    else if ( !dock->windows.empty() )
    {
      gtk_notebook_set_current_page( GTK_NOTEBOOK( dock->notebook ), page_pos - 1 );
      update_page_labels( dock, page_pos - 1 );
    }
    else
      gtk_widget_hide( dock->notebook );
  }
}

int find_dock_notebook_page( DockNotebook * dock, GraphGUIDockableWindow* window )
{
  int res = -1; 
  
  for ( unsigned int i = 0; i < dock->windows.size() && res < 0; i++ )
  {
    if ( dock->windows[i] == window )
      res = i;
  }
  
  return res;
}

