#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <fstream>
#include <stdio.h>

#include "callbacks.h"
#include "interface.h"
#include "net_interface.h"
#include "support.h"
#include "UnixPropertiesDialog.h"
#include "NewProcessesSupport.h"
#include "UnixGenerateGUI.h"
#include "UnixGraphSaveGUI.h"

//#include "OS_indep/graphics.h"

//using namespace GraphGraphics;

//static gdouble last_vscroll_value = 0;
//static gdouble last_hscroll_value = 0;

extern int wnd_nmb;

typedef struct
{ 
  NodeIndex   node_id;
  ScenarioApp *graph_app;
  GtkWidget   *drawing_area;
} EDGE_SELECTING_DATA;

gboolean
on_main_window_destroy_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  
  return TRUE;
}

gboolean close_window( GtkWidget *widget, GraphDrawingData *draw_data, bool force )
{
  GraphGenerationGUI *generate_dialog = (GraphGenerationGUI *)g_object_get_data( G_OBJECT(widget), "generate_graph_window" );  
  bool       close = true;

  if ( generate_dialog != 0 )
    close =  generate_dialog->destroy( force );
  
  if ( close )
  {
    GtkWidget        *h_scroll  = lookup_widget( widget, "hscrollbar1");
    GtkWidget        *v_scroll  = lookup_widget( widget, "vscrollbar1");
    gdouble          *v_value   = (gdouble*)g_object_get_data( G_OBJECT(v_scroll), "last_value" );
    gdouble          *h_value   = (gdouble*)g_object_get_data( G_OBJECT(h_scroll), "last_value" );
    GtkWidget        *net_window = (GtkWidget*)g_object_get_data( G_OBJECT(widget), "net_window" );
    
    if ( net_window != NULL )
      gtk_widget_destroy(net_window);
    
    delete v_value;
    delete h_value;
    
    delete draw_data->graph_app;
    delete draw_data;
    
    delete generate_dialog;
    
    wnd_nmb--;
    if (wnd_nmb > 0)
      gtk_widget_destroy(widget);	
    else
      gtk_main_quit();		
  }
  
	return (close? TRUE: FALSE);
}

gboolean
on_main_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  return close_window( widget, draw_data, true );
}

gboolean
on_drawingarea_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphGUI         *gui  = app->get_GUI(); 
  GraphicArea      *g    = gui->get_graphic_area( widget );
  Event             g_event;
  KeyCode           modifiers = 0;
  //GtkWidget        *main_window = lookup_widget(widget, "main_window");
  
  g_event.set_type( Event::MOUSE_PRESSED );
    
  switch( event->button )
  {
  case 1: // left button
    g_event.set_button_code( Event::MOUSE_LEFT_BUTTON );
    g_event.set_point( TwoDPoint( (OneDValue)(event->x), (OneDValue)(event->y) ) ); 
    g_event.set_graphic_area( g );
  
    if ( event->state & GDK_SHIFT_MASK )
      modifiers |= Event::SHIFT_MASK;
    if ( event->state & GDK_CONTROL_MASK )
      modifiers |= Event::CTRL_MASK;
    
    g_event.set_modifiers( modifiers );
    
    app->get_event_handler()->handle_mouse_events( g_event );
    
    break;
  case 3: // right button
  default:;
  }  

  if (g != 0)
    delete g;

  
  return TRUE;
}

void on_outgoing_edge_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  EDGE_SELECTING_DATA *data = (EDGE_SELECTING_DATA *)user_data;
  NodeIndex            start_node_id = data->node_id;
  GtkWidget           *drawing_area = data->drawing_area;
  ScenarioApp        *app = data->graph_app;
  GraphGUI            *gui  = app->get_GUI(); 
  GraphicArea         *g    = gui->get_graphic_area( drawing_area );
    
  app->get_event_handler()->handle_init_edge_selecting( g, start_node_id ); 
  
  delete data;
  
  if (g != 0)
    delete g;
}

gboolean
on_drawingarea_button_release_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphGUI         *gui = app->get_GUI(); 
  GraphicArea      *g   = gui->get_graphic_area( widget );
  GraphView        *view = app->get_graph_view_context()->get_view();
  Event        g_event;
  KeyCode      modifiers = 0;
  NodeIndex    node_id = Graph::INVALID_NODE_ID;
  //GtkWidget   *main_window = lookup_widget(widget, "main_window");
  //GdkRectangle      invalidate_rect;
  GtkWidget *node_menu = 0;
  GtkWidget        *status_bar  = lookup_widget( widget, "statusbar1");  
  string      status_str;
  
  g_event.set_type( Event::MOUSE_RELEASED );
    
  switch( event->button )
  {
  case 1: // left button
    g_event.set_button_code( Event::MOUSE_LEFT_BUTTON );
    g_event.set_point( TwoDPoint( (OneDValue)(event->x), (OneDValue)(event->y) ) ); 
    g_event.set_graphic_area( g );
  
    if ( event->state & GDK_SHIFT_MASK )
      modifiers |= Event::SHIFT_MASK;
    if ( event->state & GDK_CONTROL_MASK )
      modifiers |= Event::CTRL_MASK;
    
    g_event.set_modifiers( modifiers );
    
    app->get_event_handler()->handle_mouse_events( g_event );
    
    status_str = app->get_graph_view_context()->get_status_mngr()->get_current_status()->get_status_str();
    set_new_status_message(status_bar, status_str);
    
    break;
    
  case 3: // right button
    g_event.set_button_code( Event::MOUSE_RIGHT_BUTTON );
    g_event.set_point( TwoDPoint( (OneDValue)(event->x), (OneDValue)(event->y) ) ); 
    g_event.set_graphic_area( g );
  
    if ( event->state & GDK_SHIFT_MASK )
      modifiers |= Event::SHIFT_MASK;
    if ( event->state & GDK_CONTROL_MASK )
      modifiers |= Event::CTRL_MASK;
    
    g_event.set_modifiers( modifiers );
    
    app->get_event_handler()->handle_mouse_events( g_event );
    
    node_menu = make_view_menu( draw_data );
    
    if ( (node_id = view->get_node_id( TwoDPoint( (OneDValue)(event->x), (OneDValue)(event->y) ) )) != Graph::INVALID_NODE_ID )
    {
      GtkWidget *outgoing_edge_mnu = gtk_menu_item_new_with_mnemonic( "Select outgoing edge" );
      EDGE_SELECTING_DATA *data = new EDGE_SELECTING_DATA();
      GtkWidget *separatormenuitem;
      
      separatormenuitem = gtk_menu_item_new ();
      gtk_widget_show (separatormenuitem);
      gtk_container_add (GTK_CONTAINER (node_menu), separatormenuitem);
      gtk_widget_set_sensitive (separatormenuitem, FALSE);
      
      data->graph_app = app;
      data->drawing_area = widget;
      data->node_id = node_id;
      
      gtk_widget_show( outgoing_edge_mnu );
      
      gtk_container_add( GTK_CONTAINER(node_menu), outgoing_edge_mnu );
      
      gtk_signal_connect( GTK_OBJECT (outgoing_edge_mnu), "activate",
                          GTK_SIGNAL_FUNC (on_outgoing_edge_activate),
                          (gpointer)data);
            
    }
    
    gtk_menu_popup (GTK_MENU (node_menu), NULL, NULL, NULL, NULL,
                      0, event->time);
    
    break;
    
  default:;
  }  

  if (g != 0)
    delete g;

    
  return TRUE;;
}

gboolean
on_drawingarea_motion_notify_event    (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GtkWidget        *status_bar  = lookup_widget( widget, "statusbar1");  
  string          status_str;
  GraphGUI         *gui = app->get_GUI(); 
  GraphicArea      *g    = gui->get_graphic_area( widget );
  Event             g_event;
  KeyCode           modifiers = 0;
    
  g_event.set_type( Event::MOUSE_MOVE );

  if ( event->state & GDK_BUTTON1_MASK/* && event->axes == NULL*/ )
    g_event.set_button_code( Event::MOUSE_LEFT_BUTTON );
    
  g_event.set_point( TwoDPoint( (OneDValue)(event->x), (OneDValue)(event->y) ) ); 
  g_event.set_graphic_area( g );
  
  if ( event->state & GDK_SHIFT_MASK )
    modifiers |= Event::SHIFT_MASK;
  if ( event->state & GDK_CONTROL_MASK )
    modifiers |= Event::CTRL_MASK;
    
  g_event.set_modifiers( modifiers );
    
  app->get_event_handler()->handle_mouse_events( g_event );
    
  status_str = app->get_graph_view_context()->get_status_mngr()->get_current_status()->get_status_str();
  set_new_status_message(status_bar, status_str);

  if (g != 0)
    delete g;

  return TRUE;
}

void
on_comp_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphGUI         *gui = app->get_GUI();
  
  GraphGUIModalWindow *dialog = gui->create_comp_manager_dialog( app );
  
  dialog->run(  );
    
  delete dialog; 
}

void
on_open_activate                       (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GtkWidget        *main_window = lookup_widget( widget, "main_window" );
  GraphGenerationGUI *generate_dialog = (GraphGenerationGUI *)g_object_get_data( G_OBJECT(main_window), "generate_graph_window" );
  
  generate_dialog->show( true );
    
  gtk_widget_set_sensitive ( widget, false );
}

void
on_save_activate                       (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphGUI         *gui = app->get_GUI();
  
  GraphSaveGUI *dialog = gui->create_graph_save_dialog( );
  
  dialog->run(  );
  
  delete dialog; 
}

void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  
  GtkWidget        *main_window = lookup_widget( GTK_WIDGET(menuitem), "main_window" );
  close_window( main_window, draw_data, false );
}

void
on_zoom_in_activate                    (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphView        *view = app->get_graph_view_context()->get_view();
  GdkRectangle      invalidate_rect;
  
  app->get_event_handler()->handle_zoom_in();
  
  update_scrollbars( draw_data->drawing_area, view);
  
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( draw_data->drawing_area->window, TRUE );
}


void
on_zoom_out_activate                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphView        *view = app->get_graph_view_context()->get_view();
  GdkRectangle      invalidate_rect;
  
  app->get_event_handler()->handle_zoom_out();
  
  update_scrollbars( draw_data->drawing_area, view );
  
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( draw_data->drawing_area->window, TRUE );
}


void on_fit_to_window_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphView        *view = app->get_graph_view_context()->get_view();
  GdkRectangle      invalidate_rect;
  
  app->get_event_handler()->handle_fit_to_window();
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( draw_data->drawing_area->window, TRUE );
  
  update_scrollbars( draw_data->drawing_area, view );
  
}

void on_fit_to_width_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphView        *view = app->get_graph_view_context()->get_view();
  GdkRectangle      invalidate_rect;
  
  app->get_event_handler()->handle_fit_to_width();
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( draw_data->drawing_area->window, TRUE );
  
  update_scrollbars( draw_data->drawing_area, view );
}

void on_fit_to_height_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphView        *view = app->get_graph_view_context()->get_view();
  GdkRectangle      invalidate_rect;
  
  app->get_event_handler()->handle_fit_to_height();
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( draw_data->drawing_area->window, TRUE );
  
  update_scrollbars( draw_data->drawing_area, view );
}

void on_fit_selected_to_window_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphView        *view = app->get_graph_view_context()->get_view();
  GdkRectangle      invalidate_rect;
  
  app->get_event_handler()->handle_fit_selection_to_window();
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( draw_data->drawing_area->window, TRUE );
  
  update_scrollbars( draw_data->drawing_area, view );
}

void on_arbitrary_size_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphView        *view = app->get_graph_view_context()->get_view();
  GdkRectangle      invalidate_rect;
  
  app->get_event_handler()->handle_arbitrary_size();
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( draw_data->drawing_area->window, TRUE );
  
  update_scrollbars( draw_data->drawing_area, view );
}

void on_centering_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphView        *view = app->get_graph_view_context()->get_view();
  GdkRectangle      invalidate_rect;
  Rectangle         rect;
  NodeIndexVector   selected_nodes;
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
    
  rect.set_left_top_corner( TwoDPoint( invalidate_rect.x, invalidate_rect.y) );
  rect.set_right_bottom_corner( TwoDPoint( invalidate_rect.width, invalidate_rect.height) );
  
  if ( app->get_event_handler()->handle_selection_centering( rect ) )
  {
    update_scrollbars( draw_data->drawing_area, view );
    
    gdk_window_invalidate_rect( draw_data->drawing_area->window, &invalidate_rect, TRUE );
    gdk_window_process_updates( draw_data->drawing_area->window, TRUE );
  }
}


void on_groups_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphGUI         *gui = app->get_GUI();
  GraphView        *view = app->get_graph_view_context()->get_view();
  GdkRectangle      invalidate_rect;
  
  GraphViewPropertiesGUI *dialog = gui->create_group_properties_dialog( view );
  
  dialog->run();
  int chang_level = dialog->get_changes_level();
  
  if ( chang_level != GraphViewPropertiesGUI::PROPERTIES_UNCHANGED )
  {
    if ( chang_level == GraphViewPropertiesGUI::NEED_EDGES_RECONSTRUCTION )
      view->redraw_edges( false );
    
    update_scrollbars( draw_data->drawing_area, view );  
    
    invalidate_rect.x = 0;
    invalidate_rect.y = 0;
    gdk_window_get_size( draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
    
    gdk_window_invalidate_rect( draw_data->drawing_area->window, &invalidate_rect, TRUE );
    gdk_window_process_updates( draw_data->drawing_area->window, TRUE ); 
  }
  
  delete dialog;
}


void on_properties_activate( GtkWidget *widget, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphGUI         *gui = app->get_GUI();
  GraphView        *view = app->get_graph_view_context()->get_view();
  Graph            *graph =app->get_graph_view_context()->get_graph();
  GdkRectangle      invalidate_rect;
  
  GraphViewPropertiesGUI* dialog  = gui->create_view_properties_dialog( view );
  dialog->run();
  int chang_level = dialog->get_changes_level();
  
  if ( chang_level != GraphViewPropertiesGUI::PROPERTIES_UNCHANGED )
  {
    if ( chang_level == GraphViewPropertiesGUI::NEED_EDGES_RECONSTRUCTION )
    {
      if ( graph->count_nodes() > 20 )
        gui->show_wait_dialog( "Graph building. Please wait..." );
      view->redraw_edges();
    
      gui->hide_wait_dialog();
    }
    
    update_scrollbars( draw_data->drawing_area, view );
    
    invalidate_rect.x = 0;
    invalidate_rect.y = 0;
    gdk_window_get_size( draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
    
    gdk_window_invalidate_rect( draw_data->drawing_area->window, &invalidate_rect, TRUE );
    
    gdk_window_process_updates( draw_data->drawing_area->window, TRUE );
  }
  
  delete dialog;
}

void on_preference_activate( GtkWidget *widget, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphGUI         *gui = app->get_GUI();
  GraphView        *view = app->get_graph_view_context()->get_view();
  
  GdkRectangle     invalidate_rect;
    
  GraphGUIModalWindow* dialog = gui->create_view_preferences_dialog( view, true );
  
  dialog->run();

  delete dialog;
  
  GtkWidget *menu_item = lookup_widget( widget, "show_gm_on_load_mode_mnu" );
  unsigned int modes = app->get_behavior_modes();
  unsigned int extra_modes = app->get_extra_behavior_modes();
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_item), extra_modes & ScenarioApp::OUTPUT_GEN_GRAPH_METRICS );
  
  menu_item = draw_data->use_aliases_mnu;
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_item), extra_modes & ScenarioApp::USE_ATTR_ALIASES );
  
  menu_item = draw_data->dock_attr_mode_mnu;
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_item), extra_modes & ScenarioApp::DOCK_ATTR_ON_START );
  
  menu_item = draw_data->dock_info_mode_mnu;
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_item), extra_modes & ScenarioApp::DOCK_INFO_ON_START );
  
  menu_item = lookup_widget( widget, "single_aw_mode_mnu" );
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_item), modes & ScenarioApp::SINGLE_ATTR_WINDOW );
 
  menu_item = lookup_widget( widget, "single_iw_mode_mnu" );
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_item), modes & ScenarioApp::SINGLE_INFO_WINDOW );
  
  menu_item = lookup_widget( widget, "aw_on_mouse_over_mode_mnu" );
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_item), modes & ScenarioApp::SHOW_ATTR_ON_MOUSE_OVER );

  menu_item = lookup_widget( widget, "aw_on_node_select_mode_mnu" );
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_item), modes & ScenarioApp::SHOW_ATTR_ON_NODE_SELECT );
  
  menu_item = lookup_widget( widget, "close_gw_after_load_mode_mnu" );
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_item), modes & ScenarioApp::CLOSE_OPEN_DIALOG_AFTER_GRAPH_LOAD );
  
  menu_item = lookup_widget( widget, "edge_selecting_mode_mnu" );
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_item), modes & ScenarioApp::EDGE_SELECTING );
  
  
  
  
  menu_item = lookup_widget( widget, "attr_single_btn" );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(menu_item), modes & ScenarioApp::SINGLE_ATTR_WINDOW);
  
  menu_item = lookup_widget( widget, "info_single_btn" );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(menu_item), modes & ScenarioApp::SINGLE_INFO_WINDOW);
  
  menu_item = lookup_widget( widget, "over_node_btn" );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(menu_item), modes & ScenarioApp::SHOW_ATTR_ON_MOUSE_OVER);
  
  menu_item = lookup_widget( widget, "select_node_btn" );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(menu_item), modes & ScenarioApp::SHOW_ATTR_ON_NODE_SELECT);
  
  menu_item = lookup_widget( widget, "edge_selecting_btn" );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(menu_item), modes & ScenarioApp::EDGE_SELECTING);
  
  menu_item = lookup_widget( widget, "load_close_btn" );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(menu_item), modes & ScenarioApp::CLOSE_OPEN_DIALOG_AFTER_GRAPH_LOAD);
  
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
    
  gdk_window_invalidate_rect( draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( draw_data->drawing_area->window, TRUE );
  update_scrollbars( draw_data->drawing_area, view );	

}

void on_filter_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphGUI         *gui = app->get_GUI();
  GraphView        *view = app->get_graph_view_context()->get_view();
  
  GraphAttrFilterGUI *dialog = gui->create_node_attr_filter_dialog( view );
  
  if ( dialog->run() == GraphGUIModalWindow::APPLIED )
  {
    AttrStringTemplateStorage* new_filters = dialog->get_filetrs();
    view->set_node_attr_filters( new_filters );
    
    delete new_filters;
  }
  
  delete dialog;
}

void on_attributes_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphGUI         *gui = app->get_GUI();
  GraphView        *view = app->get_graph_view_context()->get_view();
    
  GraphNodeAttributesGUI* window = gui->create_nodes_info_dialog( view );
    
  if ( window != 0 )
    window->show( true );
}

void on_new_wnd_activate(GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData      *draw_data_curr = (GraphDrawingData*)user_data;
    
  ScenarioApp           *app = draw_data_curr->graph_app;
  GraphGUI              *gui = app->get_GUI();
  GraphViewContext      *view_context_curr = app->get_graph_view_context();
  GraphView             *view_curr = view_context_curr->get_view();
  Graph                 *graph_curr = view_context_curr->get_graph();
  
  Graph                 *graph = graph_curr->get_selected_subgraph();
  GraphView             *view;
  
  GraphDrawingData *draw_data = new GraphDrawingData();
  //NetDrawingData    *net_draw_data = new NetDrawingData();
  
  if ( graph->count_nodes() > 20 )
    gui->show_wait_dialog( "Graph building. Please wait...");
  
  GtkWidget *main_window = create_main_window ( draw_data );
  
  draw_data->graph_app->get_graph_view_context()->set_graph( graph );
  view = draw_data->graph_app->get_graph_view_context()->get_view();
  
  view->copy_properties( view_curr );
  view->make_graph_view();
  
  NetworkComp *net_comp;
  
  net_comp = new NetworkComp();
  draw_data->graph_app->register_component((CompInterface*)net_comp);
    
  net_comp->set_component_name( NETWORK_COMP_NAME );
  
  net_comp->register_comp_activity_change_handler( new NetCompActivityHandler( main_window, net_comp, draw_data->graph_app ) );
    
  gui->hide_wait_dialog( );
  
  gtk_widget_show (main_window);
  wnd_nmb++;
}  

void on_find_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data_curr = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data_curr->graph_app;
  GraphGUI         *gui = app->get_GUI();
  Graph            *graph = app->get_graph_view_context()->get_graph();
  GraphView        *view = app->get_graph_view_context()->get_view();
  
  GdkRectangle      invalidate_rect;
  GraphNodeSearchGUI *dialog = gui->create_node_search_dialog( view );
  
  int res = dialog->run();
  string attr_str = dialog->get_result_attr_string();
  NodeAttributeList attr_list;
  
  if ( attr_str != "" && res == GraphGUIModalWindow::APPLIED )
  {
    bool is_attr_str = GraphAttributes::parse_string( attr_str, attr_list );
    
    if ( dialog->get_in_new_window_flag() )
    {
      if ( is_attr_str )
      {
        Graph     *new_graph = graph->get_subgraph( attr_list );
        GraphView *new_view;
        
        GraphDrawingData *draw_data = new GraphDrawingData();
                
        if ( new_graph->count_nodes() > 20 )
          gui->show_wait_dialog( "Graph building. Please wait...");
      
        GtkWidget *main_window = create_main_window ( draw_data );
        
        draw_data->graph_app->get_graph_view_context()->set_graph( new_graph );
        new_view = draw_data->graph_app->get_graph_view_context()->get_view();
  
        new_view->copy_properties( view );
        new_view->make_graph_view();
        
        NetworkComp *net_comp;
  
        net_comp = new NetworkComp();
        draw_data->graph_app->register_component((CompInterface*)net_comp);
    
        net_comp->set_component_name( NETWORK_COMP_NAME );
    
        net_comp->register_comp_activity_change_handler( new NetCompActivityHandler( main_window, net_comp, draw_data->graph_app ) );
        
        gui->hide_wait_dialog( );
        
        gtk_widget_show (main_window);
        wnd_nmb++;
      }
    }
    else
    {
      view->unselect_all_nodes( 0 );
      
      if ( is_attr_str )
      {
        for ( NodeIndex id = graph->find_first_node( attr_list ); id != Graph::INVALID_NODE_ID; id = graph->find_next_node( attr_list, id ) )
          view->select_node( id, 0 );
      }  
      invalidate_rect.x = 0;
      invalidate_rect.y = 0;
      gdk_window_get_size( draw_data_curr->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
      
      gdk_window_invalidate_rect( draw_data_curr->drawing_area->window, &invalidate_rect, TRUE );
      gdk_window_process_updates( draw_data_curr->drawing_area->window, TRUE );
    }
  }
  
  delete dialog;
}

void on_select_path_activate( GtkWidget *widget, gpointer user_data )
{
  GraphDrawingData *draw_data_curr = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data_curr->graph_app;
  
  app->get_event_handler()->handle_init_path_finding();
}

void on_next_path_activate( GtkWidget *widget, gpointer user_data )
{
  GraphDrawingData *draw_data_curr = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data_curr->graph_app;
  GraphGUI         *gui = app->get_GUI(); 
  GraphicArea      *g   = gui->get_graphic_area( draw_data_curr->drawing_area );    
  
  if ( app->get_event_handler()->get_found_pathes().get_pathes_count() > 0 )
  {
    if ( app->get_event_handler()->get_found_pathes().get_pathes_count() > app->get_event_handler()->get_current_selected_path_id() )
      app->get_event_handler()->handle_path_selecting( app->get_event_handler()->get_current_selected_path_id() + 1, g );
  }
  else
  {
    string end_nodes_str = "{accept=1;}";
    NodeAttributeList end_nodes;
    
    GraphAttributes::parse_string( end_nodes_str, end_nodes );
    
    app->get_event_handler()->find_path_group( g, 0, end_nodes );
  }
  
  delete g;
}

void on_prev_path_activate( GtkWidget *widget, gpointer user_data )
{
  GraphDrawingData *draw_data_curr = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data_curr->graph_app;
  GraphGUI         *gui = app->get_GUI(); 
  GraphicArea      *g   = gui->get_graphic_area( draw_data_curr->drawing_area );
  
  if ( app->get_event_handler()->get_found_pathes().get_pathes_count() > 0 )
  {
    if ( app->get_event_handler()->get_current_selected_path_id() > 0 )
      app->get_event_handler()->handle_path_selecting( app->get_event_handler()->get_current_selected_path_id() - 1, g );
  }
  else
  {
    string end_nodes_str = "{accept=1;}";
    NodeAttributeList end_nodes;
    
    GraphAttributes::parse_string( end_nodes_str, end_nodes );
    
    app->get_event_handler()->find_path_group( g, 0, end_nodes );
  }
  
  delete g;
}

void on_sub_group_activate( GtkWidget *widget, gpointer user_data)
{
  GraphDrawingData *draw_data_curr = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data_curr->graph_app;
  GraphGUI         *gui = app->get_GUI();
  Graph            *graph = app->get_graph_view_context()->get_graph();
  GraphScenarioGroupRestrictionGUI *dialog = gui->create_scenario_group_restriction_dialog( graph );
  
  int res = dialog->run();
  
  if ( res == GraphGUIModalWindow::APPLIED )
  {
    GraphicArea      *g   = gui->get_graphic_area( draw_data_curr->drawing_area );
    NodeAttributeList include_nodes;
    NodeAttributeList exclude_nodes;
    
    if ( !GraphAttributes::parse_string( dialog->get_include_nodes_restriction(), include_nodes ) )
      include_nodes.clear();
    
    if ( !GraphAttributes::parse_string( dialog->get_exclude_nodes_restriction(), exclude_nodes ) )
      exclude_nodes.clear();
    
    if ( exclude_nodes.empty() && include_nodes.empty() )
      gui->show_message_dialog( "All node restrictions are invalid" );
    else
    {
      bool find = false;
      if ( app->get_event_handler()->get_found_pathes().get_pathes_count() > 0 )
        find = app->get_event_handler()->find_path_sub_group( g, include_nodes, exclude_nodes );
      else
      {
        string end_nodes_str = "{accept=1;}";
        NodeAttributeList end_nodes;
        
        GraphAttributes::parse_string( end_nodes_str, end_nodes );
        
        find = app->get_event_handler()->find_path_group( g, 0, end_nodes, include_nodes, exclude_nodes );
      }
      
      if ( !find )
        gui->show_message_dialog( "Scenario group is not found" );
      else
      {
        if ( draw_data_curr->graph_app->get_event_handler()->get_sub_group_finding_number() > 0 )
          gtk_widget_set_sensitive(  draw_data_curr->undo_scenario_path, TRUE );
      }
    }
  }
  
  delete dialog;
}

void on_undo_sub_group_activate( GtkWidget *widget, gpointer user_data )
{
  GraphDrawingData *draw_data_curr = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data_curr->graph_app;
  GraphGUI         *gui = app->get_GUI();
    
  if ( app->get_event_handler()->get_found_pathes().get_pathes_count() > 0 )
  {
    GraphicArea      *g   = gui->get_graphic_area( draw_data_curr->drawing_area );
    app->get_event_handler()->undo_find_path_sub_group( g );
    
    delete g;
    
    if ( draw_data_curr->graph_app->get_event_handler()->get_sub_group_finding_number() <= 0 )
      gtk_widget_set_sensitive( draw_data_curr->undo_scenario_path, FALSE );
  }
  else
    gtk_widget_set_sensitive( draw_data_curr->undo_scenario_path, FALSE );
    
}


void on_single_aw_mode_activate( GtkMenuItem *menuitem, gpointer  user_data )
{
  GtkWidget        *btn  = lookup_widget( GTK_WIDGET(menuitem), "attr_single_btn");        
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) );
  
  app->set_behavior_modes( ScenarioApp::SINGLE_ATTR_WINDOW, enable);
    
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), enable);    
}

void on_single_iw_mode_activate( GtkMenuItem *menuitem, gpointer  user_data )
{
  GtkWidget        *btn  = lookup_widget( GTK_WIDGET(menuitem), "info_single_btn");          
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) );
    
  app->set_behavior_modes( ScenarioApp::SINGLE_INFO_WINDOW, enable );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), enable);          
}

void on_close_gw_after_load_mode_activate( GtkMenuItem *menuitem, gpointer  user_data )
{
  GtkWidget        *btn  = lookup_widget( GTK_WIDGET(menuitem), "load_close_btn");          
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) );
    
  app->set_behavior_modes( ScenarioApp::CLOSE_OPEN_DIALOG_AFTER_GRAPH_LOAD, enable );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), enable);  
}

void on_edge_selecting_mode_activate( GtkMenuItem *menuitem, gpointer  user_data )
{
  GtkWidget        *btn  = lookup_widget( GTK_WIDGET(menuitem), "edge_selecting_btn");          
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) );
    
  app->set_behavior_modes( ScenarioApp::EDGE_SELECTING, enable );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), enable);  
}


void on_aw_on_mouse_over_mode_activate( GtkMenuItem *menuitem, gpointer  user_data )
{
  GtkWidget        *btn  = lookup_widget( GTK_WIDGET(menuitem), "over_node_btn");              
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) );
  
  app->set_behavior_modes( ScenarioApp::SHOW_ATTR_ON_MOUSE_OVER, enable );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), enable);        
}

void on_aw_on_node_select_mode_activate( GtkMenuItem *menuitem, gpointer  user_data )
{
  GtkWidget        *btn  = lookup_widget( GTK_WIDGET(menuitem), "select_node_btn");              
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) );
  
  app->set_behavior_modes( ScenarioApp::SHOW_ATTR_ON_NODE_SELECT, enable );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), enable);        
}

void on_reduce_graph_activate( GtkMenuItem *menuitem, gpointer  user_data )
{
  GraphDrawingData      *draw_data_curr = (GraphDrawingData*)user_data;
    
  ScenarioApp           *app = draw_data_curr->graph_app;
  GraphViewContext      *view_context_curr = app->get_graph_view_context();
  GraphView             *view_curr = view_context_curr->get_view();
  GraphGUI              *gui = app->get_GUI();
    
  ComponentIndex        ind;
  CompInterface        *comp = 0;
  
  for ( ind = 0; ind < app->count_registered_components(); ind++ )
  {
    comp = app->get_registered_component( ind );
    
    if ( comp->get_component_name() == NETWORK_COMP_NAME )
      break;
    comp = 0;
  }
  
  if ( comp != 0 )
  {
    NetworkComp *net_comp = dynamic_cast<NetworkComp *>(comp);
    GraphView   *view;
    Graph  *graph = 0;
    NetworkGUI  *net_gui  = net_comp->get_net_GUI();
    NetAttacksGUI *attack_dialog = net_gui->create_attacks_dialog( graph, net_comp, gui );
    
    if ( attack_dialog != 0 )
    {
      int res = attack_dialog->run();
      
      if ( res == GraphGUIModalWindow::GraphGUIModalWindow::APPLIED )
         graph = net_comp->remove_attacks_from_scenario( attack_dialog->get_result_measure() );
      
      if ( graph != 0 )
      {
        GraphDrawingData *draw_data = new GraphDrawingData();
        ScenarioApp      *new_app;
        GraphViewContext *view_context;
        GtkWidget *main_window = create_main_window ( draw_data );
              
        if ( graph->count_nodes() > 20 )
          gui->show_wait_dialog( "Graph building. Please wait...");
    
        new_app = draw_data->graph_app;
        view_context = new_app->get_graph_view_context();
        view_context->set_graph( graph );
        view = view_context->get_view();
    
        view->copy_properties( view_curr );
        view->make_graph_view();
        
        
        NetworkComp *net_comp;
    
        net_comp = new NetworkComp();
        draw_data->graph_app->register_component((CompInterface*)net_comp);
    
        net_comp->set_component_name( NETWORK_COMP_NAME );
    
        net_comp->register_comp_activity_change_handler( new NetCompActivityHandler( main_window, net_comp, draw_data->graph_app ) );
        
        gui->hide_wait_dialog( );
        gtk_widget_show (main_window);
        wnd_nmb++;
      }
      
      delete attack_dialog;
    }
  }
}

void on_critical_attack_activate( GtkMenuItem *menuitem, gpointer  user_data )
{
  GraphDrawingData      *draw_data_curr = (GraphDrawingData*)user_data;
    
  ScenarioApp           *app = draw_data_curr->graph_app;
  GraphViewContext      *view_context = app->get_graph_view_context();
  Graph                 *graph = view_context->get_graph();
  GraphGUI              *gui = app->get_GUI();
    
  ComponentIndex        ind;
  CompInterface        *comp = 0;
  
  for ( ind = 0; ind < app->count_registered_components(); ind++ )
  {
    comp = app->get_registered_component( ind );
    
    if ( comp->get_component_name() == NETWORK_COMP_NAME )
      break;
    
    comp = 0;
  }
  
  if ( comp != 0 )
  {
    NetworkComp *net_comp = dynamic_cast<NetworkComp *>(comp);
    NetworkGUI  *net_gui  = net_comp->get_net_GUI();
    NetAttacksGUI *attack_dialog = net_gui->create_attacks_dialog( graph, net_comp, gui );
    
    if ( attack_dialog != 0 )
    {      
      int res = attack_dialog->run();
      
      if ( res == GraphGUIModalWindow::GraphGUIModalWindow::APPLIED )
      {
        GraphicArea *g = gui->get_graphic_area( draw_data_curr->drawing_area );
        AttackTriplesSet res_subset;
        res = net_comp->gready_attack_set( attack_dialog->get_result_measure(), res_subset, GraphViewPropertiesStorage::EDGE_SELECTED, g );
        
        if ( res_subset.size() == 0 )
          gui->show_message_dialog( "The given attacks set does not contain a substantial attack triple." );
        else
        {
          GraphInformationGUI *info_wnd = gui->create_information_window( GraphGUI::DOCKABLE_GENERAL, 0, true );
                  
          net_comp->set_attack_triples_information(info_wnd->get_root_level(), res_subset );
            
          info_wnd->show( true );
          
          if ( !res )
            gui->show_message_dialog( "The given set of attack triples does not contain critical subset." );
        }        
        
        delete g;
      }
      
      delete attack_dialog;
    }
  }
  else
    gui->show_message_dialog( "Network component was not found." );
}

void on_critical_measure_activate( GtkMenuItem *menuitem, gpointer  user_data )
{
  GraphDrawingData      *draw_data_curr = (GraphDrawingData*)user_data;
    
  ScenarioApp           *app = draw_data_curr->graph_app;
  GraphViewContext      *view_context = app->get_graph_view_context();
  Graph                 *graph = view_context->get_graph();
  GraphGUI              *gui = app->get_GUI();
    
  ComponentIndex        ind;
  CompInterface        *comp = 0;
  
  for ( ind = 0; ind < app->count_registered_components(); ind++ )
  {
    comp = app->get_registered_component( ind );
    
    if ( comp->get_component_name() == NETWORK_COMP_NAME )
      break;
    
    comp = 0;
  }
  
  if ( comp != 0 )
  {
    NetworkComp *net_comp = dynamic_cast<NetworkComp *>(comp);
    NetworkGUI  *net_gui  = net_comp->get_net_GUI();
    NetAttackMeasuresGUI *measure_dialog = net_gui->create_attack_measures_dialog( graph, net_comp, gui );
    
    if ( measure_dialog != 0 )
    {
      int res = measure_dialog->run();
      
      if ( res == GraphGUIModalWindow::GraphGUIModalWindow::APPLIED )
      {
        GraphicArea *g = gui->get_graphic_area( draw_data_curr->drawing_area );
        AttackMeasuresSet res_subset;
        res = net_comp->gready_measure_set( measure_dialog->get_result_measure_set(), res_subset, GraphViewPropertiesStorage::EDGE_SELECTED, g );
        
        if ( res_subset.size() == 0 )
          gui->show_message_dialog( "None of the attack triples covered by given attack measures is substantial." );
        else
        {
          GraphInformationGUI *info_wnd = gui->create_information_window( GraphGUI::DOCKABLE_GENERAL, 0, true );
                  
          net_comp->set_attack_measures_information( info_wnd->get_root_level(), res_subset );
            
          info_wnd->show( true );
          
          if ( !res )
            gui->show_message_dialog( "The given set of attack measures does not contain critical subset." );
        }        
        
        delete g;
      }
      
      delete measure_dialog;
    }
  }
  else
    gui->show_message_dialog( "Network component was not found." );
}

void on_about_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data_curr = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data_curr->graph_app;
  GraphGUI         *gui = app->get_GUI();
  
  gui->show_about_dialog();
}

gboolean
on_drawingarea_expose_event            (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphGUI         *gui = app->get_GUI();
  GraphView        *view = app->get_graph_view_context()->get_view();
  GraphicArea      *gr_area = gui->get_graphic_area( widget );
  GtkWidget        *status_bar  = lookup_widget( widget, "statusbar1");  
  string           status_str;
	
  view->display( gr_area );
  
  status_str = app->get_graph_view_context()->get_status_mngr()->get_current_status()->get_status_str();
  set_new_status_message(status_bar, status_str);

  if (gr_area != 0)
    delete gr_area;
  
  return TRUE;
}


gboolean
on_drawingarea_configure_event         (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphView        *view = app->get_graph_view_context()->get_view();
  
  gint           width;
  gint           height;
  Rectangle      display_rect;
  
  gdk_window_get_size( widget->window, &width, &height );
  
  display_rect.set_left_top_corner( TwoDPoint(0, 0) );
  display_rect.set_right_bottom_corner( TwoDPoint(width, height) );
  
  view->do_layout( display_rect ); 

  gdk_window_process_updates( widget->window, TRUE );
  update_scrollbars( widget, view );

  return TRUE;
}

void
on_vscrollbar1_value_changed           (GtkRange        *range,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphView        *view = app->get_graph_view_context()->get_view();
  
  GtkAdjustment *adjustment = gtk_range_get_adjustment( range );
  GdkRectangle   invalidate_rect;
  Rectangle      view_rect;  
  GtkWidget     *drawing_area = lookup_widget( GTK_WIDGET(range), "drawingarea" );
  gdouble       *last_vscroll_value = (gdouble*)g_object_get_data( G_OBJECT(range), "last_value" );
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  
  if ( view->get_layout() == GraphView::FIT_SELECTION_TO_WINDOW )
    view->set_layout( GraphView::ARBITRARY_SIZE );
  
  gdk_window_get_size( drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  view->set_vscroll_value( (OneDValue)DROUND(adjustment->value - *last_vscroll_value) );
  
  view_rect = view->get_view_rect();
  
  if ( view_rect.get_left_top_corner().get_y() > 0 )
  {
    view->set_vscroll_value( view_rect.get_left_top_corner().get_y() );
  }
  else if ( view_rect.get_right_bottom_corner().get_y() < invalidate_rect.height )
  {
    view->set_vscroll_value( view_rect.get_right_bottom_corner().get_y() - invalidate_rect.height );
  }
  
  *last_vscroll_value = adjustment->value;
 
  gdk_window_invalidate_rect( drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( drawing_area->window, TRUE );
}

void
on_hscrollbar1_value_changed           (GtkRange        *range,
                                        gpointer         user_data)
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  GraphView        *view = app->get_graph_view_context()->get_view();
  
  GtkAdjustment *adjustment = gtk_range_get_adjustment( range );
  GdkRectangle   invalidate_rect;
  Rectangle      view_rect;
  gdouble        *last_hscroll_value = (gdouble*)g_object_get_data( G_OBJECT(range), "last_value" );
  
  GtkWidget     *drawing_area = lookup_widget( GTK_WIDGET(range), "drawingarea" );
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  
  if ( view->get_layout() == GraphView::FIT_SELECTION_TO_WINDOW )
    view->set_layout( GraphView::ARBITRARY_SIZE );

  
  gdk_window_get_size( drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  view->set_hscroll_value( (OneDValue)DROUND(adjustment->value - *last_hscroll_value) );
  
  view_rect = view->get_view_rect();
    
  if ( view_rect.get_left_top_corner().get_x() > 0 )
  {
    view->set_hscroll_value( view_rect.get_left_top_corner().get_x() );
  }
  else if ( view_rect.get_right_bottom_corner().get_x() < invalidate_rect.width )
  {
    view->set_hscroll_value( view_rect.get_right_bottom_corner().get_x() - invalidate_rect.width );
  }
  
  *last_hscroll_value = adjustment->value;
  
  gdk_window_invalidate_rect( drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( drawing_area->window, TRUE );
}

void
on_attr_single_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget        *single_aw_mode_mnu  = lookup_widget( GTK_WIDGET(togglebutton), "single_aw_mode_mnu");    
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_toggle_button_get_active(togglebutton) );
  
  app->set_behavior_modes( ScenarioApp::SINGLE_ATTR_WINDOW, enable);
    
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(single_aw_mode_mnu), enable);    
}

void
on_info_single_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget        *single_iw_mode_mnu  = lookup_widget( GTK_WIDGET(togglebutton), "single_iw_mode_mnu");    
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_toggle_button_get_active(togglebutton) );
    
  app->set_behavior_modes( ScenarioApp::SINGLE_INFO_WINDOW, enable );
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(single_iw_mode_mnu), enable);          
}

void
on_mouse_over_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget        *aw_on_mouse_over_mode_mnu  = lookup_widget( GTK_WIDGET(togglebutton), "aw_on_mouse_over_mode_mnu");    
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_toggle_button_get_active(togglebutton) );
  
  app->set_behavior_modes( ScenarioApp::SHOW_ATTR_ON_MOUSE_OVER, enable );
    
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(aw_on_mouse_over_mode_mnu), enable);    
}

void on_select_node_toggled(GtkToggleButton *togglebutton, gpointer  user_data)
{
  GtkWidget        *aw_on_node_select_mode_mnu  = lookup_widget( GTK_WIDGET(togglebutton), "aw_on_node_select_mode_mnu");    
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_toggle_button_get_active(togglebutton) );
  
  app->set_behavior_modes( ScenarioApp::SHOW_ATTR_ON_NODE_SELECT, enable );
    
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(aw_on_node_select_mode_mnu), enable);    
}

void on_edge_selecting_toggled(GtkToggleButton *togglebutton, gpointer user_data)
{
  GtkWidget        *edge_selecting_mode_mnu  = lookup_widget( GTK_WIDGET(togglebutton), "edge_selecting_mode_mnu");    
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_toggle_button_get_active(togglebutton) );
  
  app->set_behavior_modes( ScenarioApp::EDGE_SELECTING, enable );
    
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(edge_selecting_mode_mnu), enable);  
}

void on_load_close_toggled(GtkToggleButton *togglebutton, gpointer user_data)
{
  GtkWidget        *mode_mnu  = lookup_widget( GTK_WIDGET(togglebutton), "close_gw_after_load_mode_mnu");    
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool enable = (bool)( gtk_toggle_button_get_active(togglebutton) );
  
  app->set_behavior_modes( ScenarioApp::CLOSE_OPEN_DIALOG_AFTER_GRAPH_LOAD, enable );
    
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode_mnu), enable);  
}

void on_dock_attr_mode_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  bool docked_node_attr_windows = (bool)( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) );
  draw_data->graph_app->set_extra_behavior_modes( ScenarioApp::DOCK_ATTR_ON_START, docked_node_attr_windows );
}

void on_dock_info_mode_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  bool docked_info_windows = (bool)( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) );
  draw_data->graph_app->set_extra_behavior_modes( ScenarioApp::DOCK_INFO_ON_START, docked_info_windows );
}

void on_attr_aliases_mode_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp      *app = draw_data->graph_app;
  
  bool use_attr_aliases = (bool)( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) );
  
  app->set_extra_behavior_modes( ScenarioApp::USE_ATTR_ALIASES, use_attr_aliases );
  
  if ( use_attr_aliases )
    app->get_graph_view_context()->get_graph()->get_graph_attr_name_storage()->set_curr_alias_set( 0 );
  else
    app->get_graph_view_context()->get_graph()->get_graph_attr_name_storage()->set_curr_alias_set( -1 );
}


void on_show_graph_statistics( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData  *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp       *app = draw_data->graph_app;
  GraphViewContext  *view_context = app->get_graph_view_context();
  Graph             *graph = view_context->get_graph();
  GraphGUI          *gui = app->get_GUI();  
  
  GraphStatistics    statistics;
  
  statistics.calc_nodes_edges = true;
  statistics.calc_path_depth = true;
  
  statistics.nodes_to_count["({accept = 1; | final = 1;})"] = StringLongTriple( "Accepting/final nodes" );
  statistics.nodes_to_count["{final = 0;}"] = StringLongTriple( "Non-final nodes" );
  statistics.pathes_to_count[StringPair("", "{final = 1;}")] = StringLongTriple( "DFS pathes from the initial node to a final node" );
  
  graph->get_graph_statistics( statistics );
  
  GraphInformationGUI* info_window = gui->create_graph_statistics_info_window( statistics );
  
  if ( info_window != 0 )
    info_window->show( true );
}

void on_show_gm_on_load_mode( GtkMenuItem *menuitem, gpointer user_data )
{
  GraphDrawingData  *draw_data = (GraphDrawingData*)user_data;
  ScenarioApp       *app = draw_data->graph_app;
  bool mode = (bool)( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) );
  app->set_extra_behavior_modes( ScenarioApp::OUTPUT_GEN_GRAPH_METRICS, mode );
}


