/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntQuadruple;
import edu.stanford.nlp.util.IntTriple;
import edu.stanford.nlp.util.IntUni;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntTuple
implements Serializable {
    int[] elements;
    private static final long serialVersionUID = 7266305463893511982L;

    public IntTuple(int[] arr) {
        this.elements = arr;
    }

    public IntTuple(int num) {
        this.elements = new int[num];
    }

    public int get(int num) {
        return this.elements[num];
    }

    public void set(int num, int val) {
        this.elements[num] = val;
    }

    public void shiftLeft() {
        for (int j = 0; j < this.elements.length - 1; ++j) {
            this.elements[j] = this.elements[j + 1];
        }
        this.elements[this.elements.length - 1] = 0;
    }

    public IntTuple getCopy() {
        IntTuple copy = IntTuple.getIntTuple(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            copy.set(i, this.elements[i]);
        }
        return copy;
    }

    public int[] elems() {
        return this.elements;
    }

    public boolean equals(Object iO) {
        if (!(iO instanceof IntTuple)) {
            return false;
        }
        IntTuple i = (IntTuple)iO;
        if (i.elements.length != this.elements.length) {
            return false;
        }
        for (int j = 0; j < this.elements.length; ++j) {
            if (this.elements[j] == i.get(j)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int sum = 0;
        for (int element : this.elements) {
            sum = sum * 17 + element;
        }
        return sum;
    }

    public int length() {
        return this.elements.length;
    }

    public IntTuple() {
    }

    public static IntTuple getIntTuple(int num) {
        if (num == 1) {
            return new IntUni();
        }
        if (num == 2) {
            return new IntPair();
        }
        if (num == 3) {
            return new IntTriple();
        }
        if (num == 4) {
            return new IntQuadruple();
        }
        return new IntTuple(num);
    }

    public static IntTuple getIntTuple(ArrayList<Integer> integers) {
        IntTuple t = IntTuple.getIntTuple(integers.size());
        for (int i = 0; i < t.length(); ++i) {
            t.set(i, integers.get(i));
        }
        return t;
    }

    public String toString() {
        String name = "";
        for (int i = 0; i < this.elements.length; ++i) {
            name = name + this.get(i);
            if (i >= this.elements.length - 1) continue;
            name = name + " ";
        }
        return name;
    }

    public static IntTuple concat(IntTuple t1, IntTuple t2) {
        int n1 = t1.length();
        int n2 = t2.length();
        IntTuple res = IntTuple.getIntTuple(n1 + n2);
        for (int j = 0; j < n1; ++j) {
            res.set(j, t1.get(j));
        }
        for (int i = 0; i < n2; ++i) {
            res.set(n1 + i, t2.get(i));
        }
        return res;
    }

    public void print() {
        String s = this.toString();
        System.out.print(s);
    }
}

