/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtils {
    protected ArrayUtils() {
    }

    public static double[] flatten(double[][] array) {
        int size = 0;
        for (double[] a : array) {
            size += a.length;
        }
        double[] newArray = new double[size];
        int i = 0;
        double[][] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] a;
            for (double d : a = arr$[i$]) {
                newArray[i++] = d;
            }
        }
        return newArray;
    }

    public static double[][] to2D(double[] array, int dim1Size) {
        int dim2Size = array.length / dim1Size;
        return ArrayUtils.to2D(array, dim1Size, dim2Size);
    }

    public static double[][] to2D(double[] array, int dim1Size, int dim2Size) {
        double[][] newArray = new double[dim1Size][dim2Size];
        int k = 0;
        for (int i = 0; i < newArray.length; ++i) {
            for (int j = 0; j < newArray[i].length; ++j) {
                newArray[i][j] = array[k++];
            }
        }
        return newArray;
    }

    public static double[] removeAt(double[] array, int index) {
        if (array == null) {
            return null;
        }
        if (index < 0 || index >= array.length) {
            return array;
        }
        double[] retVal = new double[array.length - 1];
        for (int i = 0; i < array.length; ++i) {
            if (i < index) {
                retVal[i] = array[i];
                continue;
            }
            if (i <= index) continue;
            retVal[i - 1] = array[i];
        }
        return retVal;
    }

    public static Object[] removeAt(Object[] array, int index) {
        if (array == null) {
            return null;
        }
        if (index < 0 || index >= array.length) {
            return array;
        }
        Object[] retVal = (Object[])Array.newInstance(array[0].getClass(), array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i < index) {
                retVal[i] = array[i];
                continue;
            }
            if (i <= index) continue;
            retVal[i - 1] = array[i];
        }
        return retVal;
    }

    public static String toString(int[][] a) {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < a.length; ++i) {
            result.append(Arrays.toString(a[i]));
            if (i >= a.length - 1) continue;
            result.append(",");
        }
        result.append("]");
        return result.toString();
    }

    public static boolean equalContents(int[][] xs, int[][] ys) {
        if (xs == null && ys != null) {
            return false;
        }
        if (ys == null) {
            return false;
        }
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = xs.length - 1; i >= 0; --i) {
            if (ArrayUtils.equalContents(xs[i], ys[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[][] xs, double[][] ys) {
        if (xs == null && ys != null) {
            return false;
        }
        if (ys == null) {
            return false;
        }
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = xs.length - 1; i >= 0; --i) {
            if (Arrays.equals(xs[i], ys[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalContents(int[] xs, int[] ys) {
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = xs.length - 1; i >= 0; --i) {
            if (xs[i] == ys[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[][] xs, boolean[][] ys) {
        if (xs == null && ys != null) {
            return false;
        }
        if (ys == null) {
            return false;
        }
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = xs.length - 1; i >= 0; --i) {
            if (Arrays.equals(xs[i], ys[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean contains(T[] a, T o) {
        for (T item : a) {
            if (!item.equals(o)) continue;
            return true;
        }
        return false;
    }

    public static <T> Set<T> asSet(T[] a) {
        return new HashSet<T>(Arrays.asList(a));
    }

    public static void fill(double[][] d, double val) {
        for (int i = 0; i < d.length; ++i) {
            Arrays.fill(d[i], val);
        }
    }

    public static void fill(double[][][] d, double val) {
        for (int i = 0; i < d.length; ++i) {
            ArrayUtils.fill(d[i], val);
        }
    }

    public static void fill(double[][][][] d, double val) {
        for (int i = 0; i < d.length; ++i) {
            ArrayUtils.fill(d[i], val);
        }
    }

    public static void fill(boolean[][] d, boolean val) {
        for (int i = 0; i < d.length; ++i) {
            Arrays.fill(d[i], val);
        }
    }

    public static void fill(boolean[][][] d, boolean val) {
        for (int i = 0; i < d.length; ++i) {
            ArrayUtils.fill(d[i], val);
        }
    }

    public static void fill(boolean[][][][] d, boolean val) {
        for (int i = 0; i < d.length; ++i) {
            ArrayUtils.fill(d[i], val);
        }
    }

    public static double[] toDouble(float[] a) {
        double[] d = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i];
        }
        return d;
    }

    public static double[] toDouble(int[] array) {
        double[] rv = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            rv[i] = array[i];
        }
        return rv;
    }

    public static List<Integer> asList(int[] array) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i : array) {
            l.add(i);
        }
        return l;
    }

    public static double[] asArray(List<Double> d) {
        double[] newD = new double[d.size()];
        int i = 0;
        for (Double j : d) {
            newD[i++] = j;
        }
        return newD;
    }

    public static void main(String[] args) {
        Object[] strings = new String[]{"a", "b", "c"};
        for (Object string : strings = (String[])ArrayUtils.removeAt(strings, 2)) {
            System.err.println((String)string);
        }
        System.err.println(ArrayUtils.asSet(new String[]{"larry", "moe", "curly"}));
    }

    public static int[] copy(int[] i) {
        if (i == null) {
            return null;
        }
        int[] newI = new int[i.length];
        System.arraycopy(i, 0, newI, 0, i.length);
        return newI;
    }

    public static int[][] copy(int[][] i) {
        if (i == null) {
            return null;
        }
        int[][] newI = new int[i.length][];
        for (int j = 0; j < newI.length; ++j) {
            newI[j] = ArrayUtils.copy(i[j]);
        }
        return newI;
    }

    public static double[] copy(double[] d) {
        if (d == null) {
            return null;
        }
        double[] newD = new double[d.length];
        System.arraycopy(d, 0, newD, 0, d.length);
        return newD;
    }

    public static double[][] copy(double[][] d) {
        if (d == null) {
            return null;
        }
        double[][] newD = new double[d.length][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static double[][][] copy(double[][][] d) {
        if (d == null) {
            return null;
        }
        double[][][] newD = new double[d.length][][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static float[] copy(float[] d) {
        if (d == null) {
            return null;
        }
        float[] newD = new float[d.length];
        System.arraycopy(d, 0, newD, 0, d.length);
        return newD;
    }

    public static float[][] copy(float[][] d) {
        if (d == null) {
            return null;
        }
        float[][] newD = new float[d.length][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static float[][][] copy(float[][][] d) {
        if (d == null) {
            return null;
        }
        float[][][] newD = new float[d.length][][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static String toString(boolean[][] b) {
        String result = "[";
        for (int i = 0; i < b.length; ++i) {
            result = result + Arrays.toString(b[i]);
            if (i >= b.length - 1) continue;
            result = result + ",";
        }
        result = result + "]";
        return result;
    }

    public static long[] toPrimitive(Long[] in) {
        return ArrayUtils.toPrimitive(in, 0L);
    }

    public static int[] toPrimitive(Integer[] in) {
        return ArrayUtils.toPrimitive(in, 0);
    }

    public static short[] toPrimitive(Short[] in) {
        return ArrayUtils.toPrimitive(in, (short)0);
    }

    public static char[] toPrimitive(Character[] in) {
        return ArrayUtils.toPrimitive(in, '\u0000');
    }

    public static long[] toPrimitive(Long[] in, long valueForNull) {
        if (in == null) {
            return null;
        }
        long[] out2 = new long[in.length];
        for (int i = 0; i < in.length; ++i) {
            Long b = in[i];
            out2[i] = b == null ? valueForNull : b;
        }
        return out2;
    }

    public static int[] toPrimitive(Integer[] in, int valueForNull) {
        if (in == null) {
            return null;
        }
        int[] out2 = new int[in.length];
        for (int i = 0; i < in.length; ++i) {
            Integer b = in[i];
            out2[i] = b == null ? valueForNull : b;
        }
        return out2;
    }

    public static short[] toPrimitive(Short[] in, short valueForNull) {
        if (in == null) {
            return null;
        }
        short[] out2 = new short[in.length];
        for (int i = 0; i < in.length; ++i) {
            Short b = in[i];
            out2[i] = b == null ? valueForNull : b;
        }
        return out2;
    }

    public static char[] toPrimitive(Character[] in, char valueForNull) {
        if (in == null) {
            return null;
        }
        char[] out2 = new char[in.length];
        for (int i = 0; i < in.length; ++i) {
            Character b = in[i];
            out2[i] = b == null ? valueForNull : b.charValue();
        }
        return out2;
    }
}

