/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RelabelNode
extends TsurgeonPattern {
    private static final Pattern regexPattern = Pattern.compile("^/(.*)/$");
    private static final Pattern quotexPattern = Pattern.compile("^\\|(.*)\\|$");
    private final boolean fixedNewLabel;
    private String newLabel;
    private Pattern labelRegex;
    private int groupNumber;

    public RelabelNode(TsurgeonPattern child, String newLabel) {
        super("relabel", new TsurgeonPattern[]{child});
        Matcher m = quotexPattern.matcher(newLabel);
        this.newLabel = m.matches() ? m.group(1) : newLabel;
        this.fixedNewLabel = true;
    }

    public RelabelNode(TsurgeonPattern child, String labelRegex, int groupNumber) {
        super("relabel", new TsurgeonPattern[]{child});
        this.fixedNewLabel = false;
        Matcher m = regexPattern.matcher(labelRegex);
        if (!m.matches()) {
            throw new RuntimeException("Illegal label regex: " + labelRegex);
        }
        this.labelRegex = Pattern.compile(m.group(1));
        this.groupNumber = groupNumber;
    }

    public Tree evaluate(Tree t, TregexMatcher tm) {
        Tree nodeToRelabel = this.children[0].evaluate(t, tm);
        if (this.fixedNewLabel) {
            nodeToRelabel.label().setValue(this.newLabel);
        } else {
            Matcher m = this.labelRegex.matcher(nodeToRelabel.label().value());
            if (m.find()) {
                nodeToRelabel.label().setValue(m.group(this.groupNumber));
            }
        }
        return t;
    }

    public String toString() {
        String result = this.fixedNewLabel ? this.label + "(" + this.children[0].toString() + "," + this.newLabel + ")" : this.label + "(" + this.children[0].toString() + "," + this.labelRegex.toString() + "," + this.groupNumber + ")";
        return result;
    }
}

