/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.negra.NegraPennTreeReaderFactory;
import edu.stanford.nlp.trees.international.negra.TigerHeadFinder;

public class NegraPennLanguagePack
extends AbstractTreebankLanguagePack {
    private static final long serialVersionUID = 9081305982861675328L;
    private boolean leaveGF = false;
    private boolean limitedGF = false;
    private static String[] gfToKeepArray = new String[]{"SB", "OA", "DA"};
    private static final String NEGRA_ENCODING = "ISO-8859-1";
    private static final String[] evalBignoredTags = new String[]{"$.", "$,"};
    private static final String[] negraSFPunctTags = new String[]{"$."};
    private static final String[] negraSFPunctWords = new String[]{".", "!", "?"};
    private static final String[] negraPunctTags = new String[]{"$.", "$,", "$*LRB*"};
    private static final String[] negraPunctWords = new String[]{"-", ",", ";", ":", "!", "?", "/", ".", "...", "\u00b7", "'", "\"", "(", ")", "*LRB*", "*RRB*"};
    private static char[] annotationIntroducingChars = new char[]{'%', '=', '|', '#', '^', '~'};
    private static String[] pennStartSymbols = new String[]{"ROOT"};

    public NegraPennLanguagePack() {
        this(false);
    }

    public NegraPennLanguagePack(boolean leaveGF) {
        this(leaveGF, '-');
    }

    public NegraPennLanguagePack(boolean leaveGF, char gfChar) {
        this(false, leaveGF, gfChar);
    }

    public NegraPennLanguagePack(boolean useLimitedGF, boolean leaveGF, char gfChar) {
        super(gfChar);
        this.leaveGF = leaveGF;
        this.limitedGF = useLimitedGF;
    }

    public String[] punctuationTags() {
        return negraPunctTags;
    }

    public String[] punctuationWords() {
        return negraPunctWords;
    }

    public String[] sentenceFinalPunctuationTags() {
        return negraSFPunctTags;
    }

    public String[] sentenceFinalPunctuationWords() {
        return negraSFPunctWords;
    }

    public String basicCategory(String category) {
        String basicCat = super.basicCategory(category);
        if (!this.leaveGF) {
            basicCat = this.stripGF(basicCat);
        }
        return basicCat;
    }

    public String stripGF(String category) {
        if (category == null) {
            return null;
        }
        int index = category.lastIndexOf(this.gfCharacter);
        if (!(index <= 0 || this.limitedGF && NegraPennLanguagePack.containsKeptGF(category, index))) {
            category = category.substring(0, index);
        }
        return category;
    }

    private static boolean containsKeptGF(String category, int index) {
        for (String gf : gfToKeepArray) {
            int gfLength = gf.length();
            if (gfLength >= category.length() - index || !category.substring(index + 1, index + 1 + gfLength).equals(gf)) continue;
            return true;
        }
        return false;
    }

    public String[] evalBIgnoredPunctuationTags() {
        return evalBignoredTags;
    }

    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    public String[] startSymbols() {
        return pennStartSymbols;
    }

    public String getEncoding() {
        return NEGRA_ENCODING;
    }

    public String treebankFileExtension() {
        return "mrg";
    }

    public boolean isLeaveGF() {
        return this.leaveGF;
    }

    public void setLeaveGF(boolean leaveGF) {
        this.leaveGF = leaveGF;
    }

    public boolean isLimitedGF() {
        return this.limitedGF;
    }

    public void setLimitedGF(boolean limitedGF) {
        this.limitedGF = limitedGF;
    }

    public TreeReaderFactory treeReaderFactory() {
        return new NegraPennTreeReaderFactory();
    }

    public HeadFinder headFinder() {
        return new TigerHeadFinder(this);
    }
}

