/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreebankTokenizer;
import edu.stanford.nlp.trees.SimpleTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTokenizerFactory;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PennTreeReader
implements TreeReader {
    private Reader in;
    private Tokenizer<String> st;
    private TreeNormalizer tn;
    private TreeFactory tf;
    private static final boolean DEBUG = false;
    private int wordIndex;

    public PennTreeReader(Reader in) {
        this(in, new SimpleTreeFactory());
    }

    public PennTreeReader(Reader in, TreeFactory tf) {
        this(in, tf, null, new PennTreebankTokenizer(in));
    }

    public PennTreeReader(Reader in, Tokenizer<String> st) {
        this(in, new SimpleTreeFactory(), null, st);
    }

    public PennTreeReader(Reader in, TreeFactory tf, TreeNormalizer tn) {
        this(in, tf, tn, new PennTreebankTokenizer(in));
    }

    public PennTreeReader(Reader in, TreeFactory tf, TreeNormalizer tn, Tokenizer<String> st) {
        this.in = in;
        this.tf = tf;
        this.tn = tn;
        this.st = st;
        String first = st.peek();
        if (first != null && first.startsWith("*x*x*x")) {
            int foundCount = 0;
            while (foundCount < 4 && st.hasNext()) {
                first = st.next();
                if (first == null || !first.startsWith("*x*x*x")) continue;
                ++foundCount;
            }
        }
    }

    @Override
    public Tree readTree() throws IOException {
        Tree tr = null;
        while (tr == null) {
            if (!this.st.hasNext()) {
                return null;
            }
            tr = this.readTreeHelper();
        }
        return tr;
    }

    private Tree readTreeHelper() throws IOException {
        this.wordIndex = 0;
        Tree tr = this.readTree(this.st.next());
        if (tr == null || this.tn == null) {
            return tr;
        }
        return this.tn.normalizeWholeTree(tr, this.tf);
    }

    private Tree readTree(String token) throws IOException {
        if (token == null) {
            return null;
        }
        if (token.equals(")")) {
            System.err.println("Expecting start of tree; found surplus close parenthesis ')'. Ignoring it.");
            return null;
        }
        if (token.equals("(")) {
            String name = this.st.peek();
            name = name.equals("(") || name.equals(")") ? null : this.st.next();
            if (this.tn != null) {
                name = this.tn.normalizeNonterminal(name);
            }
            return this.tf.newTreeNode(name, this.readTrees());
        }
        String name = this.tn != null ? this.tn.normalizeTerminal(token) : token;
        Tree leaf = this.tf.newLeaf(name);
        if (leaf.label() instanceof HasIndex) {
            HasIndex hi = (HasIndex)((Object)leaf.label());
            hi.setIndex(this.wordIndex);
        }
        ++this.wordIndex;
        return leaf;
    }

    private List<Tree> readTrees() throws IOException {
        ArrayList<Tree> parseTrees = new ArrayList<Tree>();
        String nextToken = null;
        String fullToken = "";
        while (this.st.hasNext() && !(nextToken = this.st.next()).equals(")")) {
            if (nextToken.equals("(")) {
                if (!fullToken.equals("")) {
                    parseTrees.add(this.readTree(fullToken));
                    fullToken = "";
                }
                parseTrees.add(this.readTree(nextToken));
                continue;
            }
            fullToken = fullToken + (fullToken.equals("") ? "" : " ") + nextToken;
        }
        if (!")".equals(nextToken)) {
            throw new IOException("Expecting right paren found eof");
        }
        if (!fullToken.equals("")) {
            parseTrees.add(this.readTree(fullToken));
        }
        return parseTrees;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static TokenizerFactory<Tree> tokenizerFactory(final TreeFactory tf, final TreeNormalizer tn, final Tokenizer<String> stringTokenizer) {
        return new TreeTokenizerFactory(new TreeReaderFactory(){

            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, tf, tn, stringTokenizer);
            }
        });
    }

    public Iterator<Tree> asTreeIterator() {
        return new Iterator<Tree>(){
            private Tree next = this.advance();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Tree next() {
                if (this.next == null) {
                    throw new NoSuchElementException("PennTreeReader exhausted");
                }
                Tree t = this.next;
                this.next = this.advance();
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private Tree advance() {
                Tree t = PennTreeReader.this.readTreeThrowRuntime();
                if (t == null) {
                    PennTreeReader.this.closeThrowRuntime();
                }
                return t;
            }
        };
    }

    private Tree readTreeThrowRuntime() {
        Tree t;
        try {
            t = this.readTree();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    private void closeThrowRuntime() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        try {
            LabeledScoredTreeFactory tf = new LabeledScoredTreeFactory();
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), "UTF-8"));
            PennTreeReader tr = new PennTreeReader((Reader)r, tf);
            Tree t = tr.readTree();
            while (t != null) {
                System.out.println(t);
                System.out.println();
                t = tr.readTree();
            }
            ((Reader)r).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

