/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammaticalRelation
implements Comparable<GrammaticalRelation>,
Serializable {
    private static final long serialVersionUID = 892618003417550128L;
    protected static Map<Class<? extends GrammaticalRelationAnnotation>, GrammaticalRelation> annotationsToRelations = Generics.newHashMap();
    protected static Map<GrammaticalRelation, Class<? extends GrammaticalRelationAnnotation>> relationsToAnnotatoins = Generics.newHashMap();
    protected static Map<String, GrammaticalRelation> stringsToRelations = Generics.newHashMap();
    public static final GrammaticalRelation GOVERNOR = new GrammaticalRelation("gov", "governor", GovernorGRAnnotation.class, null);
    public static final GrammaticalRelation DEPENDENT = new GrammaticalRelation("dep", "dependent", DependendentGRAnnotation.class, null);
    public static final GrammaticalRelation KILL = new GrammaticalRelation("KILL", "dummy relation kill", KillGRAnnotation.class, null);
    private final String shortName;
    private final String longName;
    private final GrammaticalRelation parent;
    private final List<GrammaticalRelation> children = new ArrayList<GrammaticalRelation>();
    private final Pattern sourcePattern;
    private final List<TregexPattern> targetPatterns = new ArrayList<TregexPattern>();
    private final String specific;

    public static Class<? extends GrammaticalRelationAnnotation> getAnnotationClass(GrammaticalRelation relation) {
        return relationsToAnnotatoins.get(relation);
    }

    public static GrammaticalRelation getRelation(Class<? extends GrammaticalRelationAnnotation> annotation) {
        return annotationsToRelations.get(annotation);
    }

    public static GrammaticalRelation valueOf(String s, Collection<GrammaticalRelation> values) {
        for (GrammaticalRelation reln : values) {
            if (!reln.toString().equals(s)) continue;
            return reln;
        }
        return null;
    }

    public static GrammaticalRelation valueOf(String s) {
        GrammaticalRelation reln = GrammaticalRelation.valueOf(s, stringsToRelations.values());
        if (reln == null) {
            reln = EnglishGrammaticalRelations.valueOf(s);
        }
        if (reln == null) {
            String[] names = s.split("_");
            String specific = names.length > 1 ? names[1] : null;
            reln = new GrammaticalRelation(names[0], null, null, null, specific);
        }
        return reln;
    }

    public boolean isFromString() {
        return this.longName == null;
    }

    public GrammaticalRelation(String shortName, String longName, Class<? extends GrammaticalRelationAnnotation> annotation, GrammaticalRelation parent, String sourcePattern, String[] targetPatterns, String specificString) {
        this.shortName = shortName;
        this.longName = longName;
        this.parent = parent;
        this.specific = specificString;
        if (parent != null) {
            parent.addChild(this);
        }
        if (annotation != null) {
            if (annotationsToRelations.put(annotation, this) != null) {
                throw new IllegalArgumentException("Annotation cannot be associated with more than one relation!");
            }
            if (relationsToAnnotatoins.put(this, annotation) != null) {
                throw new IllegalArgumentException("There should only ever be one instance of each relation!");
            }
        }
        if (sourcePattern != null) {
            try {
                this.sourcePattern = Pattern.compile(sourcePattern);
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("Bad pattern: " + sourcePattern);
            }
        } else {
            this.sourcePattern = null;
        }
        for (String pattern : targetPatterns) {
            try {
                TregexPattern p = TregexPattern.compile(pattern);
                this.targetPatterns.add(p);
            }
            catch (ParseException pe) {
                throw new RuntimeException("Bad pattern: " + pattern, pe);
            }
        }
        GrammaticalRelation previous = stringsToRelations.put(this.toString(), this);
        if (previous != null && !previous.isFromString()) {
            throw new IllegalArgumentException("There is already a relation named " + this.toString() + '!');
        }
    }

    public GrammaticalRelation(String shortName, String longName, Class<? extends GrammaticalRelationAnnotation> annotation, GrammaticalRelation parent, String sourcePattern, String[] targetPatterns) {
        this(shortName, longName, annotation, parent, sourcePattern, targetPatterns, null);
    }

    public GrammaticalRelation(String shortName, String longName, Class<? extends GrammaticalRelationAnnotation> annotation, GrammaticalRelation parent) {
        this(shortName, longName, annotation, parent, null, StringUtils.EMPTY_STRING_ARRAY, null);
    }

    public GrammaticalRelation(String shortName, String longName, Class<? extends GrammaticalRelationAnnotation> annotation, GrammaticalRelation parent, String specificString) {
        this(shortName, longName, annotation, parent, null, StringUtils.EMPTY_STRING_ARRAY, specificString);
    }

    private void addChild(GrammaticalRelation child) {
        this.children.add(child);
    }

    public Collection<Tree> getRelatedNodes(Tree t, Tree root) {
        LinkedHashSet<Tree> nodeList = new LinkedHashSet<Tree>();
        for (TregexPattern p : this.targetPatterns) {
            if (root.value() == null) {
                root.setValue("ROOT");
            }
            TregexMatcher m = p.matcher(root);
            while (m.find()) {
                if (m.getMatch() != t) continue;
                nodeList.add(m.getNode("target"));
            }
        }
        return nodeList;
    }

    public boolean isApplicable(Tree t) {
        return t.value() != null && this.sourcePattern != null && this.sourcePattern.matcher(t.value()).matches();
    }

    public boolean isAncestor(GrammaticalRelation gr) {
        while (gr != null) {
            if (this == gr) {
                return true;
            }
            gr = gr.parent;
        }
        return false;
    }

    public final String toString() {
        if (this.specific == null) {
            return this.shortName;
        }
        return this.shortName + '_' + this.specific;
    }

    public String toPrettyString() {
        StringBuilder buf = new StringBuilder("\n");
        this.toPrettyString(0, buf);
        return buf.toString();
    }

    private void toPrettyString(int indentLevel, StringBuilder buf) {
        for (int i = 0; i < indentLevel; ++i) {
            buf.append("  ");
        }
        buf.append(this.shortName).append(": ").append(this.targetPatterns);
        for (GrammaticalRelation child : this.children) {
            buf.append('\n');
            child.toPrettyString(indentLevel + 1, buf);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof String) {
            new Throwable("Warning: comparing GrammaticalRelation to String").printStackTrace();
            return this.toString().equals(o);
        }
        if (!(o instanceof GrammaticalRelation)) {
            return false;
        }
        GrammaticalRelation gr = (GrammaticalRelation)o;
        return this.shortName.equals(gr.shortName) && (this.specific == gr.specific || this.specific != null && this.specific.equals(gr.specific));
    }

    public int hashCode() {
        if (this.specific != null) {
            return this.shortName.hashCode() ^ this.specific.hashCode();
        }
        return this.shortName.hashCode();
    }

    @Override
    public int compareTo(GrammaticalRelation o) {
        String thisN = this.toString();
        String oN = o.toString();
        return thisN.compareTo(oN);
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getSpecific() {
        return this.specific;
    }

    public GrammaticalRelation getParent() {
        return this.parent;
    }

    public static void main(String[] args) {
        String[] names;
        for (String name : names = new String[]{"dep", "pred", "prep_to"}) {
            GrammaticalRelation reln = GrammaticalRelation.valueOf(name);
            System.out.println("Data for GrammaticalRelation loaded as valueOf(\"" + name + "\"):");
            System.out.println("\tShort name:    " + reln.getShortName());
            System.out.println("\tLong name:     " + reln.getLongName());
            System.out.println("\tSpecific name: " + reln.getSpecific());
        }
    }

    public static class KillGRAnnotation
    extends GrammaticalRelationAnnotation {
    }

    public static class DependendentGRAnnotation
    extends GrammaticalRelationAnnotation {
    }

    public static class GovernorGRAnnotation
    extends GrammaticalRelationAnnotation {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class GrammaticalRelationAnnotation
    implements CoreAnnotation<Set<TreeGraphNode>> {
        @Override
        public Class<Set<TreeGraphNode>> getType() {
            return Set.class;
        }
    }
}

