/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.BasicDocument;
import edu.stanford.nlp.ling.Document;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.process.AbstractListProcessor;
import edu.stanford.nlp.process.StripTagsProcessor;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordToTaggedWordProcessor<IN extends HasWord, L, F>
extends AbstractListProcessor<IN, HasWord, L, F> {
    protected char splitChar;

    @Override
    public List<HasWord> process(List<IN> words) {
        ArrayList<HasWord> result = new ArrayList<HasWord>();
        for (HasWord w : words) {
            result.add(this.splitTag(w));
        }
        return result;
    }

    private HasWord splitTag(HasWord w) {
        if (this.splitChar == '\u0000') {
            return w;
        }
        String s = w.word();
        int split = s.lastIndexOf(this.splitChar);
        if (split <= 0) {
            return w;
        }
        String word = s.substring(0, split);
        String tag = s.substring(split + 1, s.length());
        return new TaggedWord(word, tag);
    }

    public WordToTaggedWordProcessor() {
        this('/');
    }

    public WordToTaggedWordProcessor(char splitChar) {
        this.splitChar = splitChar;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: java edu.stanford.nlp.process.WordToTaggedWordProcessor fileOrUrl");
            System.exit(0);
        }
        String filename = args[0];
        try {
            Document d;
            if (filename.startsWith("http://")) {
                BasicDocument dpre = new BasicDocument().init(new URL(filename));
                StripTagsProcessor notags = new StripTagsProcessor();
                d = notags.processDocument(dpre);
            } else {
                d = new BasicDocument().init(new File(filename));
            }
            WordToTaggedWordProcessor proc = new WordToTaggedWordProcessor();
            Document sentd = proc.processDocument(d);
            int i = 0;
            for (HasWord w : sentd) {
                System.out.println(i + ": " + w);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

