/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.AbstractEval;
import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.ConstituentFactory;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredConstituentFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LabeledConstituentEval
extends AbstractEval {
    private static final boolean DEBUG = false;
    private ConstituentFactory cf = new LabeledScoredConstituentFactory();
    private TreeFactory tf = new LabeledScoredTreeFactory();
    private TreebankLanguagePack tlp;

    protected Tree stripLeaves(Tree tree) {
        if (tree.isLeaf()) {
            return null;
        }
        if (tree.isPreTerminal()) {
            return this.tf.newLeaf(tree.label());
        }
        int numKids = tree.numChildren();
        ArrayList<Tree> children = new ArrayList<Tree>(numKids);
        for (int cNum = 0; cNum < numKids; ++cNum) {
            children.add(this.stripLeaves(tree.getChild(cNum)));
        }
        return this.tf.newTreeNode(tree.label(), children);
    }

    Set makeObjects(Tree tree) {
        Tree noLeafTree = this.stripLeaves(tree);
        HashSet<Constituent> set = new HashSet<Constituent>();
        if (noLeafTree == null) {
            return set;
        }
        if (this.tlp.isStartSymbol(noLeafTree.label().value())) {
            for (int i = 0; i < noLeafTree.children().length - 1; ++i) {
                set.addAll(noLeafTree.children()[i].constituents(this.cf));
            }
        } else {
            set.addAll(noLeafTree.constituents(this.cf));
        }
        return set;
    }

    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        if (guess.yield().size() != gold.yield().size()) {
            pw.println("Warning: yield differs:");
            pw.println("Guess: " + guess.yield());
            pw.println("Gold:  " + gold.yield());
        }
        super.evaluate(guess, gold, pw);
    }

    public LabeledConstituentEval(String str, boolean runningAverages, TreebankLanguagePack tlp) {
        super(str, runningAverages);
        this.tlp = tlp;
    }

    public static void main(String[] args) {
        TreebankLangParserParams tlpp = new EnglishTreebankParserParams();
        if (args.length < 2 || args.length > 3) {
            System.err.println("usage: LabeledConstituentEval gold gues [TLPP]");
            return;
        }
        if (args.length > 2) {
            try {
                Object o = Class.forName(args[2]).newInstance();
                tlpp = (TreebankLangParserParams)o;
            }
            catch (Exception e) {
                System.err.println("Couldn't instantiate: " + args[2]);
            }
        }
        DiskTreebank tb1 = tlpp.diskTreebank();
        DiskTreebank tb2 = tlpp.diskTreebank();
        PrintWriter pw = tlpp.pw();
        LabeledConstituentEval lce = new LabeledConstituentEval("LP/LR", true, tlpp.treebankLanguagePack());
        TreeTransformer tc = tlpp.collinizer();
        tb1.loadPath(args[0]);
        tb2.loadPath(args[1]);
        System.err.println(tb1.textualSummary());
        System.err.println(tb2.textualSummary());
        Iterator tb2it = ((AbstractCollection)tb2).iterator();
        for (Tree t : tb1) {
            if (!tb2it.hasNext()) continue;
            Tree tGuess = (Tree)tb2it.next();
            lce.evaluate(tc.transformTree(t), tc.transformTree(tGuess), pw);
        }
        pw.println();
        lce.display(true, pw);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CBEval
    extends LabeledConstituentEval {
        private double cb = 0.0;
        private double num = 0.0;
        private double zeroCB = 0.0;

        protected void checkCrossing(Set<Constituent> s1, Set<Constituent> s2) {
            double c = 0.0;
            for (Constituent constit : s1) {
                if (!constit.crosses(s2)) continue;
                c += 1.0;
            }
            if (c == 0.0) {
                this.zeroCB += 1.0;
            }
            this.cb += c;
            this.num += 1.0;
        }

        @Override
        public void evaluate(Tree t1, Tree t2, PrintWriter pw) {
            Set b1 = this.makeObjects(t1);
            Set b2 = this.makeObjects(t2);
            this.checkCrossing(b1, b2);
            if (pw != null && this.runningAverages) {
                pw.println("AvgCB: " + (double)((int)(10000.0 * this.cb / this.num)) / 100.0 + " ZeroCB: " + (double)((int)(10000.0 * this.zeroCB / this.num)) / 100.0 + " N: " + this.getNum());
            }
        }

        @Override
        public void display(boolean verbose, PrintWriter pw) {
            pw.println(this.str + " AvgCB: " + (double)((int)(10000.0 * this.cb / this.num)) / 100.0 + " ZeroCB: " + (double)((int)(10000.0 * this.zeroCB / this.num)) / 100.0);
        }

        public CBEval(String str, boolean runningAverages, TreebankLanguagePack tlp) {
            super(str, runningAverages, tlp);
        }
    }
}

