/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sentence<T extends HasWord>
extends ArrayList<T> {
    private static final long serialVersionUID = 4659879214203680767L;

    public Sentence() {
    }

    public Sentence(int initialCapacity) {
        super(initialCapacity);
    }

    public Sentence(Collection<T> w) {
        super(w);
    }

    public static Sentence<TaggedWord> toSentence(List<String> lex, List<String> tags) {
        int ts;
        Sentence<TaggedWord> sent = new Sentence<TaggedWord>();
        int ls = lex.size();
        if (ls != (ts = tags.size())) {
            throw new IllegalArgumentException("Sentence.toSentence: lengths differ");
        }
        for (int i = 0; i < ls; ++i) {
            sent.add(new TaggedWord(lex.get(i), tags.get(i)));
        }
        return sent;
    }

    public static Sentence<Word> toSentence(List<String> lex) {
        Sentence<Word> sent = new Sentence<Word>();
        int ls = lex.size();
        for (int i = 0; i < ls; ++i) {
            sent.add(new Word(lex.get(i)));
        }
        return sent;
    }

    public static Sentence<Word> toSentence(String ... words) {
        Sentence<Word> sent = new Sentence<Word>();
        for (String str : words) {
            sent.add(new Word(str));
        }
        return sent;
    }

    public void setWords(Collection<T> wordList) {
        this.clear();
        this.addAll(wordList);
    }

    public int length() {
        return this.size();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean justValue) {
        StringBuilder s = new StringBuilder();
        Iterator wordIterator = this.iterator();
        while (wordIterator.hasNext()) {
            HasWord o = (HasWord)wordIterator.next();
            if (justValue && o instanceof Label) {
                s.append(((Label)((Object)o)).value());
            } else {
                s.append(o.toString());
            }
            if (!wordIterator.hasNext()) continue;
            s.append(" ");
        }
        return s.toString();
    }
}

