/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationLookup {
    private static Map<Class<CoreAnnotation<?>>, Class<?>> valueCache = new HashMap();

    private AnnotationLookup() {
    }

    public static KeyLookup getCoreKey(String oldKey) {
        for (KeyLookup lookup : KeyLookup.values()) {
            if (!lookup.oldKey.equals(oldKey)) continue;
            return lookup;
        }
        return null;
    }

    public static Class<?> getValueType(Class<? extends CoreAnnotation> key) {
        Class<Object> type = valueCache.get(key);
        if (type == null) {
            try {
                type = key.newInstance().getType();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected failure to instantiate - is your key class fancy?", e);
            }
            valueCache.put(key, type);
        }
        return type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyLookup {
        VALUE_KEY(CoreAnnotations.ValueAnnotation.class, "value"),
        TAG_KEY(CoreAnnotations.TagAnnotation.class, "tag"),
        WORD_KEY(CoreAnnotations.WordAnnotation.class, "word"),
        LEMMA_KEY(CoreAnnotations.LemmaAnnotation.class, "lemma"),
        CATEGORY_KEY(CoreAnnotations.CategoryAnnotation.class, "cat"),
        PROJ_CAT_KEY(CoreAnnotations.ProjectedCategoryAnnotation.class, "pcat"),
        HEAD_WORD_KEY("edu.stanford.nlp.ling.TreeCoreAnnotations.HeadWordAnnotation", "hw"),
        HEAD_TAG_KEY("edu.stanford.nlp.ling.TreeCoreAnnotations.HeadTagAnnotation", "ht"),
        INDEX_KEY(CoreAnnotations.IndexAnnotation.class, "idx"),
        ARG_KEY(CoreAnnotations.ArgumentAnnotation.class, "arg"),
        MARKING_KEY(CoreAnnotations.MarkingAnnotation.class, "mark"),
        SEMANTIC_HEAD_WORD_KEY(CoreAnnotations.SemanticHeadWordAnnotation.class, "shw"),
        SEMANTIC_HEAD_POS_KEY(CoreAnnotations.SemanticHeadTagAnnotation.class, "shp"),
        VERB_SENSE_KEY(CoreAnnotations.VerbSenseAnnotation.class, "vs"),
        CATEGORY_FUNCTIONAL_TAG_KEY(CoreAnnotations.CategoryFunctionalTagAnnotation.class, "cft"),
        NER_KEY(CoreAnnotations.NERAnnotation.class, "ner"),
        COREF_KEY(CoreAnnotations.CorefAnnotation.class, "coref"),
        SHAPE_KEY(CoreAnnotations.ShapeAnnotation.class, "shape"),
        LEFT_TERM_KEY(CoreAnnotations.LeftTermAnnotation.class, "LEFT_TERM"),
        PARENT_KEY(CoreAnnotations.ParentAnnotation.class, "PARENT"),
        SPAN_KEY(CoreAnnotations.SpanAnnotation.class, "SPAN"),
        BEFORE_KEY(CoreAnnotations.BeforeAnnotation.class, "before"),
        AFTER_KEY(CoreAnnotations.AfterAnnotation.class, "after"),
        CURRENT_KEY(CoreAnnotations.CurrentAnnotation.class, "current"),
        ANSWER_KEY(CoreAnnotations.AnswerAnnotation.class, "answer"),
        GOLDANSWER_Key(CoreAnnotations.GoldAnswerAnnotation.class, "goldAnswer"),
        FEATURES_KEY(CoreAnnotations.FeaturesAnnotation.class, "features"),
        INTERPRETATION_KEY(CoreAnnotations.InterpretationAnnotation.class, "interpretation"),
        ROLE_KEY(CoreAnnotations.RoleAnnotation.class, "srl"),
        GAZETTEER_KEY(CoreAnnotations.GazetteerAnnotation.class, "gazetteer"),
        STEM_KEY(CoreAnnotations.StemAnnotation.class, "stem"),
        POLARITY_KEY(CoreAnnotations.PolarityAnnotation.class, "polarity"),
        CH_CHAR_KEY(CoreAnnotations.ChineseCharAnnotation.class, "char"),
        CH_ORIG_SEG_KEY(CoreAnnotations.ChineseOrigSegAnnotation.class, "orig_seg"),
        CH_SEG_KEY(CoreAnnotations.ChineseSegAnnotation.class, "seg"),
        BEGIN_POSITION_KEY(CoreAnnotations.BeginPositionAnnotation.class, "BEGIN_POS"),
        END_POSITION_KEY(CoreAnnotations.EndPositionAnnotation.class, "END_POS"),
        DOCID_KEY(CoreAnnotations.DocIDAnnotation.class, "docID"),
        SENTINDEX_KEY(CoreAnnotations.SentenceIndexAnnotation.class, "sentIndex"),
        IDF_KEY(CoreAnnotations.IDFAnnotation.class, "idf"),
        END_POSITION_KEY2(CoreAnnotations.EndPositionAnnotation.class, "endPosition"),
        CHUNK_KEY(CoreAnnotations.ChunkAnnotation.class, "chunk"),
        NORMALIZED_NER_KEY(CoreAnnotations.NormalizedNERAnnotation.class, "normalized");

        public final Class<? extends CoreAnnotation<?>> coreKey;
        public final String oldKey;

        private <T> KeyLookup(Class<? extends CoreAnnotation<T>> coreKey, String oldKey) {
            this.coreKey = coreKey;
            this.oldKey = oldKey;
        }

        private KeyLookup(String className, String oldKey) {
            Class<?> keyClass;
            try {
                keyClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                CoreLabel.GenericAnnotation<Object> newKey = new CoreLabel.GenericAnnotation<Object>(){

                    @Override
                    public Class<Object> getType() {
                        return Object.class;
                    }
                };
                keyClass = newKey.getClass();
            }
            this.coreKey = keyClass;
            this.oldKey = oldKey;
        }
    }
}

