/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MutableInteger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Numberer
implements Serializable {
    private static Map<String, Numberer> numbererMap = new HashMap<String, Numberer>();
    private int total;
    private Map<MutableInteger, Object> intToObject;
    private Map<Object, MutableInteger> objectToInt;
    private MutableInteger tempInt = new MutableInteger();
    private boolean locked;
    private static final long serialVersionUID = 1L;

    public static Map<String, Numberer> getNumberers() {
        return numbererMap;
    }

    public static void clearGlobalNumberers() {
        numbererMap = new HashMap<String, Numberer>();
    }

    public static void setNumberers(Map<String, Numberer> numbs) {
        numbererMap = numbs;
    }

    public static void setGlobalNumberer(String key, Numberer numb) {
        numbererMap.put(key, numb);
    }

    public static Numberer getGlobalNumberer(String type) {
        Numberer n = numbererMap.get(type);
        if (n == null) {
            n = new Numberer();
            numbererMap.put(type, n);
        }
        return n;
    }

    public static int number(String type, Object o) {
        return Numberer.getGlobalNumberer(type).number(o);
    }

    public static Object object(String type, int n) {
        return Numberer.getGlobalNumberer(type).object(n);
    }

    public static int translate(String sourceType, String targetType, int n) {
        return Numberer.getGlobalNumberer(targetType).number(Numberer.getGlobalNumberer(sourceType).object(n));
    }

    public int total() {
        return this.total;
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public boolean hasSeen(Object o) {
        return this.objectToInt.keySet().contains(o);
    }

    public Set objects() {
        return this.objectToInt.keySet();
    }

    public int number(Object o) {
        MutableInteger i = this.objectToInt.get(o);
        if (i == null) {
            if (this.locked) {
                throw new NoSuchElementException("Numberer locked but trying to number unseen object " + o.toString());
            }
            i = new MutableInteger(this.total);
            ++this.total;
            this.objectToInt.put(o, i);
            this.intToObject.put(i, o);
        }
        return i.intValue();
    }

    public Object object(int n) {
        this.tempInt.set(n);
        return this.intToObject.get(this.tempInt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.total; ++i) {
            sb.append(i);
            sb.append("->");
            sb.append(this.object(i));
            if (i >= this.total - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public Numberer() {
        this.intToObject = Generics.newHashMap();
        this.objectToInt = Generics.newHashMap();
    }

    public Numberer(Numberer numb) {
        this.intToObject = Generics.newHashMap(numb.total());
        this.objectToInt = Generics.newHashMap(numb.total());
        for (int i = 0; i < numb.total(); ++i) {
            Object obj = numb.object(i);
            int x = this.number(obj);
            if (i == x) continue;
            throw new IllegalStateException("Something bung!\n");
        }
    }
}

