/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Heap;
import edu.stanford.nlp.util.Scored;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayHeap<E>
extends AbstractSet<E>
implements Heap<E> {
    private ArrayList<HeapEntry<E>> indexToEntry;
    private Map<E, HeapEntry<E>> objectToEntry;
    private Comparator<? super E> cmp;

    private int parent(int index) {
        return (index - 1) / 2;
    }

    private int leftChild(int index) {
        return index * 2 + 1;
    }

    private int rightChild(int index) {
        return index * 2 + 2;
    }

    private HeapEntry<E> parent(HeapEntry<E> entry) {
        int index = entry.index;
        return index > 0 ? this.indexToEntry.get((index - 1) / 2) : null;
    }

    private HeapEntry<E> leftChild(HeapEntry<E> entry) {
        int index = entry.index;
        int leftIndex = index * 2 + 1;
        return leftIndex < this.size() ? this.indexToEntry.get(leftIndex) : null;
    }

    private HeapEntry<E> rightChild(HeapEntry<E> entry) {
        int index = entry.index;
        int rightIndex = index * 2 + 2;
        return rightIndex < this.size() ? this.indexToEntry.get(rightIndex) : null;
    }

    private int compare(HeapEntry<E> entryA, HeapEntry<E> entryB) {
        return this.cmp.compare(entryA.object, entryB.object);
    }

    private void swap(HeapEntry<E> entryA, HeapEntry<E> entryB) {
        int indexB;
        int indexA = entryA.index;
        entryA.index = indexB = entryB.index;
        entryB.index = indexA;
        this.indexToEntry.set(indexA, entryB);
        this.indexToEntry.set(indexB, entryA);
    }

    private void removeLast(HeapEntry<E> entry) {
        this.indexToEntry.remove(entry.index);
        this.objectToEntry.remove(entry.object);
    }

    private HeapEntry<E> getEntry(E o) {
        HeapEntry<E> entry = this.objectToEntry.get(o);
        if (entry == null) {
            entry = new HeapEntry();
            entry.index = this.size();
            entry.object = o;
            this.indexToEntry.add(entry);
            this.objectToEntry.put(o, entry);
        }
        return entry;
    }

    private int heapifyUp(HeapEntry<E> entry) {
        HeapEntry<E> parentEntry;
        int numSwaps = 0;
        while (entry.index != 0 && this.compare(entry, parentEntry = this.parent(entry)) < 0) {
            ++numSwaps;
            this.swap(entry, parentEntry);
        }
        return numSwaps;
    }

    private void heapifyDown(HeapEntry<E> entry) {
        HeapEntry<E> minEntry;
        HeapEntry<E> currentEntry = entry;
        do {
            HeapEntry<E> rightEntry;
            minEntry = currentEntry;
            HeapEntry<E> leftEntry = this.leftChild(currentEntry);
            if (leftEntry != null && this.compare(minEntry, leftEntry) > 0) {
                minEntry = leftEntry;
            }
            if ((rightEntry = this.rightChild(currentEntry)) != null && this.compare(minEntry, rightEntry) > 0) {
                minEntry = rightEntry;
            }
            if (minEntry == currentEntry) continue;
            this.swap(minEntry, currentEntry);
        } while (minEntry != currentEntry);
    }

    @Override
    public E extractMin() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        HeapEntry<E> minEntry = this.indexToEntry.get(0);
        int lastIndex = this.size() - 1;
        if (lastIndex > 0) {
            HeapEntry<E> lastEntry = this.indexToEntry.get(lastIndex);
            this.swap(lastEntry, minEntry);
            this.removeLast(minEntry);
            this.heapifyDown(lastEntry);
        } else {
            this.removeLast(minEntry);
        }
        return minEntry.object;
    }

    @Override
    public E min() {
        HeapEntry<E> minEntry = this.indexToEntry.get(0);
        return minEntry.object;
    }

    @Override
    public boolean add(E o) {
        this.decreaseKey(o);
        return true;
    }

    @Override
    public int decreaseKey(E o) {
        HeapEntry<E> entry = this.getEntry(o);
        if (o != entry.object && this.cmp.compare(o, entry.object) < 0) {
            entry.object = o;
        }
        return this.heapifyUp(entry);
    }

    @Override
    public boolean isEmpty() {
        return this.indexToEntry.isEmpty();
    }

    @Override
    public int size() {
        return this.indexToEntry.size();
    }

    @Override
    public Iterator<E> iterator() {
        ArrayHeap<E> tempHeap = new ArrayHeap<E>(this.cmp, this.size());
        ArrayList tempList = new ArrayList(this.size());
        for (E obj : this.objectToEntry.keySet()) {
            tempHeap.add(obj);
        }
        while (!tempHeap.isEmpty()) {
            tempList.add(tempHeap.extractMin());
        }
        return tempList.iterator();
    }

    @Override
    public void clear() {
        this.indexToEntry.clear();
        this.objectToEntry.clear();
    }

    public void dump() {
        for (int j = 0; j < this.indexToEntry.size(); ++j) {
            System.err.println(" " + j + " " + ((Scored)this.indexToEntry.get((int)j).object).score());
        }
    }

    public void verify() {
        for (int i = 0; i < this.indexToEntry.size(); ++i) {
            if (i != 0 && this.compare(this.indexToEntry.get(i), this.indexToEntry.get(this.parent(i))) < 0) {
                System.err.println("Error in the ordering of the heap! (" + i + ")");
                this.dump();
                System.exit(0);
            }
            if (i == this.indexToEntry.get((int)i).index) continue;
            System.err.println("Error in placement in the heap!");
        }
    }

    public ArrayHeap(Comparator<? super E> cmp) {
        this.cmp = cmp;
        this.indexToEntry = new ArrayList();
        this.objectToEntry = new HashMap<E, HeapEntry<E>>();
    }

    public ArrayHeap(Comparator<? super E> cmp, int initCapacity) {
        this.cmp = cmp;
        this.indexToEntry = new ArrayList(initCapacity);
        this.objectToEntry = new HashMap<E, HeapEntry<E>>(initCapacity);
    }

    @Override
    public String toString() {
        ArrayList<E> result = new ArrayList<E>();
        for (E key : this.objectToEntry.keySet()) {
            result.add(key);
        }
        Collections.sort(result, this.cmp);
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HeapEntry<E> {
        public E object;
        public int index;

        private HeapEntry() {
        }
    }
}

