/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.HashableCoreMap;
import edu.stanford.nlp.util.TypesafeMap;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCoreMap
implements CoreMap,
Serializable {
    private static final int INITIAL_CAPACITY = 4;
    private Class<?>[] keys;
    private Object[] values;
    private int size;
    private static final long serialVersionUID = 1L;

    public ArrayCoreMap() {
        this(4);
    }

    public ArrayCoreMap(int capacity) {
        this.keys = new Class[capacity];
        this.values = new Object[capacity];
    }

    public ArrayCoreMap(ArrayCoreMap other) {
        this.size = other.size;
        this.keys = new Class[this.size];
        this.values = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = other.keys[i];
            this.values[i] = other.values[i];
        }
    }

    public ArrayCoreMap(CoreMap other) {
        Set<Class<?>> otherKeys = other.keySet();
        this.size = otherKeys.size();
        this.keys = new Class[this.size];
        this.values = new Object[this.size];
        int i = 0;
        for (Class<?> key : otherKeys) {
            this.keys[i] = key;
            this.values[i] = other.get(key);
            ++i;
        }
    }

    @Override
    public <VALUE, KEY extends TypesafeMap.Key<CoreMap, VALUE>> VALUE get(Class<KEY> key) {
        int i = this.size;
        while (i > 0) {
            if (this.keys[--i] != key) continue;
            return (VALUE)this.values[i];
        }
        return null;
    }

    @Override
    public <VALUE, KEY extends TypesafeMap.Key<CoreMap, VALUE>> boolean has(Class<KEY> key) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            return true;
        }
        return false;
    }

    @Override
    public <VALUEBASE, VALUE extends VALUEBASE, KEY extends TypesafeMap.Key<CoreMap, VALUEBASE>> VALUE set(Class<KEY> key, VALUE value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            Object rv = this.values[i];
            this.values[i] = value;
            return (VALUE)rv;
        }
        if (this.size >= this.keys.length) {
            int capacity = this.keys.length + Math.min((this.keys.length >> 1) + 1, 8);
            Class[] newKeys = new Class[capacity];
            Object[] newVals = new Object[capacity];
            System.arraycopy(this.keys, 0, newKeys, 0, this.size);
            System.arraycopy(this.values, 0, newVals, 0, this.size);
            this.keys = newKeys;
            this.values = newVals;
        }
        this.keys[this.size] = key;
        this.values[this.size] = value;
        ++this.size;
        return null;
    }

    @Override
    public Set<Class<?>> keySet() {
        return new AbstractSet<Class<?>>(){

            @Override
            public Iterator<Class<?>> iterator() {
                return new Iterator<Class<?>>(){
                    private int i;

                    @Override
                    public boolean hasNext() {
                        return this.i < ArrayCoreMap.this.size;
                    }

                    @Override
                    public Class<?> next() {
                        try {
                            return ArrayCoreMap.this.keys[this.i++];
                        }
                        catch (ArrayIndexOutOfBoundsException aioobe) {
                            throw new NoSuchElementException("ArrayCoreMap keySet iterator exhausted");
                        }
                    }

                    @Override
                    public void remove() {
                        ArrayCoreMap.this.remove(ArrayCoreMap.this.keys[this.i]);
                    }
                };
            }

            @Override
            public int size() {
                return ArrayCoreMap.this.size;
            }
        };
    }

    @Override
    public <VALUE, KEY extends TypesafeMap.Key<CoreMap, VALUE>> VALUE remove(Class<KEY> key) {
        Object rv = null;
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            rv = this.values[i];
            if (i < this.size - 1) {
                System.arraycopy(this.keys, i + 1, this.keys, i, this.size - (i + 1));
                System.arraycopy(this.values, i + 1, this.values, i, this.size - (i + 1));
            }
            --this.size;
            break;
        }
        return (VALUE)rv;
    }

    @Override
    public <VALUE, KEY extends TypesafeMap.Key<CoreMap, VALUE>> boolean containsKey(Class<KEY> key) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            return true;
        }
        return false;
    }

    public void compact() {
        if (this.keys.length > this.size) {
            Class[] newKeys = new Class[this.size];
            Object[] newVals = new Object[this.size];
            System.arraycopy(this.keys, 0, newKeys, 0, this.size);
            System.arraycopy(this.values, 0, newVals, 0, this.size);
            this.keys = newKeys;
            this.values = newVals;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            s.append(this.keys[i].getSimpleName());
            s.append('=');
            s.append(this.values[i]);
            if (i >= this.size - 1) continue;
            s.append(' ');
        }
        s.append(']');
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CoreMap)) {
            return false;
        }
        if (obj instanceof HashableCoreMap) {
            return obj.equals(this);
        }
        if (obj instanceof ArrayCoreMap) {
            return this.equals((ArrayCoreMap)obj);
        }
        CoreMap other = (CoreMap)obj;
        if (!((Object)this.keySet()).equals(other.keySet())) {
            return false;
        }
        for (Class<?> key : this.keySet()) {
            Object otherV;
            if (!other.has(key)) {
                return false;
            }
            Object thisV = this.get(key);
            if (thisV == (otherV = other.get(key))) continue;
            if (thisV == null || otherV == null) {
                return false;
            }
            if (thisV.equals(otherV)) continue;
            return false;
        }
        return true;
    }

    private boolean equals(ArrayCoreMap other) {
        if (this.size != other.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            boolean matched = false;
            for (int j = 0; j < other.size; ++j) {
                if (this.keys[i] != other.keys[j]) continue;
                if (this.values[i] == null && other.values[j] != null || this.values[i] != null && other.values[j] == null) {
                    matched = false;
                    break;
                }
                if ((this.values[i] != null || other.values[j] != null) && !this.values[i].equals(other.values[j])) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int keyscode = 0;
        int valuescode = 0;
        for (int i = 0; i < this.size; ++i) {
            keyscode += this.keys[i].hashCode();
            valuescode += this.values[i] != null ? this.values[i].hashCode() : 0;
        }
        return keyscode * 37 + valuescode;
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        this.compact();
        out2.defaultWriteObject();
    }
}

