/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.tregex.CoordinationPattern;
import edu.stanford.nlp.trees.tregex.DescriptionPattern;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.Relation;
import edu.stanford.nlp.trees.tregex.SimpleCharStream;
import edu.stanford.nlp.trees.tregex.Token;
import edu.stanford.nlp.trees.tregex.TregexParserConstants;
import edu.stanford.nlp.trees.tregex.TregexParserTokenManager;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.Pair;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

class TregexParser
implements TregexParserConstants {
    private static boolean underNegation = false;
    private static boolean jj_initialized_once = false;
    public static TregexParserTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static List jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;

    static TregexPattern parse(String string) throws ParseException {
        underNegation = false;
        if (jj_initialized_once) {
            TregexParser.ReInit(new StringReader(string + "\n"));
        } else {
            new TregexParser(new StringReader(string + "\n"));
        }
        return TregexParser.Root();
    }

    public static final TregexPattern Root() throws ParseException {
        DescriptionPattern descriptionPattern = TregexParser.SubNode(Relation.ROOT);
        TregexParser.jj_consume_token(11);
        return descriptionPattern;
    }

    public static final TregexPattern Node(Relation relation) throws ParseException {
        DescriptionPattern descriptionPattern;
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 12: {
                TregexParser.jj_consume_token(12);
                descriptionPattern = TregexParser.SubNode(relation);
                TregexParser.jj_consume_token(13);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                descriptionPattern = TregexParser.ModDescription(relation);
                break;
            }
            default: {
                TregexParser.jj_la1[0] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return descriptionPattern;
    }

    public static final DescriptionPattern SubNode(Relation relation) throws ParseException {
        DescriptionPattern descriptionPattern = null;
        TregexPattern tregexPattern = null;
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 12: {
                TregexParser.jj_consume_token(12);
                descriptionPattern = TregexParser.SubNode(relation);
                TregexParser.jj_consume_token(13);
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 4: 
                    case 5: 
                    case 14: 
                    case 22: 
                    case 23: {
                        tregexPattern = TregexParser.ChildrenDisj();
                        break;
                    }
                    default: {
                        TregexParser.jj_la1[1] = jj_gen;
                    }
                }
                if (tregexPattern != null) {
                    ArrayList<TregexPattern> arrayList = new ArrayList<TregexPattern>();
                    arrayList.addAll(descriptionPattern.getChildren());
                    arrayList.add(tregexPattern);
                    descriptionPattern.setChild(new CoordinationPattern(arrayList, true));
                }
                return descriptionPattern;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                descriptionPattern = TregexParser.ModDescription(relation);
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 4: 
                    case 5: 
                    case 14: 
                    case 22: 
                    case 23: {
                        tregexPattern = TregexParser.ChildrenDisj();
                        break;
                    }
                    default: {
                        TregexParser.jj_la1[2] = jj_gen;
                    }
                }
                if (tregexPattern != null) {
                    descriptionPattern.setChild(tregexPattern);
                }
                return descriptionPattern;
            }
        }
        TregexParser.jj_la1[3] = jj_gen;
        TregexParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final DescriptionPattern ModDescription(Relation relation) throws ParseException {
        boolean bl = false;
        boolean bl2 = false;
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 14: {
                TregexParser.jj_consume_token(14);
                bl = true;
                break;
            }
            default: {
                TregexParser.jj_la1[4] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 15: {
                TregexParser.jj_consume_token(15);
                bl2 = true;
                break;
            }
            default: {
                TregexParser.jj_la1[5] = jj_gen;
            }
        }
        DescriptionPattern descriptionPattern = TregexParser.Description(relation, bl, bl2);
        return descriptionPattern;
    }

    public static final DescriptionPattern Description(Relation relation, boolean bl, boolean bl2) throws ParseException {
        Token token = null;
        Token token2 = null;
        boolean bl3 = false;
        ArrayList<Pair<Integer, String>> arrayList = new ArrayList<Pair<Integer, String>>();
        block0 : switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 7: 
            case 8: 
            case 9: {
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 7: {
                        token = TregexParser.jj_consume_token(7);
                        break;
                    }
                    case 9: {
                        token = TregexParser.jj_consume_token(9);
                        break;
                    }
                    case 8: {
                        token = TregexParser.jj_consume_token(8);
                        break;
                    }
                    default: {
                        TregexParser.jj_la1[6] = jj_gen;
                        TregexParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block19: while (true) {
                    switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                        case 16: {
                            break;
                        }
                        default: {
                            TregexParser.jj_la1[7] = jj_gen;
                            break block19;
                        }
                    }
                    TregexParser.jj_consume_token(16);
                    Token token3 = TregexParser.jj_consume_token(6);
                    TregexParser.jj_consume_token(17);
                    Token token4 = TregexParser.jj_consume_token(7);
                    arrayList.add(new Pair<Integer, String>(Integer.parseInt(token3.image), token4.image));
                }
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 18: {
                        TregexParser.jj_consume_token(18);
                        token2 = TregexParser.jj_consume_token(7);
                        if (!underNegation) break block0;
                        throw new ParseException("No named tregex nodes allowed in the scope of negation.");
                    }
                    default: {
                        TregexParser.jj_la1[8] = jj_gen;
                        break;
                    }
                }
                break;
            }
            case 18: 
            case 19: {
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 18: {
                        TregexParser.jj_consume_token(18);
                        break;
                    }
                    case 19: {
                        TregexParser.jj_consume_token(19);
                        bl3 = true;
                        break;
                    }
                    default: {
                        TregexParser.jj_la1[9] = jj_gen;
                        TregexParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                token2 = TregexParser.jj_consume_token(7);
                break;
            }
            default: {
                TregexParser.jj_la1[10] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DescriptionPattern descriptionPattern = new DescriptionPattern(relation, bl, token != null ? token.image : null, token2 != null ? token2.image : null, bl2, arrayList);
        if (bl3) {
            descriptionPattern.makeLink();
        }
        return descriptionPattern;
    }

    public static final TregexPattern ChildrenDisj() throws ParseException {
        ArrayList<TregexPattern> arrayList = new ArrayList<TregexPattern>();
        TregexPattern tregexPattern = TregexParser.ChildrenConj();
        arrayList.add(tregexPattern);
        block3: while (true) {
            switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    TregexParser.jj_la1[11] = jj_gen;
                    break block3;
                }
            }
            TregexParser.jj_consume_token(20);
            tregexPattern = TregexParser.ChildrenConj();
            arrayList.add(tregexPattern);
        }
        if (arrayList.size() == 1) {
            return tregexPattern;
        }
        return new CoordinationPattern(arrayList, false);
    }

    public static final TregexPattern ChildrenConj() throws ParseException {
        ArrayList<TregexPattern> arrayList = new ArrayList<TregexPattern>();
        TregexPattern tregexPattern = TregexParser.ModChild();
        arrayList.add(tregexPattern);
        block6: while (true) {
            switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                case 4: 
                case 5: 
                case 14: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    TregexParser.jj_la1[12] = jj_gen;
                    break block6;
                }
            }
            switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                case 21: {
                    TregexParser.jj_consume_token(21);
                    break;
                }
                default: {
                    TregexParser.jj_la1[13] = jj_gen;
                }
            }
            tregexPattern = TregexParser.ModChild();
            arrayList.add(tregexPattern);
        }
        if (arrayList.size() == 1) {
            return tregexPattern;
        }
        return new CoordinationPattern(arrayList, true);
    }

    public static final TregexPattern ModChild() throws ParseException {
        TregexPattern tregexPattern;
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 4: 
            case 5: 
            case 23: {
                tregexPattern = TregexParser.Child();
                break;
            }
            case 14: {
                TregexParser.jj_consume_token(14);
                boolean bl = underNegation;
                underNegation = true;
                tregexPattern = TregexParser.Child();
                underNegation = bl;
                tregexPattern.negate();
                break;
            }
            case 22: {
                TregexParser.jj_consume_token(22);
                tregexPattern = TregexParser.Child();
                tregexPattern.makeOptional();
                break;
            }
            default: {
                TregexParser.jj_la1[14] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return tregexPattern;
    }

    public static final TregexPattern Child() throws ParseException {
        TregexPattern tregexPattern;
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 23: {
                TregexParser.jj_consume_token(23);
                tregexPattern = TregexParser.ChildrenDisj();
                TregexParser.jj_consume_token(24);
                break;
            }
            case 4: 
            case 5: {
                tregexPattern = TregexParser.Relation();
                break;
            }
            default: {
                TregexParser.jj_la1[15] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return tregexPattern;
    }

    public static final TregexPattern Relation() throws ParseException {
        Relation relation;
        Token token;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        block0 : switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 4: {
                token = TregexParser.jj_consume_token(4);
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 6: {
                        token3 = TregexParser.jj_consume_token(6);
                        break block0;
                    }
                }
                TregexParser.jj_la1[16] = jj_gen;
                break;
            }
            case 5: {
                token = TregexParser.jj_consume_token(5);
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 12: {
                        TregexParser.jj_consume_token(12);
                        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                            case 14: {
                                token4 = TregexParser.jj_consume_token(14);
                                break;
                            }
                            default: {
                                TregexParser.jj_la1[17] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                            case 9: {
                                token2 = TregexParser.jj_consume_token(9);
                                break;
                            }
                            case 7: {
                                token2 = TregexParser.jj_consume_token(7);
                                break;
                            }
                            case 8: {
                                token2 = TregexParser.jj_consume_token(8);
                                break;
                            }
                            default: {
                                TregexParser.jj_la1[18] = jj_gen;
                                TregexParser.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        TregexParser.jj_consume_token(13);
                        break block0;
                    }
                    case 9: 
                    case 14: {
                        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                            case 14: {
                                token4 = TregexParser.jj_consume_token(14);
                                break;
                            }
                            default: {
                                TregexParser.jj_la1[19] = jj_gen;
                            }
                        }
                        token2 = TregexParser.jj_consume_token(9);
                        break block0;
                    }
                }
                TregexParser.jj_la1[20] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                TregexParser.jj_la1[21] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (token2 != null) {
            relation = Relation.getRelation(token.image, token4 == null ? token2.image : "!" + token2.image);
        } else if (token3 != null) {
            if (token.image.endsWith("-")) {
                token.image = token.image.substring(0, token.image.length() - 1);
                token3.image = "-" + token3.image;
            }
            relation = Relation.getRelation(token.image, token3.image);
        } else {
            relation = Relation.getRelation(token.image);
        }
        TregexPattern tregexPattern = TregexParser.Node(relation);
        return tregexPattern;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{840576, 12599344, 12599344, 840576, 16384, 32768, 896, 65536, 262144, 786432, 787328, 0x100000, 14696496, 0x200000, 12599344, 0x800030, 64, 16384, 896, 16384, 20992, 48};
    }

    public TregexParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public TregexParser(InputStream inputStream, String string) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        token_source = new TregexParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(InputStream inputStream) {
        TregexParser.ReInit(inputStream, null);
    }

    public static void ReInit(InputStream inputStream, String string) {
        try {
            jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        TregexParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    public TregexParser(Reader reader) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(reader, 1, 1);
        token_source = new TregexParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(Reader reader) {
        jj_input_stream.ReInit(reader, 1, 1);
        TregexParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    public TregexParser(TregexParserTokenManager tregexParserTokenManager) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = tregexParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    public void ReInit(TregexParserTokenManager tregexParserTokenManager) {
        token_source = tregexParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    private static Token jj_consume_token(int n) throws ParseException {
        Token token = TregexParser.token;
        TregexParser.token = token.next != null ? TregexParser.token.next : (TregexParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (TregexParser.token.kind == n) {
            ++jj_gen;
            return TregexParser.token;
        }
        TregexParser.token = token;
        jj_kind = n;
        throw TregexParser.generateParseException();
    }

    public static final Token getNextToken() {
        token = TregexParser.token.next != null ? TregexParser.token.next : (TregexParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int n) {
        Token token = TregexParser.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = token_source.getNextToken());
        }
        return token;
    }

    private static int jj_ntk() {
        jj_nt = TregexParser.token.next;
        if (jj_nt == null) {
            TregexParser.token.next = token_source.getNextToken();
            jj_ntk = TregexParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = TregexParser.jj_nt.kind;
        return jj_ntk;
    }

    public static ParseException generateParseException() {
        int n;
        int n2;
        jj_expentries.clear();
        boolean[] blArray = new boolean[25];
        if (jj_kind >= 0) {
            blArray[TregexParser.jj_kind] = true;
            jj_kind = -1;
        }
        for (n2 = 0; n2 < 22; ++n2) {
            if (jj_la1[n2] != jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 25; ++n2) {
            if (!blArray[n2]) continue;
            jj_expentry = new int[1];
            TregexParser.jj_expentry[0] = n2;
            jj_expentries.add(jj_expentry);
        }
        int[][] nArrayArray = new int[jj_expentries.size()][];
        for (n = 0; n < jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])jj_expentries.get(n);
        }
        return new ParseException(token, nArrayArray, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    static {
        jj_la1 = new int[22];
        TregexParser.jj_la1_init_0();
        jj_expentries = new ArrayList();
        jj_kind = -1;
    }
}

