/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.Relation;
import edu.stanford.nlp.trees.tregex.TreeMatcher;
import edu.stanford.nlp.trees.tregex.TreePatternIterator;
import edu.stanford.nlp.trees.tregex.TreePatternReturnValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreePattern {
    static HeadFinder defaultHeadFinder = new CollinsHeadFinder();
    static final TreePattern[] zeroChildren = new TreePattern[0];
    Object name;
    String description;
    boolean negatedDescription = false;
    Relation relation;
    boolean negatedRelation = false;
    TreePattern parent;
    TreePattern[] children;
    Map<Object, Tree> namesToNodes;
    Pattern descriptionPattern;
    private static Pattern separateNamesPattern = Pattern.compile("^(\\S+)(=[^=/]+)$");
    private static Pattern separateLeftParensPattern = Pattern.compile("^\\((.+)$");
    private static Pattern separateRightParensPattern = Pattern.compile("^(.+)\\)$");
    static final Pattern leftParPattern = Pattern.compile("\\(");
    static final Pattern rightParPattern = Pattern.compile("\\)");
    static final Pattern namePattern = Pattern.compile("\\A(=.*)\\z");
    static final Pattern relationPattern = Pattern.compile("[<>][-,`:+H]?|[<>]-?[0-9]|(?:<<|>>)[,`:-H]?|[.,]|\\.\\.|,,|\\$[.,+-]?|\\$\\.\\.|\\$,,|\\$\\+\\+|\\$--|=|<\\+.+|>\\+.+");
    static final Pattern numericArgRelationPattern = Pattern.compile("([<>])(-?[0-9]+)");
    static final Pattern stringArgRelationPattern = Pattern.compile("(<\\+|>\\+)(.+)");
    static final Pattern quotedString = Pattern.compile("\"(.*)\"");
    static final Pattern regularExpressionString = Pattern.compile("/(.*)/");
    static final Pattern wildCardString = Pattern.compile("__|\\*");
    private static Pattern escapedQuote = Pattern.compile("\\\"");
    private static Pattern unEscapedQuote = Pattern.compile(".*[^\\\\]\".*");
    private static Pattern specials = Pattern.compile("[*$#&%!]");
    TreePattern lastNode;
    Tree root;
    Iterator<Tree> it;
    TreePatternIterator childrenIterator;
    TreePattern currentChild;
    TreePatternReturnValue currentResult;

    private TreePattern(TreePattern[] children) {
        this.children = children;
        this.namesToNodes = new HashMap<Object, Tree>();
        for (int i = 0; i < children.length; ++i) {
            children[i].parent = this;
        }
        this.unifyNamesToNodesMaps();
    }

    TreePattern(String description, Relation relation, TreePattern[] children) {
        this(description, TreePattern.nameNode(), relation, children);
    }

    TreePattern(String description, Object name, Relation relation, TreePattern[] children) {
        this(description, name, relation, children, true);
    }

    TreePattern(String description, Relation relation, TreePattern[] children, boolean negatedDescription) {
        this(description, TreePattern.nameNode(), relation, children, negatedDescription);
    }

    TreePattern(String description, Object name, Relation relation, TreePattern[] children, boolean negatedDescription) {
        this(children);
        this.description = description;
        this.relation = relation;
        this.name = name;
        this.descriptionPattern = Pattern.compile(this.description);
        this.negatedDescription = negatedDescription;
    }

    private void unifyNamesToNodesMaps() {
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].namesToNodes = this.namesToNodes;
            this.children[i].unifyNamesToNodesMaps();
        }
    }

    Tree node() {
        return this.namesToNodes.get(this.name);
    }

    void setNode(Tree t) {
        this.namesToNodes.put(this.name, t);
    }

    private ListIterator<TreePattern> nodesInOrder() {
        ArrayList<TreePattern> l = new ArrayList<TreePattern>();
        this.nodesInOrder(l);
        return l.listIterator();
    }

    private void nodesInOrder(List<TreePattern> l) {
        l.add(this);
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            this.children[i].nodesInOrder(l);
        }
    }

    TreePatternIterator iterator() {
        return new MyIterator(this.nodesInOrder());
    }

    public TreeMatcher matcher(Tree t) {
        return new TreeMatcher(t, this);
    }

    public static TreePattern compile(String str) {
        List<String> tokens = Arrays.asList(str.split("\\s+"));
        tokens = TreePattern.separateParens(tokens);
        tokens = TreePattern.separateNames(tokens);
        if (TreeMatcher.Verbose.verbose) {
            System.out.println("Compiling " + str);
            System.out.println("Here are the tokens:\n" + tokens);
        }
        ListTokenizer tokenizer = new ListTokenizer(tokens);
        TreePattern pattern = TreePattern.compile(tokenizer);
        if (tokenizer.hasNext()) {
            throw new RuntimeException("Error -- extra tokens at end of input TreePattern string!");
        }
        return pattern;
    }

    private static List<String> separateNames(List<String> tokens) {
        ArrayList<String> newTokens = new ArrayList<String>(tokens.size());
        for (String token : tokens) {
            Matcher m = separateNamesPattern.matcher(token);
            if (m.matches()) {
                newTokens.add(m.group(1));
                newTokens.add(m.group(2));
                continue;
            }
            newTokens.add(token);
        }
        return newTokens;
    }

    private static List<String> separateParens(List<String> tokens) {
        ArrayList<String> newTokens = new ArrayList<String>(tokens.size());
        for (String token : tokens) {
            Matcher m = separateLeftParensPattern.matcher(token);
            while (m.matches()) {
                newTokens.add("(");
                token = m.group(1);
                m = separateLeftParensPattern.matcher(token);
            }
            ArrayList<String> rightParensList = new ArrayList<String>();
            Matcher m1 = separateRightParensPattern.matcher(token);
            while (m1.matches()) {
                rightParensList.add(")");
                token = m1.group(1);
                m1 = separateRightParensPattern.matcher(token);
            }
            rightParensList.add(0, token);
            newTokens.addAll(rightParensList);
        }
        return newTokens;
    }

    private static TreePattern compile(Tokenizer<String> tokenizer) {
        return TreePattern.parseNonTerminalTreePattern(tokenizer, Relation.ROOT);
    }

    private static TreePattern parseTerminalTreePattern(Tokenizer<String> tokenizer, Relation r) {
        Object name;
        String str = tokenizer.peek();
        if (namePattern.matcher(str).matches() || relationPattern.matcher(str).matches() || leftParPattern.matcher(str).matches() || rightParPattern.matcher(str).matches()) {
            throw new RuntimeException("Error -- terminal tree pattern parse method called for non-terminal tree pattern");
        }
        tokenizer.next();
        String next = tokenizer.peek();
        if (next == null) {
            name = new Object();
        } else {
            Matcher m = namePattern.matcher(next);
            if (!m.matches()) {
                name = new Object();
            } else {
                tokenizer.next();
                name = m.group(1);
            }
        }
        NegationDescriptionPair p = TreePattern.formatDescriptionString(str);
        return new TreePattern(p.description, name, r, zeroChildren, p.negation);
    }

    private static TreePattern parseNonTerminalTreePattern(Tokenizer<String> tokenizer, Relation r) {
        Matcher m;
        String str = tokenizer.peek();
        if (rightParPattern.matcher(str).matches() || namePattern.matcher(str).matches()) {
            throw new RuntimeException("Error -- non-terminal tree pattern parse method called for name or ) token");
        }
        if (leftParPattern.matcher(str).matches()) {
            tokenizer.next();
            TreePattern pattern = TreePattern.parseNonTerminalTreePattern(tokenizer, r);
            String next = tokenizer.peek();
            if (next == null || !rightParPattern.matcher(next).matches()) {
                throw new RuntimeException("Error -- unbalanced parenthesis!");
            }
            tokenizer.next();
            return pattern;
        }
        tokenizer.next();
        String next = tokenizer.peek();
        String name = null;
        if (next != null && (m = namePattern.matcher(next)).matches()) {
            tokenizer.next();
            if (TreeMatcher.Verbose.verbose) {
                System.out.println("###Matched as name: " + next);
            }
            name = m.group(1);
        }
        TreePattern[] children = TreePattern.parseTreePatternChildren(tokenizer);
        NegationDescriptionPair p = TreePattern.formatDescriptionString(str);
        if (name != null) {
            return new TreePattern(p.description, name, r, children, p.negation);
        }
        return new TreePattern(p.description, r, children, p.negation);
    }

    private static TreePattern[] parseTreePatternChildren(Tokenizer<String> tokenizer) {
        ArrayList<TreePattern> kids = new ArrayList<TreePattern>(0);
        return TreePattern.parseTreePatternChildren(tokenizer, kids).toArray(zeroChildren);
    }

    private static List<TreePattern> parseTreePatternChildren(Tokenizer<String> tokenizer, List<TreePattern> kids) {
        String str;
        Relation r;
        if (!tokenizer.hasNext()) {
            return kids;
        }
        String relnStr = tokenizer.peek();
        if (rightParPattern.matcher(relnStr).matches()) {
            if (TreeMatcher.Verbose.verbose) {
                System.out.println("###Finished composing children list.");
            }
            return kids;
        }
        tokenizer.next();
        if (!relationPattern.matcher(relnStr).matches()) {
            throw new RuntimeException("Error -- invalid relation string: " + relnStr);
        }
        String arg = null;
        Matcher m1 = numericArgRelationPattern.matcher(relnStr);
        if (m1.matches()) {
            relnStr = m1.group(1);
            arg = m1.group(2);
        }
        if ((m1 = stringArgRelationPattern.matcher(relnStr)).matches()) {
            relnStr = m1.group(1);
            arg = m1.group(2);
        }
        try {
            r = Relation.getRelation(relnStr, arg);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        if (TreeMatcher.Verbose.verbose) {
            System.out.println("### Found relation: " + r + " from string " + relnStr);
        }
        if (namePattern.matcher(str = tokenizer.peek()).matches()) {
            throw new RuntimeException("Error -- node name token in wrong place.");
        }
        if (leftParPattern.matcher(str).matches()) {
            kids.add(TreePattern.parseNonTerminalTreePattern(tokenizer, r));
        } else {
            kids.add(TreePattern.parseTerminalTreePattern(tokenizer, r));
        }
        return TreePattern.parseTreePatternChildren(tokenizer, kids);
    }

    private static Object nameNode() {
        return new Object();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        String end = "";
        if (this.relation != null) {
            str.append(this.relation.toString()).append("( ");
            end = ") ";
        }
        if (this.name instanceof String) {
            str.append(this.description).append(this.name).append(" ");
        } else {
            str.append(this.description).append(" ");
        }
        for (TreePattern child : this.children) {
            str.append(child.toString());
        }
        str.append(end);
        return str.toString();
    }

    static NegationDescriptionPair formatDescriptionString(String str) {
        NegationDescriptionPair p = new NegationDescriptionPair();
        if (str.charAt(0) == '!') {
            p.negation = true;
            str = str.substring(1);
        }
        if (wildCardString.matcher(str).matches()) {
            p.description = ".*";
            return p;
        }
        Matcher m = regularExpressionString.matcher(str);
        if (m.matches()) {
            String regexEnd;
            String regexStart;
            String regex = m.group(1);
            if (regex.startsWith("^")) {
                regexStart = "^";
                regex = regex.substring(1);
            } else {
                regexStart = ".*";
            }
            if (regex.endsWith("$")) {
                regexEnd = "$";
                regex = regex.substring(0, regex.length() - 1);
            } else {
                regexEnd = ".*";
            }
            p.description = regexStart + regex + regexEnd;
            return p;
        }
        String[] alternates = str.split("\\|");
        int n = alternates.length;
        for (int i = 0; i < n; ++i) {
            Matcher q = quotedString.matcher(alternates[i]);
            if (q.matches()) {
                String quoted = q.group(1);
                alternates[i] = TreePattern.deescapeQuotes(quoted);
                continue;
            }
            if (!TreePattern.hasUnquotedSpecials(alternates[i])) continue;
            throw new RuntimeException("error -- unquoted specials in description subsequence " + alternates[i]);
        }
        StringBuilder result = new StringBuilder();
        int n2 = alternates.length - 1;
        for (int i = 0; i < n2; ++i) {
            result.append(alternates[i]).append("|");
        }
        result.append(alternates[alternates.length - 1]);
        p.description = result.toString();
        return p;
    }

    private static String deescapeQuotes(String str) {
        if (unEscapedQuote.matcher(str).matches()) {
            throw new RuntimeException("error -- unescaped quotation mark \" contained in description string!");
        }
        Matcher m = escapedQuote.matcher(str);
        return m.replaceAll("\"");
    }

    private static boolean hasUnquotedSpecials(String str) {
        return specials.matcher(str).find();
    }

    int size() {
        if (this.children.length == 0) {
            return 1;
        }
        int numKids = 0;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            numKids += this.children[i].size();
        }
        return numKids;
    }

    public String pattern() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.description);
        if (this.name instanceof String) {
            sb.append(this.name);
        }
        sb.append(" ");
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            sb.append(this.children[i].childPattern());
        }
        return sb.toString();
    }

    private String childPattern() {
        if (this.relation == null) {
            throw new RuntimeException("Error -- null relation at node " + this.pattern());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.relation.toString());
        sb.append(" ");
        if (this.children.length > 0) {
            sb.append("( ");
        }
        sb.append(this.description);
        if (this.name instanceof String) {
            sb.append(" ").append(this.name);
        }
        sb.append(" ");
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            sb.append(this.children[i].childPattern());
        }
        if (this.children.length > 0) {
            sb.append(") ");
        }
        return sb.toString();
    }

    public void reset(Tree root) {
        this.initializeSearchOnTree(root, root);
        this.root = root;
        this.lastNode = this;
    }

    public boolean findNext() {
        TreePatternReturnValue result = this.processForward(this.root);
        this.lastNode = result.finalNode;
        return result.success;
    }

    public Tree returnMatch() {
        return this.node();
    }

    TreePatternReturnValue processForward(Tree root) {
        boolean matchesNode = this.matchOnTree(root);
        if (matchesNode) {
            this.initializeChildrenIterator();
            return this.processChildrenForward(root);
        }
        if (this.parent == null) {
            return new TreePatternReturnValue(this);
        }
        return this.parent.processBackward(root);
    }

    void initializeSearchOnTree(Tree t, Tree root) {
        this.it = this.relation.searchNodeIterator(t, root);
    }

    boolean matchOnTree(Tree root) {
        while (this.it.hasNext()) {
            Tree t = this.it.next();
            boolean descriptionMatchesNode = this.descriptionPattern.matcher(t.label().value()).matches();
            if (!(descriptionMatchesNode ^ this.negatedDescription) || this.parent != null && !this.relation.satisfies(this.parent.node(), t, root)) continue;
            this.setNode(t);
            return true;
        }
        return false;
    }

    public void setCurrentResult(TreePatternReturnValue currentResult) {
        this.currentResult = currentResult;
    }

    private void initializeChildrenIterator() {
        this.currentResult = new TreePatternReturnValue(this);
        this.childrenIterator = new MyIterator(Arrays.asList(this.children).listIterator());
    }

    TreePatternReturnValue processChildrenForward(Tree root) {
        if (!this.childrenIterator.hasNext()) {
            this.currentResult.success = true;
            if (this.parent == null) {
                return this.currentResult;
            }
            this.parent.setCurrentResult(this.currentResult);
            return this.parent.processChildrenForward(root);
        }
        this.currentChild = this.childrenIterator.next();
        this.currentChild.initializeSearchOnTree(this.node(), root);
        return this.currentChild.processForward(root);
    }

    TreePatternReturnValue processBackward(Tree root) {
        if (!this.childrenIterator.hasPrevious()) {
            throw new RuntimeException("error -- processBackward() should only be called by a child on a parent");
        }
        this.childrenIterator.previous();
        if (this.childrenIterator.hasPrevious()) {
            this.currentChild = this.childrenIterator.previous();
            this.childrenIterator.next();
            return this.currentChild.processForward(root);
        }
        boolean matchNewTreeNode = this.matchOnTree(root);
        if (matchNewTreeNode) {
            return this.processChildrenForward(root);
        }
        if (this.parent == null) {
            return this.currentResult;
        }
        return this.parent.processBackward(root);
    }

    public static void main(String[] args) {
        TreePattern p = TreePattern.compile(args[0]);
        System.out.println(p.pattern());
        Tree t = null;
        try {
            t = new PennTreeReader((Reader)new StringReader("(VP (VP (VBZ Try) (NP (NP (DT this) (NN wine)) (CC and) (NP (DT these) (NNS snails)))) (PUNCT .))"), new LabeledScoredTreeFactory(new StringLabelFactory())).readTree();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        p.reset(t);
        if (p.findNext()) {
            p.node().pennPrint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListTokenizer
    extends AbstractTokenizer<String> {
        ListIterator<String> li;

        @Override
        protected String getNext() {
            throw new UnsupportedOperationException();
        }

        public ListTokenizer(List<String> l) {
            this.li = l.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.li.hasNext();
        }

        @Override
        public String next() {
            return this.li.next();
        }

        @Override
        public String peek() {
            if (!this.li.hasNext()) {
                return null;
            }
            String result = this.li.next();
            this.li.previous();
            return result;
        }

        @Override
        public void remove() {
            this.li.remove();
        }

        public void setSource(Reader r) {
            throw new UnsupportedOperationException();
        }
    }

    static class NegationDescriptionPair {
        boolean negation = false;
        String description;

        NegationDescriptionPair() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyIterator
    implements TreePatternIterator {
        private final ListIterator<TreePattern> i;

        public MyIterator(ListIterator<TreePattern> i) {
            this.i = i;
        }

        @Override
        public TreePattern next() {
            return this.i.next();
        }

        @Override
        public TreePattern previous() {
            return this.i.previous();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }
    }
}

