/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.trees.FilteringTreeReader;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.arabic.ArabicTreeNormalizer;
import edu.stanford.nlp.trees.international.arabic.ArabicTreebankTokenizer;
import edu.stanford.nlp.util.Filter;
import java.io.Reader;
import java.io.Serializable;

public class ArabicTreeReaderFactory
implements TreeReaderFactory,
Serializable {
    private static final long serialVersionUID = 1973767605277873017L;
    private boolean retainNPTmp;
    private boolean retainPRD;
    private boolean changeNoLabels;
    private boolean mapPrepositions;
    private boolean filterX;

    public ArabicTreeReaderFactory() {
        this(false, false, false, false, false);
    }

    public ArabicTreeReaderFactory(boolean retainNPTmp, boolean retainPRD, boolean changeNoLabels, boolean filterX) {
        this(retainNPTmp, retainPRD, changeNoLabels, filterX, false);
    }

    public ArabicTreeReaderFactory(boolean retainNPTmp, boolean retainPRD, boolean changeNoLabels, boolean filterX, boolean mapPrepositions) {
        this.retainNPTmp = retainNPTmp;
        this.retainPRD = retainPRD;
        this.changeNoLabels = changeNoLabels;
        this.filterX = filterX;
        this.mapPrepositions = mapPrepositions;
    }

    public TreeReader newTreeReader(Reader in) {
        TreeReader tr = new PennTreeReader(in, new LabeledScoredTreeFactory(), new ArabicTreeNormalizer(this.retainNPTmp, this.retainPRD, this.changeNoLabels, this.mapPrepositions), new ArabicTreebankTokenizer(in));
        if (this.filterX) {
            tr = new FilteringTreeReader(tr, new XFilter());
        }
        return tr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XFilter
    implements Filter<Tree> {
        private static final long serialVersionUID = -4522060160716318895L;

        @Override
        public boolean accept(Tree t) {
            return t.numChildren() != 1 || !"X".equals(t.firstChild().value());
        }
    }
}

