/*
 * Decompiled with CFR 0.152.
 */
package mark.chunking;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Rule {
    private static final Pattern pt = Pattern.compile("(T|W|P)(_?[0-3])+");
    private static final Pattern po = Pattern.compile("_?[0-3]");
    private String outTag = null;
    private String rule = null;
    private List types = new ArrayList();
    private List offsets = new ArrayList();
    private List values = new ArrayList();
    private int begin = Integer.MAX_VALUE;
    private int end = Integer.MIN_VALUE;

    public Rule(String rule) {
        this.rule = rule;
        String[] parts = rule.split(" ");
        this.outTag = parts[parts.length - 1];
        Matcher mt = pt.matcher(parts[0]);
        int index = 1;
        while (mt.find()) {
            String to = mt.group();
            this.types.add(to.substring(0, 1));
            ArrayList<Integer> ofs = new ArrayList<Integer>();
            Matcher mo = po.matcher(to.substring(1));
            this.values.add(parts[index++]);
            while (mo.find()) {
                Integer offset = new Integer(mo.group().replaceAll("_", "-"));
                if (offset < this.begin) {
                    this.begin = offset;
                }
                if (offset > this.end) {
                    this.end = offset;
                }
                ofs.add(offset);
            }
            this.offsets.add(ofs);
        }
    }

    public boolean match(int currentToken, List words, List tags, List pos) {
        if (!this.withinSentence(words.size(), currentToken)) {
            return false;
        }
        boolean matched = true;
        for (int i = 0; i < this.types.size(); ++i) {
            String type = (String)this.types.get(i);
            List ofs = (List)this.offsets.get(i);
            String value = (String)this.values.get(i);
            List working = null;
            if (type.equals("T")) {
                working = tags;
            } else if (type.equals("W")) {
                working = words;
            } else if (type.equals("P")) {
                working = pos;
            }
            int offset = (Integer)ofs.get(0);
            boolean matchOffset = ((String)working.get(currentToken + offset)).equals(value);
            for (int j = 1; j < ofs.size(); ++j) {
                offset = (Integer)ofs.get(j);
                matchOffset = matchOffset || ((String)working.get(currentToken + offset)).equals(value);
            }
            boolean bl = matched = matched && matchOffset;
            if (matched) continue;
            i = this.types.size();
        }
        return matched;
    }

    public String getNewTag() {
        return this.outTag;
    }

    public boolean withinSentence(int numTokens, int currentToken) {
        int start = currentToken + this.begin;
        int finish = currentToken + this.end;
        boolean within = start >= 0 && start < numTokens;
        within = within && finish >= 0 && finish < numTokens;
        return within;
    }

    public String toString() {
        return this.rule;
    }
}

