/*
 * Decompiled with CFR 0.152.
 */
package mark.chunking;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mark.chunking.Rule;

public class Chunker {
    private static Chunker _instance;
    private List rules = new ArrayList();
    private Map chunkTags = new HashMap();

    public static Chunker instance() {
        if (_instance == null) {
            try {
                _instance = new Chunker("resources/rules", "resources/pos_tag_dict");
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        return _instance;
    }

    public String processSentence(String line) {
        StringBuffer out2 = new StringBuffer();
        try {
            String[] tokens = line.split(" ");
            ArrayList<String> toks = new ArrayList<String>();
            String current = "";
            for (int k = 0; k < tokens.length; ++k) {
                if ((current = current + tokens[k]).contains("/")) {
                    toks.add(current);
                    current = "";
                    continue;
                }
                current = current + " ";
            }
            tokens = new String[toks.size()];
            toks.toArray(tokens);
            ArrayList<String> wl = new ArrayList<String>();
            List<String> tl = new ArrayList();
            ArrayList<String> pl = new ArrayList<String>();
            for (int i = 0; i < tokens.length; ++i) {
                String[] data = tokens[i].split("/");
                wl.add(data[0]);
                pl.add(data[1]);
                String ct = (String)this.chunkTags.get(data[1]);
                if (ct == null) {
                    ct = "I";
                }
                tl.add(ct);
            }
            tl = this.chunkSentence(wl, tl, pl);
            boolean inBaseNP = false;
            boolean lineBegin = true;
            for (int i = 0; i < wl.size(); ++i) {
                String ct = (String)tl.get(i);
                if (inBaseNP) {
                    if (ct.equals("B")) {
                        out2.append(" ] [");
                    } else if (ct.equals("O")) {
                        out2.append(" ]");
                        inBaseNP = false;
                    }
                } else if (ct.equals("B") || ct.equals("I")) {
                    if (!lineBegin) {
                        out2.append(" ");
                    }
                    lineBegin = false;
                    out2.append("[");
                    inBaseNP = true;
                }
                if (!lineBegin) {
                    out2.append(" ");
                }
                lineBegin = false;
                out2.append(wl.get(i) + "/" + pl.get(i));
            }
            if (inBaseNP) {
                out2.append("]");
            }
            out2.append("\n");
        }
        catch (Exception e) {
            System.out.println("Chunker problem: " + e.getMessage());
            out2.append(line);
        }
        return out2.toString();
    }

    public Chunker(String rulesFile, String tagsFile) throws IOException {
        URL u = new File(rulesFile).toURL();
        BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream()));
        String rule = in.readLine();
        while (rule != null) {
            if (!rule.trim().equals("")) {
                this.rules.add(new Rule(rule));
            }
            rule = in.readLine();
        }
        in = new BufferedReader(new FileReader(tagsFile));
        String line = in.readLine();
        while (line != null) {
            if (!line.trim().equals("")) {
                String[] tags = line.split(" ");
                this.chunkTags.put(tags[0], tags[1]);
            }
            line = in.readLine();
        }
        in.close();
    }

    public List chunkSentence(List words, List tags, List pos) {
        words.add("ZZZ");
        pos.add("ZZZ");
        tags.add("Z");
        Iterator it = this.rules.iterator();
        while (it.hasNext()) {
            ArrayList<String> newTags = new ArrayList<String>();
            Rule r = (Rule)it.next();
            for (int i = 0; i < words.size(); ++i) {
                if (r.match(i, words, tags, pos)) {
                    newTags.add(r.getNewTag());
                    continue;
                }
                newTags.add((String)tags.get(i));
            }
            tags = newTags;
        }
        words.remove(words.size() - 1);
        pos.remove(pos.size() - 1);
        tags.remove(tags.size() - 1);
        return tags;
    }
}

