/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IdentityHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private transient IdentityHashMap map;
    static final long serialVersionUID = -5024744406713321676L;

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(int expectedMaxSize) {
        this.map = new IdentityHashMap(expectedMaxSize);
    }

    public IdentityHashSet(Collection<? extends E> c) {
        this.map = new IdentityHashMap();
        this.addAll(c);
    }

    @Override
    public boolean add(E o) {
        if (this.map.containsKey(o)) {
            return false;
        }
        this.internalAdd(o);
        return true;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        Iterator<E> it = this.iterator();
        IdentityHashSet<E> clone = new IdentityHashSet<E>(this.size() * 2);
        while (it.hasNext()) {
            super.internalAdd(it.next());
        }
        return clone;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public static void main(String[] args) {
        Integer x = 3;
        Integer y = 4;
        Integer z = 5;
        List<Integer> a = Arrays.asList(x, y, z);
        List<String> b = Arrays.asList("Larry", "Moe", "Curly");
        List<Integer> c = Arrays.asList(x, y, z);
        List<String> d = Arrays.asList("Larry", "Moe", "Curly");
        HashSet<List<Object>> hs = new HashSet<List<Object>>();
        IdentityHashSet<List<Object>> ihs = new IdentityHashSet<List<Object>>();
        hs.add(a);
        hs.add(b);
        ihs.add(a);
        ihs.add(b);
        System.out.println("List a is " + a);
        System.out.println("List b is " + b);
        System.out.println("List c is " + c);
        System.out.println("List d is " + d);
        System.out.println("HashSet hs contains a and b: " + hs);
        System.out.println("IdentityHashSet ihs contains a and b: " + ihs);
        System.out.println("hs contains a? " + hs.contains(a));
        System.out.println("hs contains b? " + hs.contains(b));
        System.out.println("hs contains c? " + hs.contains(c));
        System.out.println("hs contains d? " + hs.contains(d));
        System.out.println("ihs contains a? " + ihs.contains(a));
        System.out.println("ihs contains b? " + ihs.contains(b));
        System.out.println("ihs contains c? " + ihs.contains(c));
        System.out.println("ihs contains d? " + ihs.contains(d));
    }

    private void internalAdd(Object o) {
        this.map.put(o, Boolean.TRUE);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<E> it = this.iterator();
        s.writeInt(this.size() * 2);
        s.writeInt(this.size());
        while (it.hasNext()) {
            s.writeObject(it.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int expectedMaxSize = s.readInt();
        int size = s.readInt();
        this.map = new IdentityHashMap(expectedMaxSize);
        for (int i = 0; i < size; ++i) {
            Object o = s.readObject();
            this.internalAdd(o);
        }
    }
}

