/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.TypesafeMap;
import java.util.Map;
import java.util.Set;

public class HashableCoreMap
extends ArrayCoreMap {
    private final Set<Class<CoreAnnotation<?>>> immutableKeys;
    private final int hashcode;
    private static final long serialVersionUID = 1L;

    public HashableCoreMap(Map<Class<CoreAnnotation<?>>, Object> hashkey) {
        int keyHashcode = 0;
        int valueHashcode = 0;
        for (Map.Entry<Class<CoreAnnotation<?>>, Object> entry : hashkey.entrySet()) {
            keyHashcode += entry.getKey().hashCode();
            valueHashcode += entry.getValue().hashCode();
            super.set(entry.getKey(), entry.getValue());
        }
        this.immutableKeys = hashkey.keySet();
        this.hashcode = keyHashcode * 31 + valueHashcode;
    }

    public HashableCoreMap(ArrayCoreMap other, Set<Class<CoreAnnotation<?>>> hashkey) {
        super(other);
        int keyHashcode = 0;
        int valueHashcode = 0;
        for (Class<CoreAnnotation<?>> key : hashkey) {
            keyHashcode += key.hashCode();
            valueHashcode += super.get(key).hashCode();
        }
        this.immutableKeys = hashkey;
        this.hashcode = keyHashcode * 31 + valueHashcode;
    }

    @Override
    public <VALUEBASE, VALUE extends VALUEBASE, KEY extends TypesafeMap.Key<CoreMap, VALUEBASE>> VALUE set(Class<KEY> key, VALUE value) {
        if (this.immutableKeys.contains(key)) {
            throw new HashableCoreMapException("Attempt to change value of immutable field " + key.getSimpleName());
        }
        return super.set(key, value);
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof HashableCoreMap) {
            HashableCoreMap other = (HashableCoreMap)o;
            if (!((Object)other.immutableKeys).equals(this.immutableKeys)) {
                return false;
            }
            for (Class<CoreAnnotation<?>> key : this.immutableKeys) {
                if (this.get(key).equals(other.get(key))) continue;
                return false;
            }
            return true;
        }
        return super.equals(o);
    }

    public static class HashableCoreMapException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public HashableCoreMapException(String message) {
            super(message);
        }
    }
}

