/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.PriorityQueue;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class FixedPrioritiesPriorityQueue<E>
extends AbstractSet<E>
implements PriorityQueue<E>,
Iterator<E>,
Serializable,
Cloneable {
    private int size;
    private int capacity;
    private List<E> elements;
    private double[] priorities;

    public FixedPrioritiesPriorityQueue() {
        this(15);
    }

    public FixedPrioritiesPriorityQueue(int capacity) {
        int legalCapacity = 0;
        while (legalCapacity < capacity) {
            legalCapacity = 2 * legalCapacity + 1;
        }
        this.grow(legalCapacity);
    }

    @Override
    public boolean hasNext() {
        return !this.isEmpty();
    }

    @Override
    public E next() {
        return this.removeFirst();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E key, double priority) {
        if (this.size == this.capacity) {
            this.grow(2 * this.capacity + 1);
        }
        this.elements.add(key);
        this.priorities[this.size] = priority;
        this.heapifyUp(this.size);
        ++this.size;
        return true;
    }

    @Override
    public boolean changePriority(E key, double priority) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E getFirst() {
        if (this.size() > 0) {
            return this.elements.get(0);
        }
        throw new NoSuchElementException();
    }

    @Override
    public double getPriority(Object key) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!this.elements.get(i).equals(key)) continue;
            return this.priorities[i];
        }
        throw new NoSuchElementException();
    }

    @Override
    public double getPriority() {
        if (this.size() > 0) {
            return this.priorities[0];
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean relaxPriority(E key, double priority) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E removeFirst() {
        E first = this.getFirst();
        this.swap(0, this.size - 1);
        --this.size;
        this.elements.remove(this.size);
        this.heapifyDown(0);
        return first;
    }

    @Override
    public List<E> toSortedList() {
        ArrayList<E> list = new ArrayList<E>();
        while (this.hasNext()) {
            list.add(this.next());
        }
        return list;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.grow(15);
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.toSortedList()).iterator();
    }

    private void grow(int newCapacity) {
        ArrayList<E> newElements = new ArrayList<E>(newCapacity);
        double[] newPriorities = new double[newCapacity];
        if (this.size > 0) {
            newElements.addAll(this.elements);
            System.arraycopy(this.priorities, 0, newPriorities, 0, this.priorities.length);
        }
        this.elements = newElements;
        this.priorities = newPriorities;
        this.capacity = newCapacity;
    }

    private static int parent(int loc) {
        return (loc - 1) / 2;
    }

    private static int leftChild(int loc) {
        return 2 * loc + 1;
    }

    private static int rightChild(int loc) {
        return 2 * loc + 2;
    }

    private void heapifyUp(int loc) {
        if (loc == 0) {
            return;
        }
        int parent = FixedPrioritiesPriorityQueue.parent(loc);
        if (this.priorities[loc] > this.priorities[parent]) {
            this.swap(loc, parent);
            this.heapifyUp(parent);
        }
    }

    private void heapifyDown(int loc) {
        int max = loc;
        int leftChild = FixedPrioritiesPriorityQueue.leftChild(loc);
        if (leftChild < this.size()) {
            double rightChildPriority;
            int rightChild;
            double leftChildPriority = this.priorities[leftChild];
            double priority = this.priorities[loc];
            if (leftChildPriority > priority) {
                max = leftChild;
            }
            if ((rightChild = FixedPrioritiesPriorityQueue.rightChild(loc)) < this.size() && (rightChildPriority = this.priorities[FixedPrioritiesPriorityQueue.rightChild(loc)]) > priority && rightChildPriority > leftChildPriority) {
                max = rightChild;
            }
        }
        if (max == loc) {
            return;
        }
        this.swap(loc, max);
        this.heapifyDown(max);
    }

    private void swap(int loc1, int loc2) {
        double tempPriority = this.priorities[loc1];
        E tempElement = this.elements.get(loc1);
        this.priorities[loc1] = this.priorities[loc2];
        this.elements.set(loc1, this.elements.get(loc2));
        this.priorities[loc2] = tempPriority;
        this.elements.set(loc2, tempElement);
    }

    @Override
    public String toString() {
        return this.toString(this.size());
    }

    @Override
    public String toString(int maxKeysToPrint) {
        int numKeysPrinted;
        if (maxKeysToPrint <= 0) {
            maxKeysToPrint = Integer.MAX_VALUE;
        }
        Object pq = this.clone();
        StringBuilder sb = new StringBuilder("[");
        for (numKeysPrinted = 0; numKeysPrinted < maxKeysToPrint && ((FixedPrioritiesPriorityQueue)pq).hasNext(); ++numKeysPrinted) {
            double priority = ((FixedPrioritiesPriorityQueue)pq).getPriority();
            E element = ((FixedPrioritiesPriorityQueue)pq).next();
            sb.append(element.toString());
            sb.append(" : ");
            sb.append(priority);
            if (numKeysPrinted >= this.size() - 1) continue;
            sb.append(", ");
        }
        if (numKeysPrinted < this.size()) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public FixedPrioritiesPriorityQueue<E> clone() {
        FixedPrioritiesPriorityQueue<E> clonePQ = new FixedPrioritiesPriorityQueue<E>();
        clonePQ.size = this.size;
        clonePQ.capacity = this.capacity;
        clonePQ.elements = new ArrayList(this.capacity);
        clonePQ.priorities = new double[this.capacity];
        if (this.size() > 0) {
            clonePQ.elements.addAll(this.elements);
            System.arraycopy(this.priorities, 0, clonePQ.priorities, 0, this.size());
        }
        return clonePQ;
    }

    public static void main(String[] args) {
        FixedPrioritiesPriorityQueue<String> pq = new FixedPrioritiesPriorityQueue<String>();
        System.out.println(pq);
        pq.add("one", 1.0);
        System.out.println(pq);
        pq.add("three", 3.0);
        System.out.println(pq);
        pq.add("one", 1.1);
        System.out.println(pq);
        pq.add("two", 2.0);
        System.out.println(pq);
        System.out.println(pq.toString(2));
        while (pq.hasNext()) {
            System.out.println((String)pq.next());
        }
    }
}

