/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

public abstract class CollectionFactory<T>
implements Serializable {
    public static final CollectionFactory ARRAY_LIST_FACTORY = new ArrayListFactory();
    public static final CollectionFactory LINKED_LIST_FACTORY = new LinkedListFactory();
    public static final CollectionFactory HASH_SET_FACTORY = new HashSetFactory();

    public static <E> CollectionFactory<E> hashSetFactory() {
        return HASH_SET_FACTORY;
    }

    public static <E> CollectionFactory<E> arrayListFactory() {
        return ARRAY_LIST_FACTORY;
    }

    public static <E> CollectionFactory<E> linkedListFactory() {
        return LINKED_LIST_FACTORY;
    }

    public abstract Collection<T> newCollection();

    public abstract Collection<T> newEmptyCollection();

    public static class HashSetFactory<T>
    extends CollectionFactory<T> {
        @Override
        public Collection<T> newCollection() {
            return new HashSet();
        }

        @Override
        public Collection<T> newEmptyCollection() {
            return Collections.emptySet();
        }
    }

    public static class LinkedListFactory<T>
    extends CollectionFactory<T> {
        @Override
        public Collection<T> newCollection() {
            return new LinkedList();
        }

        @Override
        public Collection<T> newEmptyCollection() {
            return Collections.emptyList();
        }
    }

    public static class ArrayListFactory<T>
    extends CollectionFactory<T> {
        @Override
        public Collection<T> newCollection() {
            return new ArrayList();
        }

        @Override
        public Collection<T> newEmptyCollection() {
            return Collections.emptyList();
        }
    }
}

