/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.PriorityQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class BinaryHeapPriorityQueue<E>
extends AbstractSet<E>
implements PriorityQueue<E>,
Iterator<E> {
    private List<Entry<E>> indexToEntry = new ArrayList<Entry<E>>();
    private Map<Object, Entry<E>> keyToEntry;

    @Override
    public boolean hasNext() {
        return this.size() > 0;
    }

    @Override
    public E next() {
        return this.removeFirst();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Entry<E> parent(Entry<E> entry) {
        int index = entry.index;
        return index > 0 ? this.getEntry((index - 1) / 2) : null;
    }

    private Entry<E> leftChild(Entry<E> entry) {
        int leftIndex = entry.index * 2 + 1;
        return leftIndex < this.size() ? this.getEntry(leftIndex) : null;
    }

    private Entry<E> rightChild(Entry<E> entry) {
        int index = entry.index;
        int rightIndex = index * 2 + 2;
        return rightIndex < this.size() ? this.getEntry(rightIndex) : null;
    }

    private int compare(Entry<E> entryA, Entry<E> entryB) {
        return BinaryHeapPriorityQueue.compare(entryA.priority, entryB.priority);
    }

    private static int compare(double a, double b) {
        double diff = a - b;
        if (diff > 0.0) {
            return 1;
        }
        if (diff < 0.0) {
            return -1;
        }
        return 0;
    }

    private void swap(Entry<E> entryA, Entry<E> entryB) {
        int indexB;
        int indexA = entryA.index;
        entryA.index = indexB = entryB.index;
        entryB.index = indexA;
        this.indexToEntry.set(indexA, entryB);
        this.indexToEntry.set(indexB, entryA);
    }

    private void removeLastEntry() {
        Entry<E> entry = this.indexToEntry.remove(this.size() - 1);
        this.keyToEntry.remove(entry.key);
    }

    private Entry<E> getEntry(E key) {
        return this.keyToEntry.get(key);
    }

    private Entry<E> getEntry(int index) {
        Entry<E> entry = this.indexToEntry.get(index);
        return entry;
    }

    private Entry<E> makeEntry(E key) {
        Entry entry = new Entry();
        entry.index = this.size();
        entry.key = key;
        entry.priority = Double.NEGATIVE_INFINITY;
        this.indexToEntry.add(entry);
        this.keyToEntry.put(key, entry);
        return entry;
    }

    private void heapifyUp(Entry<E> entry) {
        Entry<E> parentEntry;
        while (entry.index != 0 && this.compare(entry, parentEntry = this.parent(entry)) > 0) {
            this.swap(entry, parentEntry);
        }
    }

    private void heapifyDown(Entry<E> entry) {
        Entry<E> bestEntry;
        Entry<E> currentEntry = entry;
        do {
            Entry<E> rightEntry;
            bestEntry = currentEntry;
            Entry<E> leftEntry = this.leftChild(currentEntry);
            if (leftEntry != null && this.compare(bestEntry, leftEntry) < 0) {
                bestEntry = leftEntry;
            }
            if ((rightEntry = this.rightChild(currentEntry)) != null && this.compare(bestEntry, rightEntry) < 0) {
                bestEntry = rightEntry;
            }
            if (bestEntry == currentEntry) continue;
            this.swap(bestEntry, currentEntry);
        } while (bestEntry != currentEntry);
    }

    private void heapify(Entry<E> entry) {
        this.heapifyUp(entry);
        this.heapifyDown(entry);
    }

    @Override
    public E removeFirst() {
        E first = this.getFirst();
        this.remove(first);
        return first;
    }

    @Override
    public E getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getEntry((int)0).key;
    }

    @Override
    public double getPriority() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getEntry((int)0).priority;
    }

    public E getObject(E key) {
        if (!this.contains(key)) {
            return null;
        }
        Entry<E> e = this.getEntry(key);
        return e.key;
    }

    @Override
    public double getPriority(E key) {
        Entry<E> entry = this.getEntry(key);
        if (entry == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return entry.priority;
    }

    @Override
    public boolean add(E key) {
        if (this.contains(key)) {
            return false;
        }
        this.makeEntry(key);
        return true;
    }

    @Override
    public boolean add(E key, double priority) {
        if (this.add(key)) {
            this.relaxPriority(key, priority);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object key) {
        Object eKey = key;
        Entry<Object> entry = this.getEntry(eKey);
        if (entry == null) {
            return false;
        }
        this.removeEntry(entry);
        return true;
    }

    private void removeEntry(Entry<E> entry) {
        Entry<E> lastEntry = this.getLastEntry();
        if (entry != lastEntry) {
            this.swap(entry, lastEntry);
            this.removeLastEntry();
            this.heapify(lastEntry);
        } else {
            this.removeLastEntry();
        }
    }

    private Entry<E> getLastEntry() {
        return this.getEntry(this.size() - 1);
    }

    @Override
    public boolean relaxPriority(E key, double priority) {
        Entry<E> entry = this.getEntry(key);
        if (entry == null) {
            entry = this.makeEntry(key);
        }
        if (BinaryHeapPriorityQueue.compare(priority, entry.priority) <= 0) {
            return false;
        }
        entry.priority = priority;
        this.heapifyUp(entry);
        return true;
    }

    public boolean decreasePriority(E key, double priority) {
        Entry<E> entry = this.getEntry(key);
        if (entry == null) {
            entry = this.makeEntry(key);
        }
        if (BinaryHeapPriorityQueue.compare(priority, entry.priority) >= 0) {
            return false;
        }
        entry.priority = priority;
        this.heapifyDown(entry);
        return true;
    }

    @Override
    public boolean changePriority(E key, double priority) {
        Entry<E> entry = this.getEntry(key);
        if (entry == null) {
            entry = this.makeEntry(key);
        }
        if (BinaryHeapPriorityQueue.compare(priority, entry.priority) == 0) {
            return false;
        }
        entry.priority = priority;
        this.heapify(entry);
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.indexToEntry.isEmpty();
    }

    @Override
    public int size() {
        return this.indexToEntry.size();
    }

    @Override
    public boolean contains(Object key) {
        return this.keyToEntry.containsKey(key);
    }

    @Override
    public List<E> toSortedList() {
        ArrayList<E> sortedList = new ArrayList<E>(this.size());
        BinaryHeapPriorityQueue<E> queue = this.deepCopy();
        while (!queue.isEmpty()) {
            sortedList.add(queue.removeFirst());
        }
        return sortedList;
    }

    public BinaryHeapPriorityQueue<E> deepCopy(MapFactory<Object, Entry<E>> mapFactory) {
        BinaryHeapPriorityQueue queue = new BinaryHeapPriorityQueue(mapFactory);
        for (Entry<E> entry : this.keyToEntry.values()) {
            queue.relaxPriority(entry.key, entry.priority);
        }
        return queue;
    }

    public BinaryHeapPriorityQueue<E> deepCopy() {
        return this.deepCopy(MapFactory.HASH_MAP_FACTORY);
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.toSortedList()).iterator();
    }

    @Override
    public void clear() {
        this.indexToEntry.clear();
        this.keyToEntry.clear();
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int maxKeysToPrint) {
        if (maxKeysToPrint <= 0) {
            maxKeysToPrint = Integer.MAX_VALUE;
        }
        List<E> sortedKeys = this.toSortedList();
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < maxKeysToPrint && i < sortedKeys.size(); ++i) {
            E key = sortedKeys.get(i);
            sb.append(key).append("=").append(this.getPriority(key));
            if (i >= maxKeysToPrint - 1 || i >= sortedKeys.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toVerticalString() {
        List<E> sortedKeys = this.toSortedList();
        StringBuilder sb = new StringBuilder();
        Iterator<E> keyI = sortedKeys.iterator();
        while (keyI.hasNext()) {
            E key = keyI.next();
            sb.append(key);
            sb.append("\t");
            sb.append(this.getPriority(key));
            if (!keyI.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public BinaryHeapPriorityQueue() {
        this(MapFactory.HASH_MAP_FACTORY);
    }

    public BinaryHeapPriorityQueue(MapFactory<Object, Entry<E>> mapFactory) {
        this.keyToEntry = mapFactory.newMap();
    }

    public static void main(String[] args) {
        BinaryHeapPriorityQueue<String> queue = new BinaryHeapPriorityQueue<String>();
        queue.add("a", 1.0);
        System.out.println("Added a:1 " + queue);
        queue.add("b", 2.0);
        System.out.println("Added b:2 " + queue);
        queue.add("c", 1.5);
        System.out.println("Added c:1.5 " + queue);
        queue.relaxPriority("a", 3.0);
        System.out.println("Increased a to 3 " + queue);
        queue.decreasePriority("b", 0.0);
        System.out.println("Decreased b to 0 " + queue);
        System.out.println("removeFirst()=" + (String)queue.removeFirst());
        System.out.println("queue=" + queue);
        System.out.println("removeFirst()=" + (String)queue.removeFirst());
        System.out.println("queue=" + queue);
        System.out.println("removeFirst()=" + (String)queue.removeFirst());
        System.out.println("queue=" + queue);
    }

    private static final class Entry<E> {
        public E key;
        public int index;
        public double priority;

        private Entry() {
        }

        public String toString() {
            return this.key + " at " + this.index + " (" + this.priority + ")";
        }
    }
}

