/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TreeMatcher;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonParser;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPatternRoot;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tsurgeon {
    static boolean verbose = false;
    static final Pattern emptyLinePattern = Pattern.compile("^\\s*$");
    static final String commentIntroducingCharacter = "%";
    static final Pattern commentPattern = Pattern.compile("%.*$");
    static final Pattern escapedCommentCharacterPattern = Pattern.compile("\\%");
    private static boolean matchedOnTree;

    private Tsurgeon() {
    }

    public static void main(String[] args) throws Exception {
        String encoding = "UTF-8";
        String encodingOption = "-encoding";
        if (args.length == 0) {
            System.err.println("Usage: java edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon [-s] -treeFile <file-with-trees> [-po <matching-pattern> <operation>] <operation-file-1> <operation-file-1> ... <operation-file-n>");
            System.exit(0);
        }
        String singleLineOption = "-s";
        String verboseOption = "-v";
        String matchedOption = "-m";
        String patternOperationOption = "-po";
        String treeFileOption = "-treeFile";
        HashMap<String, Integer> flagMap = new HashMap<String, Integer>();
        flagMap.put(patternOperationOption, 2);
        flagMap.put(treeFileOption, 1);
        flagMap.put(singleLineOption, 0);
        flagMap.put(encodingOption, 1);
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, flagMap);
        args = argsMap.get(null);
        if (argsMap.containsKey(verboseOption)) {
            verbose = true;
        }
        String treePrintFormats = argsMap.containsKey(singleLineOption) ? "oneline," : "penn,";
        if (argsMap.containsKey(encodingOption)) {
            encoding = argsMap.get(encodingOption)[0];
        }
        TreePrint tp = new TreePrint(treePrintFormats, new PennTreebankLanguagePack());
        PrintWriter pwOut = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, encoding), true);
        tp.setPrintWriter(pwOut);
        DiskTreebank trees = new DiskTreebank(new TreeMatcher.TRegexTreeReaderFactory(), encoding);
        if (argsMap.containsKey(treeFileOption)) {
            trees.loadPath(argsMap.get(treeFileOption)[0]);
        }
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> ops = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
        if (argsMap.containsKey(patternOperationOption)) {
            TregexPattern matchPattern = TregexPattern.compile(argsMap.get(patternOperationOption)[0]);
            TsurgeonPattern p = Tsurgeon.parseOperation(argsMap.get(patternOperationOption)[1]);
            ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern, p));
        } else {
            for (String arg : args) {
                Pair<TregexPattern, TsurgeonPattern> pair = Tsurgeon.getOperationFromFile(arg);
                if (verbose) {
                    System.err.println(pair.second());
                }
                ops.add(pair);
            }
        }
        for (Tree t : trees) {
            Tree original = t.deeperCopy();
            Tree result = Tsurgeon.processPatternsOnTree(ops, t);
            if (argsMap.containsKey(matchedOption) && matchedOnTree) {
                pwOut.println("Operated on: ");
                Tsurgeon.disposeOfTree(original, tp, pwOut);
                pwOut.println("Result: ");
            }
            Tsurgeon.disposeOfTree(result, tp, pwOut);
        }
    }

    private static void disposeOfTree(Tree t, TreePrint tp, PrintWriter pw) {
        if (t == null) {
            System.out.println("null");
        } else {
            tp.printTree(t, pw);
        }
    }

    public static Pair<TregexPattern, TsurgeonPattern> getOperationFromReader(BufferedReader reader) throws IOException {
        TregexPattern matchPattern;
        String patternString = Tsurgeon.getPatternFromFile(reader);
        try {
            matchPattern = TregexPattern.compile(patternString);
        }
        catch (ParseException e) {
            System.err.println("Error parsing your tregex pattern:\n" + patternString);
            throw new RuntimeException(e);
        }
        TsurgeonPattern collectedPattern = Tsurgeon.getTsurgeonOperationsFromReader(reader);
        return new Pair<TregexPattern, TsurgeonPattern>(matchPattern, collectedPattern);
    }

    public static String getPatternFromFile(BufferedReader reader) throws IOException {
        String thisLine;
        StringBuilder matchString = new StringBuilder();
        while ((thisLine = reader.readLine()) != null && !emptyLinePattern.matcher(thisLine).matches()) {
            matchString.append(thisLine);
        }
        return matchString.toString();
    }

    public static TsurgeonPattern getTsurgeonOperationsFromReader(BufferedReader reader) throws IOException {
        String thisLine;
        ArrayList<TsurgeonPattern> operations = new ArrayList<TsurgeonPattern>();
        while ((thisLine = reader.readLine()) != null) {
            Matcher m = commentPattern.matcher(thisLine);
            thisLine = m.replaceFirst("");
            Matcher m1 = escapedCommentCharacterPattern.matcher(thisLine);
            if (emptyLinePattern.matcher(thisLine = m1.replaceAll(commentIntroducingCharacter)).matches()) continue;
            try {
                operations.add(TsurgeonParser.parse(thisLine));
            }
            catch (edu.stanford.nlp.trees.tregex.tsurgeon.ParseException e) {
                System.err.println("Error parsing your tsurgeon operation:\n" + thisLine);
                throw new RuntimeException(e.toString());
            }
        }
        return Tsurgeon.collectOperations(operations);
    }

    public static String getTsurgeonTextFromReader(BufferedReader reader) throws IOException {
        String thisLine;
        StringBuilder sb = new StringBuilder();
        while ((thisLine = reader.readLine()) != null) {
            Matcher m = commentPattern.matcher(thisLine);
            thisLine = m.replaceFirst("");
            Matcher m1 = escapedCommentCharacterPattern.matcher(thisLine);
            if (emptyLinePattern.matcher(thisLine = m1.replaceAll(commentIntroducingCharacter)).matches()) continue;
            sb.append(thisLine);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static Pair<TregexPattern, TsurgeonPattern> getOperationFromFile(String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        Pair<TregexPattern, TsurgeonPattern> operation = Tsurgeon.getOperationFromReader(reader);
        reader.close();
        return operation;
    }

    public static List<Tree> processPatternOnTrees(TregexPattern matchPattern, TsurgeonPattern p, Collection<Tree> inputTrees) {
        ArrayList<Tree> result = new ArrayList<Tree>();
        for (Tree tree : inputTrees) {
            result.add(Tsurgeon.processPattern(matchPattern, p, tree));
        }
        return result;
    }

    public static Tree processPattern(TregexPattern matchPattern, TsurgeonPattern p, Tree t) {
        TregexMatcher m = matchPattern.matcher(t);
        while (m.find() && (t = p.evaluate(t, m)) != null) {
            m = matchPattern.matcher(t);
        }
        return t;
    }

    public static Tree processPatternsOnTree(List<Pair<TregexPattern, TsurgeonPattern>> ops, Tree t) {
        matchedOnTree = false;
        for (Pair<TregexPattern, TsurgeonPattern> op : ops) {
            try {
                TregexMatcher m = op.first().matcher(t);
                while (m.find()) {
                    matchedOnTree = true;
                    t = op.second().evaluate(t, m);
                    if (t == null) {
                        return null;
                    }
                    m = op.first().matcher(t);
                }
            }
            catch (NullPointerException npe) {
                throw new RuntimeException("Tsurgeon.processPatternsOnTree failed to match label for pattern: " + op.first() + ", " + op.second(), npe);
            }
        }
        return t;
    }

    public static TsurgeonPattern parseOperation(String operationString) {
        try {
            return new TsurgeonPatternRoot(new TsurgeonPattern[]{TsurgeonParser.parse(operationString)});
        }
        catch (edu.stanford.nlp.trees.tregex.tsurgeon.ParseException e) {
            throw new IllegalArgumentException("Ill-formed operation string: " + operationString, e);
        }
    }

    public static TsurgeonPattern collectOperations(List<TsurgeonPattern> patterns) {
        return new TsurgeonPatternRoot(patterns.toArray(new TsurgeonPattern[patterns.size()]));
    }
}

