/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.HoldTreeNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.TreeLocation;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPatternRoot;
import edu.stanford.nlp.util.Pair;

class InsertNode
extends TsurgeonPattern {
    TreeLocation l;

    public InsertNode(TsurgeonPattern child, TreeLocation l) {
        super("insert", new TsurgeonPattern[]{child});
        this.l = l;
    }

    @Override
    protected void setRoot(TsurgeonPatternRoot root) {
        super.setRoot(root);
        this.l.setRoot(root);
    }

    public InsertNode(AuxiliaryTree t, TreeLocation l) {
        this(new HoldTreeNode(t), l);
    }

    @Override
    public Tree evaluate(Tree t, TregexMatcher m) {
        Tree nodeToInsert = this.children[0].evaluate(t, m);
        Pair<Tree, Integer> position = this.l.evaluate(t, m);
        position.first().insertDtr(nodeToInsert, position.second());
        return t;
    }

    @Override
    public String toString() {
        return this.label + "(" + this.children[0] + " " + this.l + ")";
    }
}

