/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.tregex.CoordinationPattern;
import edu.stanford.nlp.trees.tregex.DescriptionPattern;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.Relation;
import edu.stanford.nlp.trees.tregex.SimpleCharStream;
import edu.stanford.nlp.trees.tregex.Token;
import edu.stanford.nlp.trees.tregex.TregexParserConstants;
import edu.stanford.nlp.trees.tregex.TregexParserTokenManager;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.Pair;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

class TregexParser
implements TregexParserConstants {
    private static boolean underNegation = false;
    private static boolean jj_initialized_once = false;
    public static TregexParserTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static List jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;

    static TregexPattern parse(String s) throws ParseException {
        underNegation = false;
        if (jj_initialized_once) {
            TregexParser.ReInit(new StringReader(s + "\n"));
        } else {
            new TregexParser(new StringReader(s + "\n"));
        }
        return TregexParser.Root();
    }

    public static final TregexPattern Root() throws ParseException {
        DescriptionPattern node = TregexParser.SubNode(Relation.ROOT);
        TregexParser.jj_consume_token(11);
        return node;
    }

    public static final TregexPattern Node(Relation r) throws ParseException {
        DescriptionPattern node;
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 12: {
                TregexParser.jj_consume_token(12);
                node = TregexParser.SubNode(r);
                TregexParser.jj_consume_token(13);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                node = TregexParser.ModDescription(r);
                break;
            }
            default: {
                TregexParser.jj_la1[0] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    public static final DescriptionPattern SubNode(Relation r) throws ParseException {
        DescriptionPattern result = null;
        TregexPattern child = null;
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 12: {
                TregexParser.jj_consume_token(12);
                result = TregexParser.SubNode(r);
                TregexParser.jj_consume_token(13);
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 4: 
                    case 5: 
                    case 14: 
                    case 22: 
                    case 23: {
                        child = TregexParser.ChildrenDisj();
                        break;
                    }
                    default: {
                        TregexParser.jj_la1[1] = jj_gen;
                    }
                }
                if (child != null) {
                    ArrayList<TregexPattern> newChildren = new ArrayList<TregexPattern>();
                    newChildren.addAll(result.getChildren());
                    newChildren.add(child);
                    result.setChild(new CoordinationPattern(newChildren, true));
                }
                return result;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                result = TregexParser.ModDescription(r);
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 4: 
                    case 5: 
                    case 14: 
                    case 22: 
                    case 23: {
                        child = TregexParser.ChildrenDisj();
                        break;
                    }
                    default: {
                        TregexParser.jj_la1[2] = jj_gen;
                    }
                }
                if (child != null) {
                    result.setChild(child);
                }
                return result;
            }
        }
        TregexParser.jj_la1[3] = jj_gen;
        TregexParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final DescriptionPattern ModDescription(Relation r) throws ParseException {
        boolean neg = false;
        boolean cat = false;
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 14: {
                TregexParser.jj_consume_token(14);
                neg = true;
                break;
            }
            default: {
                TregexParser.jj_la1[4] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 15: {
                TregexParser.jj_consume_token(15);
                cat = true;
                break;
            }
            default: {
                TregexParser.jj_la1[5] = jj_gen;
            }
        }
        DescriptionPattern node = TregexParser.Description(r, neg, cat);
        return node;
    }

    public static final DescriptionPattern Description(Relation r, boolean negateDesc, boolean cat) throws ParseException {
        Token desc = null;
        Token name = null;
        boolean link = false;
        ArrayList<Pair<Integer, String>> varGroups = new ArrayList<Pair<Integer, String>>();
        block0 : switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 7: 
            case 8: 
            case 9: {
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 7: {
                        desc = TregexParser.jj_consume_token(7);
                        break;
                    }
                    case 9: {
                        desc = TregexParser.jj_consume_token(9);
                        break;
                    }
                    case 8: {
                        desc = TregexParser.jj_consume_token(8);
                        break;
                    }
                    default: {
                        TregexParser.jj_la1[6] = jj_gen;
                        TregexParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block19: while (true) {
                    switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                        case 16: {
                            break;
                        }
                        default: {
                            TregexParser.jj_la1[7] = jj_gen;
                            break block19;
                        }
                    }
                    TregexParser.jj_consume_token(16);
                    Token groupNum = TregexParser.jj_consume_token(6);
                    TregexParser.jj_consume_token(17);
                    Token groupVar = TregexParser.jj_consume_token(7);
                    varGroups.add(new Pair<Integer, String>(Integer.parseInt(groupNum.image), groupVar.image));
                }
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 18: {
                        TregexParser.jj_consume_token(18);
                        name = TregexParser.jj_consume_token(7);
                        if (!underNegation) break block0;
                        throw new ParseException("No named tregex nodes allowed in the scope of negation.");
                    }
                    default: {
                        TregexParser.jj_la1[8] = jj_gen;
                        break;
                    }
                }
                break;
            }
            case 18: 
            case 19: {
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 18: {
                        TregexParser.jj_consume_token(18);
                        break;
                    }
                    case 19: {
                        TregexParser.jj_consume_token(19);
                        link = true;
                        break;
                    }
                    default: {
                        TregexParser.jj_la1[9] = jj_gen;
                        TregexParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                name = TregexParser.jj_consume_token(7);
                break;
            }
            default: {
                TregexParser.jj_la1[10] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DescriptionPattern ret = new DescriptionPattern(r, negateDesc, desc != null ? desc.image : null, name != null ? name.image : null, cat, varGroups);
        if (link) {
            ret.makeLink();
        }
        return ret;
    }

    public static final TregexPattern ChildrenDisj() throws ParseException {
        ArrayList<TregexPattern> children = new ArrayList<TregexPattern>();
        TregexPattern child = TregexParser.ChildrenConj();
        children.add(child);
        block3: while (true) {
            switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    TregexParser.jj_la1[11] = jj_gen;
                    break block3;
                }
            }
            TregexParser.jj_consume_token(20);
            child = TregexParser.ChildrenConj();
            children.add(child);
        }
        if (children.size() == 1) {
            return child;
        }
        return new CoordinationPattern(children, false);
    }

    public static final TregexPattern ChildrenConj() throws ParseException {
        ArrayList<TregexPattern> children = new ArrayList<TregexPattern>();
        TregexPattern child = TregexParser.ModChild();
        children.add(child);
        block6: while (true) {
            switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                case 4: 
                case 5: 
                case 14: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    TregexParser.jj_la1[12] = jj_gen;
                    break block6;
                }
            }
            switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                case 21: {
                    TregexParser.jj_consume_token(21);
                    break;
                }
                default: {
                    TregexParser.jj_la1[13] = jj_gen;
                }
            }
            child = TregexParser.ModChild();
            children.add(child);
        }
        if (children.size() == 1) {
            return child;
        }
        return new CoordinationPattern(children, true);
    }

    public static final TregexPattern ModChild() throws ParseException {
        TregexPattern child;
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 4: 
            case 5: 
            case 23: {
                child = TregexParser.Child();
                break;
            }
            case 14: {
                TregexParser.jj_consume_token(14);
                boolean startUnderNeg = underNegation;
                underNegation = true;
                child = TregexParser.Child();
                underNegation = startUnderNeg;
                child.negate();
                break;
            }
            case 22: {
                TregexParser.jj_consume_token(22);
                child = TregexParser.Child();
                child.makeOptional();
                break;
            }
            default: {
                TregexParser.jj_la1[14] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return child;
    }

    public static final TregexPattern Child() throws ParseException {
        TregexPattern child;
        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 23: {
                TregexParser.jj_consume_token(23);
                child = TregexParser.ChildrenDisj();
                TregexParser.jj_consume_token(24);
                break;
            }
            case 4: 
            case 5: {
                child = TregexParser.Relation();
                break;
            }
            default: {
                TregexParser.jj_la1[15] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return child;
    }

    public static final TregexPattern Relation() throws ParseException {
        Relation r;
        Token t;
        Token strArg = null;
        Token numArg = null;
        Token negation = null;
        block0 : switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
            case 4: {
                t = TregexParser.jj_consume_token(4);
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 6: {
                        numArg = TregexParser.jj_consume_token(6);
                        break block0;
                    }
                }
                TregexParser.jj_la1[16] = jj_gen;
                break;
            }
            case 5: {
                t = TregexParser.jj_consume_token(5);
                switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                    case 12: {
                        TregexParser.jj_consume_token(12);
                        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                            case 14: {
                                negation = TregexParser.jj_consume_token(14);
                                break;
                            }
                            default: {
                                TregexParser.jj_la1[17] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                            case 9: {
                                strArg = TregexParser.jj_consume_token(9);
                                break;
                            }
                            case 7: {
                                strArg = TregexParser.jj_consume_token(7);
                                break;
                            }
                            case 8: {
                                strArg = TregexParser.jj_consume_token(8);
                                break;
                            }
                            default: {
                                TregexParser.jj_la1[18] = jj_gen;
                                TregexParser.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        TregexParser.jj_consume_token(13);
                        break block0;
                    }
                    case 9: 
                    case 14: {
                        switch (jj_ntk == -1 ? TregexParser.jj_ntk() : jj_ntk) {
                            case 14: {
                                negation = TregexParser.jj_consume_token(14);
                                break;
                            }
                            default: {
                                TregexParser.jj_la1[19] = jj_gen;
                            }
                        }
                        strArg = TregexParser.jj_consume_token(9);
                        break block0;
                    }
                }
                TregexParser.jj_la1[20] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                TregexParser.jj_la1[21] = jj_gen;
                TregexParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (strArg != null) {
            r = Relation.getRelation(t.image, negation == null ? strArg.image : "!" + strArg.image);
        } else if (numArg != null) {
            if (t.image.endsWith("-")) {
                t.image = t.image.substring(0, t.image.length() - 1);
                numArg.image = "-" + numArg.image;
            }
            r = Relation.getRelation(t.image, numArg.image);
        } else {
            r = Relation.getRelation(t.image);
        }
        TregexPattern child = TregexParser.Node(r);
        return child;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{840576, 12599344, 12599344, 840576, 16384, 32768, 896, 65536, 262144, 786432, 787328, 0x100000, 14696496, 0x200000, 12599344, 0x800030, 64, 16384, 896, 16384, 20992, 48};
    }

    public TregexParser(InputStream stream) {
        this(stream, null);
    }

    public TregexParser(InputStream stream, String encoding) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new TregexParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(InputStream stream) {
        TregexParser.ReInit(stream, null);
    }

    public static void ReInit(InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        TregexParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    public TregexParser(Reader stream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new TregexParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        TregexParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    public TregexParser(TregexParserTokenManager tm) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    public void ReInit(TregexParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 22; ++i) {
            TregexParser.jj_la1[i] = -1;
        }
    }

    private static Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = oldToken.next != null ? TregexParser.token.next : (TregexParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (TregexParser.token.kind == kind) {
            ++jj_gen;
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw TregexParser.generateParseException();
    }

    public static final Token getNextToken() {
        token = TregexParser.token.next != null ? TregexParser.token.next : (TregexParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = token_source.getNextToken());
        }
        return t;
    }

    private static int jj_ntk() {
        jj_nt = TregexParser.token.next;
        if (jj_nt == null) {
            TregexParser.token.next = token_source.getNextToken();
            jj_ntk = TregexParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = TregexParser.jj_nt.kind;
        return jj_ntk;
    }

    public static ParseException generateParseException() {
        int i;
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[25];
        if (jj_kind >= 0) {
            la1tokens[TregexParser.jj_kind] = true;
            jj_kind = -1;
        }
        for (i = 0; i < 22; ++i) {
            if (jj_la1[i] != jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 25; ++i) {
            if (!la1tokens[i]) continue;
            jj_expentry = new int[1];
            TregexParser.jj_expentry[0] = i;
            jj_expentries.add(jj_expentry);
        }
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i2 = 0; i2 < jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])jj_expentries.get(i2);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    static {
        jj_la1 = new int[22];
        TregexParser.jj_la1_init_0();
        jj_expentries = new ArrayList();
        jj_kind = -1;
    }
}

