/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;

public class FragDiscardingPennTreeReader
extends PennTreeReader {
    private static PrintWriter pw;

    public FragDiscardingPennTreeReader(Reader in, TreeFactory tf, TreeNormalizer tn, Tokenizer tk) {
        super(in, tf, tn, tk);
    }

    @Override
    public Tree readTree() throws IOException {
        Tree tr = super.readTree();
        while (tr != null && tr.firstChild().value().equals("FRAG")) {
            if (pw != null) {
                pw.println("Discarding Tree:");
                tr.pennPrint(pw);
            }
            tr = super.readTree();
        }
        return tr;
    }
}

