/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.pennchinese.CTBTreeReaderFactory;
import edu.stanford.nlp.trees.international.pennchinese.ChineseHeadFinder;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;

public class ChineseTreebankLanguagePack
extends AbstractTreebankLanguagePack {
    private static final long serialVersionUID = 5757403475523638802L;
    private static TokenizerFactory<? extends HasWord> tf;
    public static final String ENCODING = "GB18030";
    private static final char[] annotationIntroducingChars;
    private static final String[] startSymbols;
    private static final String[] tags;
    private static final String[] comma;
    private static final String[] endSentence;
    private static final String[] douHao;
    private static final String[] quoteMark;
    private static final String[] parenthesis;
    private static final String[] colon;
    private static final String[] dash;
    private static final String[] other;
    private static String[] leftQuoteMark;
    private static String[] rightQuoteMark;
    private static String[] leftParenthesis;
    private static String[] rightParenthesis;
    private static final String[] punctWords;

    public static void setTokenizerFactory(TokenizerFactory<? extends HasWord> tf) {
        ChineseTreebankLanguagePack.tf = tf;
    }

    @Override
    public TokenizerFactory<? extends HasWord> getTokenizerFactory() {
        if (tf != null) {
            return tf;
        }
        return super.getTokenizerFactory();
    }

    @Override
    public String getEncoding() {
        return ENCODING;
    }

    @Override
    public boolean isPunctuationTag(String str) {
        return str.equals("PU");
    }

    @Override
    public boolean isPunctuationWord(String str) {
        return ChineseTreebankLanguagePack.chineseCommaAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseEndSentenceAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseDouHaoAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseQuoteMarkAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseParenthesisAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseColonAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseDashAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseOtherAcceptFilter().accept(str);
    }

    @Override
    public boolean isSentenceFinalPunctuationTag(String str) {
        return ChineseTreebankLanguagePack.chineseEndSentenceAcceptFilter().accept(str);
    }

    @Override
    public String[] punctuationTags() {
        return tags;
    }

    @Override
    public String[] punctuationWords() {
        return punctWords;
    }

    @Override
    public String[] sentenceFinalPunctuationTags() {
        return tags;
    }

    @Override
    public String[] sentenceFinalPunctuationWords() {
        return endSentence;
    }

    @Override
    public boolean isEvalBIgnoredPunctuationTag(String str) {
        return Filters.collectionAcceptFilter(tags).accept(str);
    }

    @Override
    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    @Override
    public String[] startSymbols() {
        return startSymbols;
    }

    public static Filter<String> chineseCommaAcceptFilter() {
        return Filters.collectionAcceptFilter(comma);
    }

    public static Filter<String> chineseEndSentenceAcceptFilter() {
        return Filters.collectionAcceptFilter(endSentence);
    }

    public static Filter<String> chineseDouHaoAcceptFilter() {
        return Filters.collectionAcceptFilter(douHao);
    }

    public static Filter<String> chineseQuoteMarkAcceptFilter() {
        return Filters.collectionAcceptFilter(quoteMark);
    }

    public static Filter<String> chineseParenthesisAcceptFilter() {
        return Filters.collectionAcceptFilter(parenthesis);
    }

    public static Filter<String> chineseColonAcceptFilter() {
        return Filters.collectionAcceptFilter(colon);
    }

    public static Filter<String> chineseDashAcceptFilter() {
        return Filters.collectionAcceptFilter(dash);
    }

    public static Filter<String> chineseOtherAcceptFilter() {
        return Filters.collectionAcceptFilter(other);
    }

    public static Filter<String> chineseLeftParenthesisAcceptFilter() {
        return Filters.collectionAcceptFilter(leftParenthesis);
    }

    public static Filter<String> chineseRightParenthesisAcceptFilter() {
        return Filters.collectionAcceptFilter(rightParenthesis);
    }

    public static Filter<String> chineseLeftQuoteMarkAcceptFilter() {
        return Filters.collectionAcceptFilter(leftQuoteMark);
    }

    public static Filter<String> chineseRightQuoteMarkAcceptFilter() {
        return Filters.collectionAcceptFilter(rightQuoteMark);
    }

    @Override
    public String treebankFileExtension() {
        return "fid";
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory() {
        return new GrammaticalStructureFactory("edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalStructure");
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory(Filter<String> puncFilt) {
        return new GrammaticalStructureFactory("edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalStructure", puncFilt);
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        BobChrisTreeNormalizer tn = new BobChrisTreeNormalizer();
        return new CTBTreeReaderFactory(tn);
    }

    @Override
    public HeadFinder headFinder() {
        return new ChineseHeadFinder(this);
    }

    static {
        annotationIntroducingChars = new char[]{'-', '=', '|', '#', '^', '~'};
        startSymbols = new String[]{"ROOT"};
        tags = new String[]{"PU"};
        comma = new String[]{",", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd"};
        endSentence = new String[]{"\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "?", "!", "."};
        douHao = new String[]{"\ufffd\ufffd\ufffd"};
        quoteMark = new String[]{"\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "`", "\ufffd\ufffd\ufffd"};
        parenthesis = new String[]{"\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "-LRB-", "-RRB-", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd"};
        colon = new String[]{"\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", ":"};
        dash = new String[]{"\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", "-", "----", "~", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd"};
        other = new String[]{"\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "/", "//", "*"};
        leftQuoteMark = new String[]{"\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "`"};
        rightQuoteMark = new String[]{"\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd"};
        leftParenthesis = new String[]{"\ufffd\ufffd\ufffd", "-LRB-", "\ufffd\ufffd\ufffd"};
        rightParenthesis = new String[]{"\ufffd\ufffd\ufffd", "-RRB-", "\ufffd\ufffd\ufffd"};
        int n = tags.length + comma.length + endSentence.length + douHao.length + quoteMark.length + parenthesis.length + colon.length + dash.length + other.length;
        punctWords = new String[n];
        int m = 0;
        System.arraycopy(tags, 0, punctWords, m, tags.length);
        System.arraycopy(comma, 0, punctWords, m += tags.length, comma.length);
        System.arraycopy(endSentence, 0, punctWords, m += comma.length, endSentence.length);
        System.arraycopy(douHao, 0, punctWords, m += endSentence.length, douHao.length);
        System.arraycopy(quoteMark, 0, punctWords, m += douHao.length, quoteMark.length);
        System.arraycopy(parenthesis, 0, punctWords, m += quoteMark.length, parenthesis.length);
        System.arraycopy(colon, 0, punctWords, m += parenthesis.length, colon.length);
        System.arraycopy(dash, 0, punctWords, m += colon.length, dash.length);
        System.arraycopy(other, 0, punctWords, m += dash.length, other.length);
    }
}

