/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.trees.GrammaticalRelation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ChineseGrammaticalRelations {
    public static final GrammaticalRelation PREDICATE = new GrammaticalRelation("pred", "predicate", PredicateGRAnnotation.class, GrammaticalRelation.DEPENDENT, "IP", new String[]{" IP=target !> IP"});
    public static final GrammaticalRelation ARGUMENT = new GrammaticalRelation("arg", "argument", ArgumentGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CONJUNCT = new GrammaticalRelation("conj", "conjunct", PreconjunctGRAnnotation.class, GrammaticalRelation.DEPENDENT, "VP|NP|ADJP|PP|ADVP|UCP", new String[]{"NP|ADJP|PP|ADVP|UCP < (!PU=target $+ CC)", "VP < (!PU=target !$- VP $+ CC)", "VP|NP|ADJP|PP|ADVP|UCP < ( __=target $+ PU $+ CC)", "VP   < ( /^V/=target  $+ ((PU < \ufffd\ufffd\ufffd) $+ /^V/))", "NP   < ( /^N/=target  $+ ((PU < \ufffd\ufffd\ufffd) $+ /^N/))", "ADJP < ( JJ|ADJP=target  $+ ((PU < \ufffd\ufffd\ufffd) $+ JJ|ADJP))", "PP   < ( /^P/=target  $+ ((PU < \ufffd\ufffd\ufffd) $+ /^P/))", "ADVP < ( /^AD/=target $+ ((PU < \ufffd\ufffd\ufffd) $+ /^AD/))", "UCP  < ( __=target    $+ (PU < \ufffd\ufffd\ufffd) )", "PP < (PP $+ PP=target )", "NP <( NP=target $+ ((PU < \ufffd\ufffd\ufffd) $+ NP) )", "NP <( NN|NR|NT|PN=target $+ ((PU < \ufffd\ufffd\ufffd|\ufffd\ufffd\ufffd) $+ NN|NR|NT|PN) )", "VP < (CC $+ VV=target)"});
    public static final GrammaticalRelation AUX_MODIFIER = new GrammaticalRelation("cop", "copula", AuxModifierGRAnnotation.class, GrammaticalRelation.DEPENDENT, "VP", new String[]{" VP < VC=target"});
    public static final GrammaticalRelation COORDINATION = new GrammaticalRelation("cc", "coordination", CoordinationGRAnnotation.class, GrammaticalRelation.DEPENDENT, "VP|NP|ADJP|PP|ADVP|UCP|IP|QP", new String[]{"VP|NP|ADJP|PP|ADVP|UCP|IP|QP < (CC=target)"});
    public static final GrammaticalRelation PUNCTUATION = new GrammaticalRelation("punct", "punctuation", PunctuationGRAnnotation.class, GrammaticalRelation.DEPENDENT, "VP|NP|PP|IP|CP|UCP", new String[]{"__ < PU=target"});
    public static final GrammaticalRelation SUBJECT = new GrammaticalRelation("subj", "subject", SubjectGRAnnotation.class, ARGUMENT);
    public static final GrammaticalRelation NOMINAL_SUBJECT = new GrammaticalRelation("nsubj", "nominal subject", NominalSubjectGRAnnotation.class, SUBJECT, "IP|VP", new String[]{" IP <( ( NP|QP=target!< NT ) $++ ( /^VP|VCD|IP/  !< VE !<VC !<SB !<LB  ))", " NP !$+ VP < ( (  NP|DP|QP=target !< NT ) $+ ( /^VP|VCD/ !<VE !< VC !<SB !<LB))"});
    public static final GrammaticalRelation TOP_SUBJECT = new GrammaticalRelation("top", "topic", TopicGRAnnotation.class, SUBJECT, "IP|VP", new String[]{"IP|VP < ( NP|DP=target $+ ( VP < VC|VE ) )", "IP < (IP=target $+ ( VP < VC|VE))"});
    public static final GrammaticalRelation NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation("npsubj", "nominal passive subject", NominalPassiveSubjectGRAnnotation.class, NOMINAL_SUBJECT, "IP", new String[]{"IP < (NP=target $+ (VP|IP < SB|LB))"});
    public static final GrammaticalRelation CLAUSAL_SUBJECT = new GrammaticalRelation("csubj", "clausal subject", ClausalSubjectGRAnnotation.class, SUBJECT, "IP", new String[0]);
    public static final GrammaticalRelation COMPLEMENT = new GrammaticalRelation("comp", "complement", ComplementGRAnnotation.class, ARGUMENT);
    public static final GrammaticalRelation OBJECT = new GrammaticalRelation("obj", "object", ObjectGRAnnotation.class, COMPLEMENT);
    public static final GrammaticalRelation DIRECT_OBJECT = new GrammaticalRelation("dobj", "direct object", DirectObjectGRAnnotation.class, OBJECT, "CP|VP", new String[]{"VP < ( /^V*/ $+ NP $+ NP|DP=target ) !< VC ", " VP < ( /^V*/ $+ NP|DP=target ! $+ NP|DP) !< VC ", "CP < (IP $++ NP=target ) !<< VC"});
    public static final GrammaticalRelation INDIRECT_OBJECT = new GrammaticalRelation("iobj", "indirect object", IndirectObjectGRAnnotation.class, OBJECT, "VP", new String[]{" CP !> VP < ( VV $+ ( NP|DP|QP|CLP=target . NP|DP ) )"});
    public static final GrammaticalRelation RANGE = new GrammaticalRelation("range", "range", RangeGRAnnotation.class, OBJECT, "VP", new String[]{" VP < ( NP|DP|QP $+ NP|DP|QP=target)", "VP < ( VV $+ QP=target )"});
    public static final GrammaticalRelation PREPOSITIONAL_OBJECT = new GrammaticalRelation("pobj", "prepositional object", PrepositionalObjectGRAnnotation.class, OBJECT, "^PP", new String[]{"/^PP/ < /^P/ < /^NP|^DP|QP/=target"});
    public static final GrammaticalRelation TIME_POSTPOSITION = new GrammaticalRelation("lobj", "localizer object", TimePostpositionGRAnnotation.class, OBJECT, "LCP", new String[]{"LCP < ( NP|QP|DP=target $+ LC)"});
    public static final GrammaticalRelation ATTRIBUTIVE = new GrammaticalRelation("attr", "attributive", AttributiveGRAnnotation.class, COMPLEMENT, "VP", new String[]{"VP < /^VC$/ < NP|QP=target"});
    public static final GrammaticalRelation CLAUSAL_COMPLEMENT = new GrammaticalRelation("ccomp", "clausal complement", ClausalComplementGRAnnotation.class, COMPLEMENT, "VP|ADJP|IP", new String[]{"VP|ADJP|IP < IP|VP|VRD|VCD=target"});
    public static final GrammaticalRelation XCLAUSAL_COMPLEMENT = new GrammaticalRelation("xcomp", "xclausal complement", XClausalComplementGRAnnotation.class, COMPLEMENT, "VP|ADJP", new String[]{"VP !> (/^VP/ < /^VC$/ ) < (IP=target < (VP < P))", "ADJP < (IP=target <, (VP <, P))", "VP < (IP=target < (NP $+ NP|ADJP))", "VP < (/^VC/ $+ (VP=target < VC < NP))"});
    public static final GrammaticalRelation COMPLEMENTIZER = new GrammaticalRelation("cpm", "complementizer", ComplementizerGRAnnotation.class, COMPLEMENT, "^CP", new String[]{"/^CP/ < (__  $++ DEC=target)"});
    public static final GrammaticalRelation ADJECTIVAL_COMPLEMENT = new GrammaticalRelation("acomp", "adjectival complement", AdjectivalComplementGRAnnotation.class, COMPLEMENT, "VP", new String[]{"VP < (ADJP=target !$-- NP)"});
    public static final GrammaticalRelation TIMEM = new GrammaticalRelation("tcomp", "temporal complement", TemporalGRAnnotation.class, COMPLEMENT, "VP|IP", new String[]{"VP|IP < (NP=target < NT !.. /^VC$/ $++  VP)"});
    public static final GrammaticalRelation LC_COMPLEMENT = new GrammaticalRelation("lccomp", "localizer complement", LocalizerComplementGRAnnotation.class, COMPLEMENT, "VP|IP", new String[]{"VP|IP < LCP=target "});
    public static final GrammaticalRelation RES_VERB = new GrammaticalRelation("rcomp", "result verb", ResultativeComplementGRAnnotation.class, COMPLEMENT, "VRD", new String[]{"VRD < ( /V*/ $+ /V*/=target )"});
    public static final GrammaticalRelation MODIFIER = new GrammaticalRelation("mod", "modifier", ModifierGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation VERB_COMPOUND = new GrammaticalRelation("comod", "coordinated verb compound", VerbCompoundGRAnnotation.class, MODIFIER, "VCD", new String[]{"VCD < ( VV|VA $+  VV|VA=target)"});
    public static final GrammaticalRelation MODAL_VERB = new GrammaticalRelation("mmod", "modal verb", ModalGRAnnotation.class, MODIFIER, "VP", new String[]{"VP < ( VV=target $+ VP|VRD )"});
    public static final GrammaticalRelation AUX_PASSIVE_MODIFIER = new GrammaticalRelation("pass", "passive", AuxPassiveGRAnnotation.class, MODIFIER, "VP", new String[]{"VP < SB|LB=target"});
    public static final GrammaticalRelation BA = new GrammaticalRelation("ba", "ba", BaGRAnnotation.class, GrammaticalRelation.DEPENDENT, "VP|IP", new String[]{"VP|IP < BA=target "});
    public static final GrammaticalRelation TEMPORAL_MODIFIER = new GrammaticalRelation("tmod", "temporal modifier", TemporalModifierGRAnnotation.class, MODIFIER, "VP|IP|ADJP", new String[]{" VC|VE ! >> VP|ADJP < NP=target < NT", "VC|VE !>>IP <( NP=target < NT $++ VP !< VC|VE )"});
    public static final GrammaticalRelation TIME = new GrammaticalRelation("tclaus", "temporal clause", TemporalClauseGRAnnotation.class, MODIFIER, "LCP", new String[]{"/LCP/ < ( IP=target $+ LC )"});
    public static final GrammaticalRelation RELATIVE_CLAUSE_MODIFIER = new GrammaticalRelation("rcmod", "relative clause modifier", RelativeClauseModifierGRAnnotation.class, MODIFIER, "NP", new String[]{"NP  $++ (CP=target ) > NP ", "NP  $++ (CP=target <: IP) > NP  ", "NP  $++ (CP=target)", " NP  << ( CP=target $++ NP  )"});
    public static final GrammaticalRelation NUMERIC_MODIFIER = new GrammaticalRelation("numod", "numeric modifier", NumericModifierGRAnnotation.class, MODIFIER, "QP|NP", new String[]{"QP < CD=target", "NP < ( QP=target !<< CLP )"});
    public static final GrammaticalRelation ODNUMERIC_MODIFIER = new GrammaticalRelation("ordmod", "numeric modifier", OrdNumberGRAnnotation.class, MODIFIER, "NP|QP", new String[]{"NP < QP=target < ( OD !$+ CLP )", "QP < (OD=target $+ CLP)"});
    public static final GrammaticalRelation NUMBER_MODIFIER = new GrammaticalRelation("clf", "classifier modifier", NumberModifierGRAnnotation.class, MODIFIER, "^NP|DP|QP", new String[]{"NP|QP < ( QP  =target << M $++ NN|NP|QP)", "DP < ( DT $+ CLP=target )"});
    public static final GrammaticalRelation NOUN_COMPOUND_MODIFIER = new GrammaticalRelation("nmod", "nn modifier", NounCompoundModifierGRAnnotation.class, MODIFIER, "^NP", new String[]{"NP < (NN|NR|NT=target $+ NN|NR|NT)", "NP < (NN|NR|NT $+ FW=target)", " NP <  (NP=target !$+ PU|CC $++ NP|PRN )"});
    public static final GrammaticalRelation ADJECTIVAL_MODIFIER = new GrammaticalRelation("amod", "adjectival modifier", AdjectivalModifierGRAnnotation.class, MODIFIER, "NP|CLP|QP", new String[]{"NP|CLP|QP < (ADJP=target $++ NP|CLP|QP ) "});
    public static final GrammaticalRelation ADVERBIAL_MODIFIER = new GrammaticalRelation("advmod", "adverbial modifier", AdverbialModifierGRAnnotation.class, MODIFIER, "VP|ADJP|IP|CP|PP|NP|QP", new String[]{"VP|ADJP|IP|CP|PP|NP < ADVP=target", "VP|ADJP < AD|CS=target", "QP < (ADVP=target $+ QP)", "QP < ( QP $+ ADVP=target)"});
    public static final GrammaticalRelation IP_MODIFIER = new GrammaticalRelation("vmod", "participle modifier", VerbModifierGRAnnotation.class, MODIFIER, "NP", new String[]{"NP < IP=target "});
    public static final GrammaticalRelation PRN_MODIFIER = new GrammaticalRelation("prnmod", "prn odifier", ParentheticalGRAnnotation.class, MODIFIER, "NP", new String[]{"NP < PRN=target "});
    public static final GrammaticalRelation NEGATION_MODIFIER = new GrammaticalRelation("neg", "negation modifier", NegationModifierGRAnnotation.class, ADVERBIAL_MODIFIER, "VP|ADJP|IP", new String[]{"VP|ADJP|IP < (AD=target < /\\u4e0d/)", "VP|ADJP|IP < (ADVP=target < (AD < /\\u4e0d/))"});
    public static final GrammaticalRelation DETERMINER = new GrammaticalRelation("det", "determiner", DeterminerGRAnnotation.class, MODIFIER, "^NP|DP", new String[]{"/^NP/ < (DP=target $++ NP )", "DP < DT < QP=target"});
    public static final GrammaticalRelation POSSESSION_MODIFIER = new GrammaticalRelation("poss", "possession modifier", PossessionModifierGRAnnotation.class, MODIFIER, "NP", new String[]{"NP < ( PN=target $+ DEC $+  NP )"});
    public static final GrammaticalRelation POSSESSIVE_MODIFIER = new GrammaticalRelation("possm", "possessive marker", PossessiveModifierGRAnnotation.class, MODIFIER, "NP", new String[]{"NP < ( PN $+ DEC=target ) "});
    public static final GrammaticalRelation DVP_MODIFIER = new GrammaticalRelation("dvpm", "dvp marker", DvpMarkerGRAnnotation.class, MODIFIER, "DVP", new String[]{" DVP < (__ $+ DEV=target ) "});
    public static final GrammaticalRelation DVPM_MODIFIER = new GrammaticalRelation("dvpmod", "dvp modifier", DvpModifierGRAnnotation.class, MODIFIER, "VP", new String[]{" VP < ( DVP=target $+ VP) "});
    public static final GrammaticalRelation ASSOCIATIVE_MODIFIER = new GrammaticalRelation("assm", "associative marker", AssociativeMarkerGRAnnotation.class, MODIFIER, "DNP", new String[]{" DNP < ( __ $+ DEG=target ) "});
    public static final GrammaticalRelation ASSOCIATIVEM_MODIFIER = new GrammaticalRelation("assmod", "associative modifier", AssociativeModifierGRAnnotation.class, MODIFIER, "NP|QP", new String[]{"NP|QP < ( DNP =target $++ NP|QP ) "});
    public static final GrammaticalRelation PREPOSITIONAL_MODIFIER = new GrammaticalRelation("prep", "prepositional modifier", PrepositionalModifierGRAnnotation.class, MODIFIER, "^NP|VP|IP", new String[]{"/^NP/ < /^PP/=target", "VP < /^PP/=target", "IP < /^PP/=target "});
    public static final GrammaticalRelation CL_MODIFIER = new GrammaticalRelation("clmpd", "clause modifier", ClauseModifierGRAnnotation.class, MODIFIER, "^PP|IP", new String[]{"PP < (P $+ IP|VP =target)", "IP < (CP=target $++ VP)"});
    public static final GrammaticalRelation PREPOSITIONAL_LOC_MODIFIER = new GrammaticalRelation("plmod", "prepositional localizer modifier", PrepositionalLocalizerModifierGRAnnotation.class, MODIFIER, "PP", new String[]{"PP < ( P $++ LCP=target )"});
    public static final GrammaticalRelation PREDICATE_ASPECT = new GrammaticalRelation("asp", "aspect", AspectMarkerGRAnnotation.class, MODIFIER, "VP", new String[]{"VP < ( /^V*/ $+ AS=target)"});
    public static final GrammaticalRelation PART_VERB = new GrammaticalRelation("partmod", "particle verb", ParticipialModifierGRAnnotation.class, MODIFIER, "VP|IP", new String[]{"VP|IP < ( MSP=target )"});
    public static final GrammaticalRelation ETC = new GrammaticalRelation("etc", "ETC", EtcGRAnnotation.class, MODIFIER, "^NP", new String[]{"/^NP/ < (NN|NR . ETC=target)"});
    public static final GrammaticalRelation SEMANTIC_DEPENDENT = new GrammaticalRelation("sdep", "semantic dependent", SemanticDependentGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CONTROLLED_SUBJECT = new GrammaticalRelation("xsubj", "controlled subject", ControllingSubjectGRAnnotation.class, SEMANTIC_DEPENDENT, "VP", new String[]{"VP !< NP < VP > (IP !$- NP !< NP !>> (VP < VC ) >+(VP) (VP $-- NP=target))"});
    private static final GrammaticalRelation[] values = new GrammaticalRelation[]{ADJECTIVAL_COMPLEMENT, ADJECTIVAL_MODIFIER, ADVERBIAL_MODIFIER, ARGUMENT, ASSOCIATIVEM_MODIFIER, ASSOCIATIVE_MODIFIER, ATTRIBUTIVE, AUX_MODIFIER, AUX_PASSIVE_MODIFIER, BA, CLAUSAL_COMPLEMENT, CLAUSAL_SUBJECT, CL_MODIFIER, COMPLEMENT, COMPLEMENTIZER, CONJUNCT, CONTROLLED_SUBJECT, COORDINATION, GrammaticalRelation.DEPENDENT, DETERMINER, DIRECT_OBJECT, DVPM_MODIFIER, DVP_MODIFIER, ETC, GrammaticalRelation.GOVERNOR, INDIRECT_OBJECT, IP_MODIFIER, LC_COMPLEMENT, MODAL_VERB, MODIFIER, NEGATION_MODIFIER, NOMINAL_PASSIVE_SUBJECT, NOMINAL_SUBJECT, NOUN_COMPOUND_MODIFIER, NUMBER_MODIFIER, NUMERIC_MODIFIER, OBJECT, ODNUMERIC_MODIFIER, PART_VERB, POSSESSION_MODIFIER, POSSESSIVE_MODIFIER, PREDICATE, PREDICATE_ASPECT, PREPOSITIONAL_LOC_MODIFIER, PREPOSITIONAL_MODIFIER, PREPOSITIONAL_OBJECT, PRN_MODIFIER, PUNCTUATION, RANGE, RELATIVE_CLAUSE_MODIFIER, RES_VERB, SEMANTIC_DEPENDENT, SUBJECT, TEMPORAL_MODIFIER, TIME, TIMEM, TIME_POSTPOSITION, TOP_SUBJECT, VERB_COMPOUND, XCLAUSAL_COMPLEMENT};

    public static List<GrammaticalRelation> values() {
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    public static GrammaticalRelation valueOf(String s) {
        return GrammaticalRelation.valueOf(s, ChineseGrammaticalRelations.values());
    }

    public static class ControllingSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class SemanticDependentGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class EtcGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ParticipialModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AspectMarkerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PrepositionalLocalizerModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ClauseModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PrepositionalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AssociativeModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AssociativeMarkerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class DvpModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class DvpMarkerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PossessiveModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PossessionModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class DeterminerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NegationModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ParentheticalGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class VerbModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AdverbialModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AdjectivalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NounCompoundModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NumberModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class OrdNumberGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NumericModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class RelativeClauseModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class TemporalClauseGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class TemporalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class BaGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AuxPassiveGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ModalGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class VerbCompoundGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ResultativeComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class LocalizerComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class TemporalGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AdjectivalComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ComplementizerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class XClausalComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ClausalComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AttributiveGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class TimePostpositionGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PrepositionalObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class RangeGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class IndirectObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class DirectObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ClausalSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NominalPassiveSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class TopicGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NominalSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class SubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PunctuationGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class CoordinationGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AuxModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PreconjunctGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ArgumentGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PredicateGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }
}

