/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.io.EncodingPrintWriter;
import edu.stanford.nlp.process.SerializableFunction;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Properties;

public class Buckwalter
implements SerializableFunction<String, String> {
    boolean outputUnicodeValues = false;
    private char[] arabicChars = new char[]{'\u0621', '\u0622', '\u0623', '\u0624', '\u0625', '\u0626', '\u0627', '\u0628', '\u0629', '\u062a', '\u062b', '\u062c', '\u062d', '\u062e', '\u062f', '\u0630', '\u0631', '\u0632', '\u0633', '\u0634', '\u0635', '\u0636', '\u0637', '\u0638', '\u0639', '\u063a', '\u0640', '\u0641', '\u0642', '\u0643', '\u0644', '\u0645', '\u0646', '\u0647', '\u0648', '\u0649', '\u064a', '\u064b', '\u064c', '\u064d', '\u064e', '\u064f', '\u0650', '\u0651', '\u0652', '\u0670', '\u0671', '\u067e', '\u0686', '\u0698', '\u06a4', '\u06af', '\u0625', '\u0623', '\u0624', '\u060c', '\u061b', '\u061f', '\u066a', '\u066b', '\u066c', '\u066d', '\u06d4', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0660', '\u0661', '\u0662', '\u0663', '\u0664', '\u0665', '\u0666', '\u0667', '\u0668', '\u0669', '\u00ab', '\u00bb'};
    private char[] buckChars = new char[]{'\'', '|', '>', '&', '<', '}', 'A', 'b', 'p', 't', 'v', 'j', 'H', 'x', 'd', '*', 'r', 'z', 's', '$', 'S', 'D', 'T', 'Z', 'E', 'g', '_', 'f', 'q', 'k', 'l', 'm', 'n', 'h', 'w', 'Y', 'y', 'F', 'N', 'K', 'a', 'u', 'i', '~', 'o', '`', '{', 'P', 'J', 'R', 'V', 'G', 'I', 'O', 'W', ',', ';', '?', '%', '.', ',', '*', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\"', '\"'};
    private boolean u2b;
    private HashMap<Character, Character> a2b;
    private HashMap<Character, Character> b2a;
    private ClassicCounter<String> unmappable;
    private static final boolean DEBUG = true;
    private static final boolean PASS_ASCII_IN_UNICODE = true;
    private static final long serialVersionUID = 1L;

    @Override
    public String apply(String in) {
        return this.convert(in, this.u2b);
    }

    private String convert(String in, boolean unicodeToBuckwalter) {
        StringBuilder res = new StringBuilder(in.length());
        int sz = in.length();
        for (int i = 0; i < sz; ++i) {
            Character inCh = Character.valueOf(in.charAt(i));
            Character outCh = unicodeToBuckwalter ? (inCh.charValue() < '\u007f' ? inCh : this.a2b.get(inCh)) : this.b2a.get(inCh);
            if (outCh == null) {
                String key = inCh + "[U+" + StringUtils.padLeft(Integer.toString(inCh.charValue(), 16).toUpperCase(), 4, '0') + "]";
                this.unmappable.incrementCount(key);
                res.append(inCh);
                continue;
            }
            if (!this.outputUnicodeValues) {
                res.append(outCh);
                continue;
            }
            res.append("\\u" + StringUtils.padLeft(Integer.toString(inCh.charValue(), 16).toUpperCase(), 4, '0'));
        }
        return res.toString();
    }

    public String buckwalterToUnicode(String in) {
        return this.convert(in, false);
    }

    public String unicodeToBuckwalter(String in) {
        return this.convert(in, true);
    }

    public Buckwalter() {
        this(false);
    }

    public Buckwalter(boolean unicodeToBuckwalter) {
        if (this.arabicChars.length != this.buckChars.length) {
            throw new RuntimeException("Buckwalter: Bad char arrays");
        }
        this.a2b = new HashMap(this.arabicChars.length);
        this.b2a = new HashMap(this.buckChars.length);
        for (int i = 0; i < this.arabicChars.length; ++i) {
            Character ca = Character.valueOf(this.arabicChars[i]);
            Character cb = Character.valueOf(this.buckChars[i]);
            this.a2b.put(ca, cb);
            this.b2a.put(cb, ca);
        }
        this.unmappable = new ClassicCounter();
        this.u2b = unicodeToBuckwalter;
    }

    public static void main(String[] args) throws IOException {
        int j;
        if (args.length < 1 || !args[0].equals("-a2b") && !args[0].equals("-b2a")) {
            System.err.println("usage: java Buckwalter [-a2b|-b2a] words+ OR, as a filter, just [-a2b|-b2a]");
            return;
        }
        Properties p = StringUtils.argsToProperties(args);
        Buckwalter b = new Buckwalter(args[0].equals("-a2b"));
        if (p.containsKey("outputUnicodeValues")) {
            b.outputUnicodeValues = true;
        }
        int n = j = p.containsKey("outputUnicodeValues") ? 2 : 1;
        if (j < args.length) {
            while (j < args.length) {
                EncodingPrintWriter.out.println(args[j] + " -> " + b.apply(args[j]), "utf-8");
                ++j;
            }
        } else {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in, "utf-8"));
            while ((line = br.readLine()) != null) {
                EncodingPrintWriter.out.println(b.apply(line), "utf-8");
            }
        }
        if (!b.unmappable.keySet().isEmpty()) {
            EncodingPrintWriter.err.println("Characters that could not be converted [passed through!]:", "utf-8");
            EncodingPrintWriter.err.println(b.unmappable.toString(), "utf-8");
        } else {
            EncodingPrintWriter.err.println("All characters successfully converted!", "utf-8");
        }
    }
}

