/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.international.arabic.ArabicTreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;

public class ArabicTreeNormalizer
extends BobChrisTreeNormalizer {
    private boolean retainNPTmp;
    private boolean markPRDverb;
    private boolean collapse3LetterPrepositionVariants;
    private boolean normalizeConj = false;
    private boolean changeNoLabels = false;
    private Pattern prdPattern = Pattern.compile("^[A-Z]+-PRD");
    private TregexPattern prdVerbPattern;
    private static final boolean escape = false;
    private static final Collection<String> escapeCharacters = Arrays.asList("/", "*");
    private boolean warnedPrepositions = false;
    private static final Pattern wrongConjPattern = Pattern.compile("NNP|NO_FUNC|NOFUNC|IN");

    public ArabicTreeNormalizer(boolean retainNPTmp, boolean markPRDverb, boolean changeNoLabels, boolean collapsePreps) {
        super(new ArabicTreebankLanguagePack());
        this.retainNPTmp = retainNPTmp;
        this.markPRDverb = markPRDverb;
        this.changeNoLabels = changeNoLabels;
        this.collapse3LetterPrepositionVariants = collapsePreps;
        try {
            this.prdVerbPattern = TregexPattern.compile("/^V[^P]/ > VP $ /-PRD$/=prd");
        }
        catch (ParseException e) {
            System.out.println(e);
            throw new RuntimeException();
        }
        this.emptyFilter = new ArabicEmptyFilter();
    }

    public ArabicTreeNormalizer(boolean retainNPTmp, boolean markPRDverb, boolean changeNoLabels) {
        this(retainNPTmp, markPRDverb, changeNoLabels, false);
    }

    public ArabicTreeNormalizer(boolean retainNPTmp, boolean markPRDverb) {
        this(retainNPTmp, markPRDverb, false);
    }

    public ArabicTreeNormalizer(boolean retainNPTmp) {
        this(retainNPTmp, false);
    }

    public ArabicTreeNormalizer() {
        this(false);
    }

    @Override
    public String normalizeNonterminal(String category) {
        if (this.changeNoLabels) {
            return category;
        }
        if (this.retainNPTmp && category != null && category.startsWith("NP-TMP")) {
            return "NP-TMP";
        }
        if (this.markPRDverb && category != null && this.prdPattern.matcher(category).matches()) {
            return category;
        }
        return super.normalizeNonterminal(category);
    }

    @Override
    public String normalizeTerminal(String leaf) {
        if (this.changeNoLabels) {
            return leaf;
        }
        return super.normalizeTerminal(leaf);
    }

    private void warnIfFirstTimePrep() {
        if (!this.warnedPrepositions) {
            this.warnedPrepositions = true;
            System.err.println("ATBNormalizer: mapping preposition forms: Ely to ElY; <ly, AlY, Aly to <lY; ldy to ldY; Hty to HtY");
        }
    }

    private void do3LetterPrepositionVariants(Tree t) {
        if (t.value().equals("Ely")) {
            this.warnIfFirstTimePrep();
            t.label().setValue("ElY");
        } else if (t.value().equals("<ly") || t.firstChild().value().equals("Aly") || t.firstChild().value().equals("AlY")) {
            this.warnIfFirstTimePrep();
            t.label().setValue("<lY");
        } else if (t.value().equals("ldy")) {
            this.warnIfFirstTimePrep();
            t.label().setValue("ldY");
        } else if (t.value().equals("Hty")) {
            this.warnIfFirstTimePrep();
            t.label().setValue("HtY");
        } else if (t.value().equals("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd")) {
            this.warnIfFirstTimePrep();
            t.label().setValue("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        } else if (t.value().equals("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd") || t.firstChild().value().equals("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd") || t.firstChild().value().equals("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd")) {
            this.warnIfFirstTimePrep();
            t.label().setValue("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        } else if (t.value().equals("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd")) {
            this.warnIfFirstTimePrep();
            t.label().setValue("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        } else if (t.value().equals("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd")) {
            this.warnIfFirstTimePrep();
            t.label().setValue("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
    }

    @Override
    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        tree = tree.prune(this.emptyFilter, tf).spliceOut(this.aOverAFilter, tf);
        for (Tree t : tree) {
            if (t.isPreTerminal()) {
                if (this.collapse3LetterPrepositionVariants && (t.value().equals("PREP") || t.value().equals("IN"))) {
                    this.do3LetterPrepositionVariants(t.firstChild());
                }
                if (t.label().value() == null || t.label().value().equals("")) {
                    System.err.println("ATBNormalizer ERROR: missing tag: " + t);
                }
                if (t.label().value().equals("NO_FUNC") && (t.firstChild().label().value().equals(".") || t.firstChild().label().value().equals("\""))) {
                    System.err.println("ArabicTreeNormalizer: changing NO_FUNC tag to PUNC: " + t);
                    t.label().setValue("PUNC");
                }
            }
            if (t.isPreTerminal() || t.isLeaf()) continue;
            int nk = t.numChildren();
            ArrayList<Tree> newKids = new ArrayList<Tree>(nk);
            for (int j = 0; j < nk; ++j) {
                Tree child = t.getChild(j);
                if (child.isLeaf()) {
                    newKids.add(tf.newTreeNode("DUMMYTAG", Collections.singletonList(child)));
                    continue;
                }
                newKids.add(child);
            }
            t.setChildren(newKids);
        }
        if (this.markPRDverb) {
            TregexMatcher m = this.prdVerbPattern.matcher(tree);
            Tree match = null;
            while (m.find()) {
                if (m.getMatch() == match) continue;
                match = m.getMatch();
                match.label().setValue(match.label().value() + "-PRDverb");
                Tree prd = m.getNode("prd");
                prd.label().setValue(super.normalizeNonterminal(prd.label().value()));
            }
        }
        if (this.normalizeConj && tree.isPreTerminal() && tree.children()[0].label().value().equals("w") && wrongConjPattern.matcher(tree.label().value()).matches()) {
            System.err.print("ATBNormalizer ERROR: bad CC remapped tree " + tree + " to ");
            tree.label().setValue("CC");
            System.err.println(tree);
        }
        if (tree.isPreTerminal()) {
            String val = tree.label().value();
            if (val.equals("CC") || val.equals("PUNC") || val.equals("CONJ")) {
                System.err.println("ATBNormalizer ERROR: bare tagged word: " + tree + " being wrapped in FRAG");
                tree = tf.newTreeNode("FRAG", Collections.singletonList(tree));
            } else {
                System.err.println("ATBNormalizer ERROR: bare tagged word: " + tree + ": fix it!!");
            }
        }
        if (!tree.label().value().equals("ROOT")) {
            tree = tf.newTreeNode("ROOT", Collections.singletonList(tree));
        }
        return tree;
    }

    public static class ArabicEmptyFilter
    implements Filter<Tree> {
        private static final long serialVersionUID = 7417844982953945964L;

        @Override
        public boolean accept(Tree t) {
            Label kidLabel;
            Tree[] kids = t.children();
            Label l = t.label();
            if (l != null && "-NONE-".equals(l.value()) && !t.isLeaf() && kids.length == 1 && kids[0].isLeaf()) {
                return false;
            }
            return l == null || !"PRP".equals(l.value()) || kids.length != 1 || !kids[0].isLeaf() || (kidLabel = kids[0].label()) == null || !"nullp".equals(l.value()) && !"_".equals(l.value()) && !"_".equals(l.value());
        }
    }
}

