/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.arabic.ArabicTreebankLanguagePack;
import java.util.HashMap;
import java.util.regex.Pattern;

public class ArabicHeadFinder
extends AbstractCollinsHeadFinder {
    private static final long serialVersionUID = 6203368998430280740L;
    protected TagSet tagSet;
    private final Pattern predPattern = Pattern.compile(".*-PRD$");

    public ArabicHeadFinder() {
        this(new ArabicTreebankLanguagePack());
    }

    public ArabicHeadFinder(String tagSet) {
        this(TagSet.tagSet(tagSet));
    }

    public ArabicHeadFinder(TagSet tagSet) {
        this(tagSet.langPack(), tagSet);
    }

    protected ArabicHeadFinder(TreebankLanguagePack tlp) {
        this(tlp, TagSet.BIES_COLLAPSED);
    }

    protected ArabicHeadFinder(TreebankLanguagePack tlp, TagSet tagSet) {
        super(tlp);
        this.tagSet = tagSet;
        this.nonTerminalInfo = new HashMap();
        this.nonTerminalInfo.put("SUBROOT", new String[][]{{"right", "S"}});
        this.nonTerminalInfo.put("NX", new String[][]{{"left", "DT", "DTNN", "DTNNS", "DTNNP", "DTNNPS", "DTJJ", "DTNOUN_QUANT", "NOUN_QUANT"}});
        this.nonTerminalInfo.put("ADJP", new String[][]{{"rightdis", tagSet.adj(), "DTJJ", "ADJ_NUM", "DTADJ_NUM", "JJR", "DTJJR"}, {"right", "ADJP", "VN", tagSet.noun(), "NNP", "NOFUNC", "NO_FUNC", "NNPS", "NNS", "DTNN", "DTNNS", "DTNNP", "DTNNPS", "DTJJ", "DTNOUN_QUANT", "NOUN_QUANT"}, {"right", "RB", "CD", "DTRB", "DTCD"}, {"right", "DT"}});
        this.nonTerminalInfo.put("ADVP", new String[][]{{"left", "WRB", "RB", "ADVP", "WHADVP", "DTRB"}, {"left", "CD", "RP", tagSet.noun(), "CC", tagSet.adj(), "DTJJ", "ADJ_NUM", "DTADJ_NUM", "IN", "NP", "NNP", "NOFUNC", "DTRP", "DTNN", "DTNNP", "DTNNPS", "DTNNS", "DTJJ", "DTNOUN_QUANT", "NOUN_QUANT"}});
        this.nonTerminalInfo.put("CONJP", new String[][]{{"right", "IN", "RB", tagSet.noun(), "NNS", "NNP", "NNPS", "DTRB", "DTNN", "DTNNS", "DTNNP", "DTNNPS", "DTNOUN_QUANT", "NOUN_QUANT"}});
        this.nonTerminalInfo.put("FRAG", new String[][]{{"left", tagSet.noun(), "NNPS", "NNP", "NNS", "DTNN", "DTNNS", "DTNNP", "DTNNPS", "DTNOUN_QUANT", "NOUN_QUANT"}, {"left", "VBP"}});
        this.nonTerminalInfo.put("INTJ", new String[][]{{"left", "RP", "UH", "DTRP"}});
        this.nonTerminalInfo.put("LST", new String[][]{{"left"}});
        this.nonTerminalInfo.put("NAC", new String[][]{{"left", "NP", "SBAR", "PP", "ADJP", "S", "PRT", "UCP"}, {"left", "ADVP"}});
        this.nonTerminalInfo.put("NP", new String[][]{{"left", tagSet.noun(), tagSet.detPlusNoun(), "NNS", "NNP", "NNPS", "NP", "PRP", "WHNP", "QP", "WP", "DTNNS", "DTNNPS", "DTNNP", "NOFUNC", "NO_FUNC", "DTNOUN_QUANT", "NOUN_QUANT"}, {"left", tagSet.adj(), "DTJJ", "JJR", "DTJJR", "ADJ_NUM", "DTADJ_NUM"}, {"right", "CD", "DTCD"}, {"left", "PRP$"}, {"right", "DT"}});
        this.nonTerminalInfo.put("PP", new String[][]{{"left", tagSet.prep(), "PP", "PRT", "X"}, {"left", "NNP", "RP", tagSet.noun()}, {"left", "NP"}});
        this.nonTerminalInfo.put("PRN", new String[][]{{"left", "NP"}});
        this.nonTerminalInfo.put("PRT", new String[][]{{"left", "RP", "PRT", "IN", "DTRP"}});
        this.nonTerminalInfo.put("QP", new String[][]{{"right", "CD", "DTCD", tagSet.noun(), tagSet.adj(), "NNS", "NNP", "NNPS", "DTNN", "DTNNS", "DTNNP", "DTNNPS", "DTJJ", "DTNOUN_QUANT", "NOUN_QUANT"}});
        this.nonTerminalInfo.put("S", new String[][]{{"left", "VP", "S"}, {"right", "PP", "ADVP", "SBAR", "UCP", "ADJP"}});
        this.nonTerminalInfo.put("SQ", new String[][]{{"left", "VP", "PP"}});
        this.nonTerminalInfo.put("SBAR", new String[][]{{"left", "WHNP", "WHADVP", "WRB", "RP", "IN", "SBAR", "CC", "WP", "WHPP", "ADVP", "PRT", "RB", "X", "DTRB", "DTRP"}, {"left", tagSet.noun(), "NNP", "NNS", "NNPS", "DTNN", "DTNNS", "DTNNP", "DTNNPS", "DTNOUN_QUANT", "NOUN_QUANT"}, {"left", "S"}});
        this.nonTerminalInfo.put("SBARQ", new String[][]{{"left", "WHNP", "WHADVP", "RP", "IN", "SBAR", "CC", "WP", "WHPP", "ADVP", "PRT", "RB", "X"}, {"left", tagSet.noun(), "NNP", "NNS", "NNPS", "DTNN", "DTNNS", "DTNNP", "DTNNPS", "DTNOUN_QUANT", "NOUN_QUANT"}, {"left", "S"}});
        this.nonTerminalInfo.put("UCP", new String[][]{{"left"}});
        this.nonTerminalInfo.put("VP", new String[][]{{"left", "VBD", "VBN", "VBP", "VBG", "DTVBG", "VN", "DTVN", "VP", "RB", "X", "VB"}, {"left", "IN"}, {"left", "NNP", "NOFUNC", tagSet.noun(), "DTNN", "DTNNP", "DTNNPS", "DTNNS", "DTNOUN_QUANT", "NOUN_QUANT"}});
        this.nonTerminalInfo.put("WHADVP", new String[][]{{"left", "WRB", "WP"}, {"right", "CC"}, {"left", "IN"}});
        this.nonTerminalInfo.put("WHNP", new String[][]{{"right", "WP"}});
        this.nonTerminalInfo.put("WHPP", new String[][]{{"left", "IN", "RB"}});
        this.nonTerminalInfo.put("X", new String[][]{{"left"}});
        this.nonTerminalInfo.put("DTNN", new String[][]{{"right"}});
        this.nonTerminalInfo.put("DTNNS", new String[][]{{"right"}});
        this.nonTerminalInfo.put("DTNNP", new String[][]{{"right"}});
        this.nonTerminalInfo.put("DTNNPS", new String[][]{{"right"}});
        this.nonTerminalInfo.put("DTJJ", new String[][]{{"right"}});
        this.nonTerminalInfo.put("DTRP", new String[][]{{"right"}});
        this.nonTerminalInfo.put("DTRB", new String[][]{{"right"}});
        this.nonTerminalInfo.put("DTCD", new String[][]{{"right"}});
        this.nonTerminalInfo.put("DTIN", new String[][]{{"right"}});
        this.nonTerminalInfo.put("EDITED", new String[][]{{"left"}});
        this.nonTerminalInfo.put("ROOT", new String[][]{{"left"}});
        this.nonTerminalInfo.put("SINV", new String[][]{{"left", "ADJP", "VP"}});
    }

    @Override
    protected Tree findMarkedHead(Tree t) {
        String cat = t.value();
        if (cat.equals("S")) {
            Tree[] kids;
            for (Tree kid : kids = t.children()) {
                if (!this.predPattern.matcher(kid.value()).matches()) continue;
                return kid;
            }
        }
        return null;
    }

    public static enum TagSet {
        BIES_COLLAPSED{

            @Override
            String prep() {
                return "IN";
            }

            @Override
            String noun() {
                return "NN";
            }

            @Override
            String det() {
                return "DT";
            }

            @Override
            String adj() {
                return "JJ";
            }

            @Override
            String detPlusNoun() {
                return "DTNN";
            }

            @Override
            TreebankLanguagePack langPack() {
                return new ArabicTreebankLanguagePack();
            }
        }
        ,
        ORIGINAL{

            @Override
            String prep() {
                return "PREP";
            }

            @Override
            String noun() {
                return "NOUN";
            }

            @Override
            String det() {
                return "DET";
            }

            @Override
            String adj() {
                return "ADJ";
            }

            @Override
            String detPlusNoun() {
                return "DET+NOUN";
            }

            @Override
            TreebankLanguagePack langPack() {
                return new ArabicTreebankLanguagePack(true);
            }
        };


        abstract String prep();

        abstract String noun();

        abstract String adj();

        abstract String det();

        abstract String detPlusNoun();

        abstract TreebankLanguagePack langPack();

        static TagSet tagSet(String str) {
            if (str.equals("BIES_COLLAPSED")) {
                return BIES_COLLAPSED;
            }
            if (str.equals("ORIGINAL")) {
                return ORIGINAL;
            }
            throw new IllegalArgumentException("Don't know anything about tagset " + str);
        }
    }
}

