/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeVisitor;
import java.io.Reader;

public class WordStemmer
implements TreeVisitor,
TreeReaderFactory {
    private Morphology morpha = new Morphology();

    @Override
    public void visitTree(Tree t) {
        this.processTree(t, null);
    }

    private void processTree(Tree t, String tag) {
        if (t.isPreTerminal()) {
            tag = t.label().value();
        }
        if (t.isLeaf()) {
            WordTag wt = this.morpha.stem(t.label().value(), tag);
            t.label().setValue(wt.word());
        } else {
            for (Tree kid : t.children()) {
                this.processTree(kid, tag);
            }
        }
    }

    @Override
    public TreeReader newTreeReader(Reader in) {
        return new PennTreeReader(in, new LabeledScoredTreeFactory(new CategoryWordTagFactory()), new BobChrisTreeNormalizer());
    }

    public static void main(String[] args) {
        WordStemmer ls = new WordStemmer();
        DiskTreebank treebank = new DiskTreebank(ls);
        treebank.loadPath(args[0]);
        for (Tree tree : treebank) {
            ls.visitTree(tree);
            System.out.println(tree);
        }
    }
}

