/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.CollocationFinder;
import edu.stanford.nlp.trees.Dependencies;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFunctions;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.WordNetConnection;
import edu.stanford.nlp.trees.WordStemmer;
import edu.stanford.nlp.trees.international.pennchinese.ChineseEnglishWordMap;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.XMLUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TreePrint {
    public static final String rootLabelOnlyFormat = "rootSymbolOnly";
    public static final String[] outputTreeFormats = new String[]{"penn", "oneline", "rootSymbolOnly", "words", "wordsAndTags", "dependencies", "typedDependencies", "typedDependenciesCollapsed", "latexTree", "collocations", "semanticGraph"};
    public static final String headMark = "=H";
    private Properties formats;
    private Properties options;
    private boolean markHeadNodes;
    private boolean lexicalize;
    private boolean stem;
    private boolean transChinese;
    private boolean basicDependencies;
    private boolean collapsedDependencies;
    private boolean CCPropagatedDependencies;
    private boolean treeDependencies;
    private HeadFinder hf;
    private TreebankLanguagePack tlp;
    private WordStemmer stemmer;
    private Filter<Dependency> dependencyFilter;
    private GrammaticalStructureFactory gsf;
    private static WordNetConnection wnc;
    private PrintWriter pw = new PrintWriter(System.out, true);

    public TreePrint(String formats) {
        this(formats, "", new PennTreebankLanguagePack());
    }

    public TreePrint(String formats, TreebankLanguagePack tlp) {
        this(formats, "", tlp);
    }

    public TreePrint(String formats, String options, TreebankLanguagePack tlp) {
        this(formats, options, tlp, new CollinsHeadFinder());
    }

    public TreePrint(String formatString, String optionsString, TreebankLanguagePack tlp, HeadFinder hf) {
        Filter<String> puncWordFilter;
        this.formats = StringUtils.stringToProperties(formatString);
        this.options = StringUtils.stringToProperties(optionsString);
        List<String> okOutputs = Arrays.asList(outputTreeFormats);
        for (Object formObj : this.formats.keySet()) {
            String format = (String)formObj;
            if (okOutputs.contains(format)) continue;
            throw new RuntimeException("Error: output tree format " + format + " not supported");
        }
        this.setHeadFinder(hf);
        this.tlp = tlp;
        boolean includePunctuationDependencies = TreePrint.propertyToBoolean(this.options, "includePunctuationDependencies");
        if (includePunctuationDependencies) {
            this.dependencyFilter = Filters.acceptFilter();
            puncWordFilter = Filters.acceptFilter();
        } else {
            this.dependencyFilter = new Dependencies.DependentPuncTagRejectFilter(tlp.punctuationTagRejectFilter());
            puncWordFilter = tlp.punctuationWordRejectFilter();
        }
        this.stem = TreePrint.propertyToBoolean(this.options, "stem");
        if (this.stem) {
            this.stemmer = new WordStemmer();
        }
        if (this.formats.containsKey("typedDependenciesCollapsed") || this.formats.containsKey("typedDependencies")) {
            this.gsf = tlp.grammaticalStructureFactory(puncWordFilter);
        }
        this.lexicalize = TreePrint.propertyToBoolean(this.options, "lexicalize");
        this.markHeadNodes = TreePrint.propertyToBoolean(this.options, "markHeadNodes");
        this.transChinese = TreePrint.propertyToBoolean(this.options, "transChinese");
        this.basicDependencies = TreePrint.propertyToBoolean(this.options, "basicDependencies");
        this.collapsedDependencies = TreePrint.propertyToBoolean(this.options, "collapsedDependencies");
        this.CCPropagatedDependencies = TreePrint.propertyToBoolean(this.options, "CCPropagatedDependencies");
        this.treeDependencies = TreePrint.propertyToBoolean(this.options, "treeDependencies");
        if (!this.basicDependencies & !this.collapsedDependencies & !this.treeDependencies) {
            this.CCPropagatedDependencies = true;
        }
    }

    private static boolean propertyToBoolean(Properties prop, String key) {
        return Boolean.parseBoolean(prop.getProperty(key));
    }

    public void printTree(Tree t) {
        this.printTree(t, this.pw);
    }

    public void printTree(Tree t, PrintWriter pw) {
        this.printTree(t, "", pw);
    }

    public void printTree(Tree t, String id, PrintWriter pw) {
        boolean inXml = TreePrint.propertyToBoolean(this.options, "xml");
        if (t == null) {
            if (inXml) {
                pw.print("<s");
                if (id != null && !"".equals(id)) {
                    pw.print(" id=\"" + XMLUtils.escapeXML(id) + '\"');
                }
                pw.println(" skipped=\"true\"/>");
                pw.println();
            } else {
                pw.println("SENTENCE_SKIPPED_OR_UNPARSABLE");
            }
        } else {
            if (inXml) {
                pw.print("<s");
                if (id != null && !"".equals(id)) {
                    pw.print(" id=\"" + XMLUtils.escapeXML(id) + '\"');
                }
                pw.println(">");
            }
            this.printTreeInternal(t, pw, inXml);
            if (inXml) {
                pw.println("</s>");
                pw.println();
            }
        }
    }

    public void printTrees(List<ScoredObject<Tree>> trees, String id, PrintWriter pw) {
        boolean inXml = TreePrint.propertyToBoolean(this.options, "xml");
        int ii = 0;
        for (ScoredObject<Tree> tp : trees) {
            ++ii;
            Tree t = tp.object();
            double score = tp.score();
            if (t == null) {
                if (inXml) {
                    pw.print("<s");
                    if (id != null && !"".equals(id)) {
                        pw.print(" id=\"" + XMLUtils.escapeXML(id) + '\"');
                    }
                    pw.print(" n=\"");
                    pw.print(ii);
                    pw.print('\"');
                    pw.print(" score=\"" + score + '\"');
                    pw.println(" skipped=\"true\"/>");
                    pw.println();
                    continue;
                }
                pw.println("SENTENCE_SKIPPED_OR_UNPARSABLE Parse #" + ii + " with score " + score);
                continue;
            }
            if (inXml) {
                pw.print("<s");
                if (id != null && !"".equals(id)) {
                    pw.print(" id=\"");
                    pw.print(XMLUtils.escapeXML(id));
                    pw.print('\"');
                }
                pw.print(" n=\"");
                pw.print(ii);
                pw.print('\"');
                pw.print(" score=\"");
                pw.print(score);
                pw.print('\"');
                pw.println(">");
            } else {
                pw.print("# Parse ");
                pw.print(ii);
                pw.print(" with score ");
                pw.println(score);
            }
            this.printTreeInternal(t, pw, inXml);
            if (!inXml) continue;
            pw.println("</s>");
            pw.println();
        }
    }

    private void printTreeInternal(Tree t, PrintWriter pw, boolean inXml) {
        ArrayList<Dependency> sortedDeps;
        Set<Dependency> depsSet;
        Function<Tree, Tree> a;
        String s;
        Tree outputTree = t;
        if (this.formats.containsKey("words")) {
            if (inXml) {
                Sentence sentUnstemmed = outputTree.yield();
                pw.println("  <words>");
                int i = 1;
                for (HasWord w : sentUnstemmed) {
                    pw.println("    <word ind=\"" + i + "\">" + XMLUtils.escapeXML(w.word()) + "</word>");
                    ++i;
                }
                pw.println("  </words>");
            } else {
                pw.println(outputTree.yield().toString(false));
                pw.println();
            }
        }
        if (TreePrint.propertyToBoolean(this.options, "removeTopBracket") && this.tlp.isStartSymbol(s = outputTree.label().value())) {
            if (outputTree.isUnaryRewrite()) {
                outputTree = outputTree.firstChild();
            } else {
                System.err.println("TreePrint: can't remove top bracket: not unary");
            }
        }
        if (this.stem) {
            this.stemmer.visitTree(outputTree);
        }
        if (this.lexicalize) {
            a = TreeFunctions.getLabeledTreeToCategoryWordTagTreeFunction();
            outputTree = a.apply(outputTree);
            outputTree.percolateHeads(this.hf);
        }
        if (this.formats.containsKey("collocations")) {
            outputTree = TreePrint.getCollocationProcessedTree(outputTree, this.hf);
        }
        if (!this.lexicalize) {
            a = TreeFunctions.getLabeledTreeToStringLabeledTreeFunction();
            outputTree = a.apply(outputTree);
        }
        Tree outputPSTree = outputTree;
        if (this.markHeadNodes) {
            outputPSTree = this.markHeadNodes(outputPSTree);
        }
        if (this.transChinese) {
            TreeTransformer tt = new TreeTransformer(){

                @Override
                public Tree transformTree(Tree t) {
                    t = t.deepCopy();
                    for (Tree subtree : t) {
                        if (!subtree.isLeaf()) continue;
                        Label oldLabel = subtree.label();
                        String translation = ChineseEnglishWordMap.getInstance().getFirstTranslation(oldLabel.value());
                        if (translation == null) {
                            translation = "[UNK]";
                        }
                        StringLabel newLabel = new StringLabel(oldLabel.value() + ':' + translation);
                        subtree.setLabel(newLabel);
                    }
                    return t;
                }
            };
            outputPSTree = tt.transformTree(outputPSTree);
        }
        if (TreePrint.propertyToBoolean(this.options, "xml")) {
            PrintWriter psw;
            if (this.formats.containsKey("wordsAndTags")) {
                Sentence<TaggedWord> sent = outputTree.taggedYield();
                pw.println("  <words pos=\"true\">");
                int i = 1;
                for (TaggedWord tw : sent) {
                    pw.println("    <word ind=\"" + i + "\" pos=\"" + XMLUtils.escapeXML(tw.tag()) + "\">" + XMLUtils.escapeXML(tw.word()) + "</word>");
                    ++i;
                }
                pw.println("  </words>");
            }
            if (this.formats.containsKey("penn")) {
                pw.println("  <tree style=\"penn\">");
                StringWriter sw = new StringWriter();
                psw = new PrintWriter(sw);
                outputPSTree.pennPrint(psw);
                pw.print(XMLUtils.escapeXML(sw.toString()));
                pw.println("  </tree>");
            }
            if (this.formats.containsKey("latexTree")) {
                pw.println("    <tree style=\"latexTrees\">");
                pw.println(".[");
                StringWriter sw = new StringWriter();
                psw = new PrintWriter(sw);
                outputTree.indentedListPrint(psw, false);
                pw.print(XMLUtils.escapeXML(sw.toString()));
                pw.println(".]");
                pw.println("  </tree>");
            }
            if (this.formats.containsKey("dependencies")) {
                Tree indexedTree = outputTree.deeperCopy(outputTree.treeFactory(), CyclicCoreLabel.factory());
                indexedTree.indexLeaves();
                depsSet = indexedTree.mapDependencies(this.dependencyFilter, this.hf);
                sortedDeps = new ArrayList<Dependency>(depsSet);
                Collections.sort(sortedDeps, Dependencies.dependencyIndexComparator());
                pw.println("<dependencies style=\"untyped\">");
                for (Dependency d : sortedDeps) {
                    pw.println(d.toString("xml"));
                }
                pw.println("</dependencies>");
            }
            if (this.formats.containsKey("typedDependencies")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                if (this.basicDependencies) {
                    TreePrint.print(gs.typedDependencies(), "xml", pw);
                }
                if (this.collapsedDependencies) {
                    TreePrint.print(gs.typedDependenciesCollapsed(true), "xml", pw);
                }
                if (this.CCPropagatedDependencies) {
                    TreePrint.print(gs.typedDependenciesCCprocessed(true), "xml", pw);
                }
                if (this.treeDependencies) {
                    TreePrint.print(gs.typedDependenciesCollapsedTree(), "xml", pw);
                }
            }
            if (this.formats.containsKey("typedDependenciesCollapsed")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                TreePrint.print(gs.typedDependenciesCollapsed(true), "xml", pw);
            }
        } else {
            if (this.formats.containsKey("wordsAndTags")) {
                pw.println(outputTree.taggedYield().toString(false));
                pw.println();
            }
            if (this.formats.containsKey("oneline")) {
                pw.println(outputTree.toString());
            }
            if (this.formats.containsKey("penn")) {
                outputPSTree.pennPrint(pw);
                pw.println();
            }
            if (this.formats.containsKey(rootLabelOnlyFormat)) {
                pw.println(outputTree.label());
            }
            if (this.formats.containsKey("latexTree")) {
                pw.println(".[");
                outputTree.indentedListPrint(pw, false);
                pw.println(".]");
            }
            if (this.formats.containsKey("dependencies")) {
                Tree indexedTree = outputTree.deeperCopy(outputTree.treeFactory(), CyclicCoreLabel.factory());
                indexedTree.indexLeaves();
                depsSet = indexedTree.mapDependencies(this.dependencyFilter, this.hf);
                sortedDeps = new ArrayList<Dependency>(depsSet);
                Collections.sort(sortedDeps, Dependencies.dependencyIndexComparator());
                for (Dependency d : sortedDeps) {
                    pw.println(d.toString("predicate"));
                }
                pw.println();
            }
            if (this.formats.containsKey("typedDependencies")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                if (this.basicDependencies) {
                    TreePrint.print(gs.typedDependencies(), pw);
                }
                if (this.collapsedDependencies) {
                    TreePrint.print(gs.typedDependenciesCollapsed(true), pw);
                }
                if (this.CCPropagatedDependencies) {
                    TreePrint.print(gs.typedDependenciesCCprocessed(true), pw);
                }
                if (this.treeDependencies) {
                    TreePrint.print(gs.typedDependenciesCollapsedTree(), pw);
                }
            }
            if (this.formats.containsKey("typedDependenciesCollapsed")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                TreePrint.print(gs.typedDependenciesCollapsed(), pw);
            }
        }
    }

    private static synchronized Tree getCollocationProcessedTree(Tree tree, HeadFinder hf) {
        if (wnc == null) {
            try {
                Class<?> cl = Class.forName("edu.stanford.nlp.trees.WordNetInstance");
                wnc = (WordNetConnection)cl.newInstance();
            }
            catch (Exception e) {
                System.err.println("Couldn't open WordNet Connection.  Aborting collocation detection.");
                e.printStackTrace();
                wnc = null;
            }
        }
        if (wnc != null) {
            CollocationFinder cf = new CollocationFinder(tree, wnc, hf);
            tree = cf.getMangledTree();
        } else {
            System.err.println("ERROR: WordNetConnection unavailable for collocations.");
        }
        return tree;
    }

    public void printHeader(PrintWriter pw, String charset) {
        if (TreePrint.propertyToBoolean(this.options, "xml")) {
            pw.println("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
            pw.println("<corpus>");
        }
    }

    public void printFooter(PrintWriter pw) {
        if (TreePrint.propertyToBoolean(this.options, "xml")) {
            pw.println("</corpus>");
        }
    }

    public void setStem(boolean stem) {
        this.stem = stem;
        this.stemmer = stem ? new WordStemmer() : null;
    }

    public final void setHeadFinder(HeadFinder hf) {
        this.hf = hf;
    }

    public final HeadFinder getHeadFinder() {
        return this.hf;
    }

    public void setPrintWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public Tree markHeadNodes(Tree t) {
        return this.markHeadNodes(t, null);
    }

    private Tree markHeadNodes(Tree t, Tree head) {
        if (t.isLeaf()) {
            return t;
        }
        Label newLabel = t == head ? TreePrint.headMark(t.label()) : t.label();
        Tree newHead = this.hf.determineHead(t);
        return t.treeFactory().newTreeNode(newLabel, Arrays.asList(this.headMarkChildren(t, newHead)));
    }

    private static Label headMark(Label l) {
        Label l1 = l.labelFactory().newLabel(l);
        l1.setValue(l1.value() + headMark);
        return l1;
    }

    private Tree[] headMarkChildren(Tree t, Tree head) {
        Tree[] kids = t.children();
        Tree[] newKids = new Tree[kids.length];
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            newKids[i] = this.markHeadNodes(kids[i], head);
        }
        return newKids;
    }

    public static void main(String[] args) {
        Iterator<Tree> i;
        HeadFinder hf;
        TreebankLanguagePack tlp;
        String format = "penn";
        String options = "";
        String tlpName = "edu.stanford.nlp.trees.PennTreebankLanguagePack";
        String hfName = null;
        HashMap<String, Integer> flagMap = new HashMap<String, Integer>();
        flagMap.put("-format", 1);
        flagMap.put("-options", 1);
        flagMap.put("-tLP", 1);
        flagMap.put("-hf", 1);
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, flagMap);
        args = argsMap.get(null);
        if (argsMap.keySet().contains("-format")) {
            format = argsMap.get("-format")[0];
        }
        if (argsMap.keySet().contains("-options")) {
            options = argsMap.get("-options")[0];
        }
        if (argsMap.keySet().contains("-tLP")) {
            tlpName = argsMap.get("-tLP")[0];
        }
        if (argsMap.keySet().contains("-hf")) {
            hfName = argsMap.get("-hf")[0];
        }
        try {
            tlp = (TreebankLanguagePack)Class.forName(tlpName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (hfName != null) {
            try {
                hf = (HeadFinder)Class.forName(hfName).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        } else {
            hf = tlp.headFinder();
        }
        TreePrint print = new TreePrint(format, options, tlp, hf == null ? tlp.headFinder() : hf);
        if (args.length > 0) {
            TreeReaderFactory trf = argsMap.keySet().contains("-useTLPTreeReader") ? tlp.treeReaderFactory() : new TreeReaderFactory(){

                @Override
                public TreeReader newTreeReader(Reader in) {
                    return new PennTreeReader(in, new LabeledScoredTreeFactory(new StringLabelFactory()), new TreeNormalizer());
                }
            };
            DiskTreebank trees = new DiskTreebank(trf);
            trees.loadPath(args[0]);
            i = ((AbstractCollection)trees).iterator();
        } else {
            i = tlp.treeTokenizerFactory().getTokenizer(new BufferedReader(new InputStreamReader(System.in)));
        }
        while (i.hasNext()) {
            print.printTree((Tree)i.next());
        }
    }

    private static String toString(Collection<TypedDependency> dependencies, String format) {
        if (format != null && format.equals("xml")) {
            return TreePrint.toXMLString(dependencies);
        }
        if (format != null && format.equals("readable")) {
            return TreePrint.toReadableString(dependencies);
        }
        return TreePrint.toString(dependencies);
    }

    private static String toString(Collection<TypedDependency> dependencies) {
        StringBuilder buf = new StringBuilder();
        for (TypedDependency td : dependencies) {
            buf.append(td.toString()).append('\n');
        }
        return buf.toString();
    }

    private static String toReadableString(Collection<TypedDependency> dependencies) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%-20s%-20s%-20s%n", "dep", "reln", "gov"));
        buf.append(String.format("%-20s%-20s%-20s%n", "---", "----", "---"));
        for (TypedDependency td : dependencies) {
            buf.append(String.format("%-20s%-20s%-20s%n", td.dep(), td.reln(), td.gov()));
        }
        return buf.toString();
    }

    private static String toXMLString(Collection<TypedDependency> dependencies) {
        StringBuilder buf = new StringBuilder("<dependencies style=\"typed\">\n");
        for (TypedDependency td : dependencies) {
            String reln = td.reln().toString();
            String gov = td.gov().value();
            int govIdx = td.gov().index();
            String dep = td.dep().value();
            int depIdx = td.dep().index();
            String govCopy = "";
            if (td.gov().label.get(CoreAnnotations.CopyAnnotation.class) != null && ((Boolean)td.gov().label.get(CoreAnnotations.CopyAnnotation.class)).booleanValue()) {
                govCopy = " copy=\"yes\"";
            }
            String depCopy = "";
            if (td.dep().label.get(CoreAnnotations.CopyAnnotation.class) != null && ((Boolean)td.dep().label.get(CoreAnnotations.CopyAnnotation.class)).booleanValue()) {
                depCopy = " copy=\"yes\"";
            }
            buf.append("  <dep type=\"").append(XMLUtils.escapeXML(reln)).append("\">\n");
            buf.append("    <governor idx=\"").append(govIdx).append('\"').append(govCopy).append('>').append(XMLUtils.escapeXML(gov)).append("</governor>\n");
            buf.append("    <dependent idx=\"").append(depIdx).append('\"').append(depCopy).append('>').append(XMLUtils.escapeXML(dep)).append("</dependent>\n");
            buf.append("  </dep>\n");
        }
        buf.append("</dependencies>");
        return buf.toString();
    }

    public static void print(Collection<TypedDependency> dependencies, PrintWriter pw) {
        pw.println(TreePrint.toString(dependencies));
    }

    public static void print(Collection<TypedDependency> dependencies, String format, PrintWriter pw) {
        pw.println(TreePrint.toString(dependencies, format));
    }
}

