/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TreeGraph
implements Serializable {
    protected TreeGraphNode root;
    private Map<Integer, TreeGraphNode> indexMap = new HashMap<Integer, TreeGraphNode>();
    private static final long serialVersionUID = 1L;

    public TreeGraph(Tree t) {
        this.root = new TreeGraphNode(t, this);
        this.root.indexNodes();
    }

    public TreeGraphNode root() {
        return this.root;
    }

    public void addNodeToIndexMap(int index, TreeGraphNode node) {
        this.indexMap.put(index, node);
    }

    public TreeGraphNode getNodeByIndex(int index) {
        return this.indexMap.get(index);
    }

    public Collection<TreeGraphNode> getNodes() {
        return this.indexMap.values();
    }

    public String toString() {
        return this.root.toPrettyString(0).substring(1);
    }

    public static void main(String[] args) {
        Tree t;
        try {
            t = Tree.valueOf("(S (NP (NNP Sam)) (VP (VBD died) (NP-TMP (NN today))))");
        }
        catch (Exception e) {
            System.err.println("Horrible error: " + e);
            e.printStackTrace();
            return;
        }
        t.pennPrint();
        System.out.println("----------------------------");
        TreeGraph tg = new TreeGraph(t);
        System.out.println(tg);
        tg.root.percolateHeads(new SemanticHeadFinder());
        System.out.println("----------------------------");
        System.out.println(tg);
    }
}

