/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.CompositeTreeTransformer;
import edu.stanford.nlp.trees.CompositeTreebank;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.MyTreeTransformer;
import edu.stanford.nlp.trees.MyTreeTransformer2;
import edu.stanford.nlp.trees.MyTreeTransformer3;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.Timing;
import java.io.File;
import java.io.FileFilter;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;

public class TransformingTreebank
extends Treebank {
    private TreeTransformer transformer;
    private Treebank tb;
    private static final boolean VERBOSE = false;

    public TransformingTreebank() {
        this(new LabeledScoredTreeReaderFactory());
    }

    public TransformingTreebank(TreeReaderFactory trf) {
        super(trf);
    }

    public TransformingTreebank(Treebank tb, TreeTransformer transformer) {
        this.tb = tb;
        this.transformer = transformer;
    }

    @Override
    public void clear() {
        this.tb.clear();
        this.transformer = null;
    }

    @Override
    public void loadPath(File path, FileFilter filt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void apply(TreeVisitor tv) {
        for (Tree t : this.tb) {
            Tree tmpT = t.deeperCopy();
            if (this.transformer != null) {
                tmpT = this.transformer.transformTree(tmpT);
            }
            tv.visitTree(tmpT);
        }
    }

    @Override
    public Iterator<Tree> iterator() {
        return new TransformingTreebankIterator(this.tb.iterator(), this.transformer);
    }

    public static void main(String[] args) {
        Timing.startTime();
        DiskTreebank treebank = new DiskTreebank(new TreeReaderFactory(){

            @Override
            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory());
            }
        });
        MemoryTreebank treebank2 = new MemoryTreebank(new TreeReaderFactory(){

            @Override
            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory());
            }
        });
        treebank.loadPath(args[0]);
        treebank2.loadPath(args[0]);
        CompositeTreebank c = new CompositeTreebank(treebank, treebank2);
        Timing.endTime();
        MyTreeTransformer myTransformer = new MyTreeTransformer();
        MyTreeTransformer2 myTransformer2 = new MyTreeTransformer2();
        MyTreeTransformer3 myTransformer3 = new MyTreeTransformer3();
        Treebank tf1 = c.transform(myTransformer).transform(myTransformer2).transform(myTransformer3);
        TransformingTreebank tf2 = new TransformingTreebank(new TransformingTreebank(new TransformingTreebank(c, myTransformer), myTransformer2), myTransformer3);
        TreeTransformer[] tta = new TreeTransformer[]{myTransformer, myTransformer2, myTransformer3};
        CompositeTreeTransformer tt3 = new CompositeTreeTransformer(Arrays.asList(tta));
        Treebank tf3 = c.transform(tt3);
        System.out.println("-------------------------");
        System.out.println("COMPOSITE (DISK THEN MEMORY REPEATED VERSION OF) INPUT TREEBANK");
        System.out.println(c);
        System.out.println("-------------------------");
        System.out.println("SLOWLY TRANSFORMED TREEBANK, USING TransformingTreebank() CONSTRUCTOR");
        TransformingTreebank tx1 = new TransformingTreebank(c, myTransformer);
        System.out.println(tx1);
        System.out.println("-----");
        TransformingTreebank tx2 = new TransformingTreebank(tx1, myTransformer2);
        System.out.println(tx2);
        System.out.println("-----");
        TransformingTreebank tx3 = new TransformingTreebank(tx2, myTransformer3);
        System.out.println(tx3);
        System.out.println("-------------------------");
        System.out.println("TRANSFORMED TREEBANK, USING Treebank.transform()");
        System.out.println(tf1);
        System.out.println("-------------------------");
        System.out.println("PRINTING AGAIN TRANSFORMED TREEBANK, USING Treebank.transform()");
        System.out.println(tf1);
        System.out.println("-------------------------");
        System.out.println("TRANSFORMED TREEBANK, USING TransformingTreebank() CONSTRUCTOR");
        System.out.println(tf2);
        System.out.println("-------------------------");
        System.out.println("TRANSFORMED TREEBANK, USING CompositeTreeTransformer");
        System.out.println(tf3);
        System.out.println("-------------------------");
        System.out.println("COMPOSITE (DISK THEN MEMORY REPEATED VERSION OF) INPUT TREEBANK");
        System.out.println(c);
        System.out.println("-------------------------");
    }

    private static class TransformingTreebankIterator
    implements Iterator<Tree> {
        private Iterator<Tree> iter;
        private TreeTransformer transformer;

        TransformingTreebankIterator(Iterator<Tree> iter, TreeTransformer transformer) {
            this.iter = iter;
            this.transformer = transformer;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Tree next() {
            Tree ret = this.iter.next();
            if (this.transformer != null) {
                ret = this.transformer.transformTree(ret);
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

