/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.SimpleTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import java.util.List;

public class SimpleTree
extends Tree {
    private Tree[] daughterTrees;

    public SimpleTree() {
        this.daughterTrees = EMPTY_TREE_ARRAY;
    }

    public SimpleTree(Label label) {
        this();
    }

    public SimpleTree(Label label, List<Tree> daughterTreesList) {
        this.setChildren(daughterTreesList);
    }

    @Override
    public Tree[] children() {
        return this.daughterTrees;
    }

    @Override
    public void setChildren(Tree[] children) {
        if (children == null) {
            System.err.println("Warning -- you tried to set the children of a SimpleTree to null.\nYou should be really using a zero-length array instead.");
            this.daughterTrees = EMPTY_TREE_ARRAY;
        } else {
            this.daughterTrees = children;
        }
    }

    @Override
    public TreeFactory treeFactory() {
        return TreeFactoryHolder.tf;
    }

    public static TreeFactory factory() {
        return TreeFactoryHolder.tf;
    }

    private static class TreeFactoryHolder {
        static final TreeFactory tf = new SimpleTreeFactory();

        private TreeFactoryHolder() {
        }
    }
}

