/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.Filter;
import java.util.Collections;
import java.util.regex.Pattern;

public class NPTmpRetainingTreeNormalizer
extends BobChrisTreeNormalizer {
    public static final int TEMPORAL_NONE = 0;
    public static final int TEMPORAL_ACL03PCFG = 1;
    public static final int TEMPORAL_ANY_TMP_PERCOLATED = 2;
    public static final int TEMPORAL_ALL_TERMINALS = 3;
    public static final int TEMPORAL_ALL_NP = 4;
    public static final int TEMPORAL_ALL_NP_AND_PP = 5;
    public static final int TEMPORAL_NP_AND_PP_WITH_NP_HEAD = 6;
    public static final int TEMPORAL_ALL_NP_EVEN_UNDER_PP = 7;
    public static final int TEMPORAL_ALL_NP_PP_ADVP = 8;
    public static final int TEMPORAL_9 = 9;
    private static final boolean onlyTagAnnotateNstar = true;
    private static final Pattern NPTmpPattern = Pattern.compile("NP.*-TMP.*");
    private static final Pattern PPTmpPattern = Pattern.compile("PP.*-TMP.*");
    private static final Pattern ADVPTmpPattern = Pattern.compile("ADVP.*-TMP.*");
    private static final Pattern TmpPattern = Pattern.compile(".*-TMP.*");
    private static final Pattern NPSbjPattern = Pattern.compile("NP.*-SBJ.*");
    private static final Pattern NPAdvPattern = Pattern.compile("NP.*-ADV.*");
    private final int temporalAnnotation;
    private final boolean doSGappedStuff;
    private final int leaveItAll;
    private final boolean doAdverbialNP;
    private final HeadFinder headFinder;

    public NPTmpRetainingTreeNormalizer() {
        this(1, false);
    }

    public NPTmpRetainingTreeNormalizer(int temporalAnnotation, boolean doSGappedStuff) {
        this(temporalAnnotation, doSGappedStuff, 0, false);
    }

    public NPTmpRetainingTreeNormalizer(int temporalAnnotation, boolean doSGappedStuff, int leaveItAll, boolean doAdverbialNP) {
        this(temporalAnnotation, doSGappedStuff, leaveItAll, doAdverbialNP, new ModCollinsHeadFinder());
    }

    public NPTmpRetainingTreeNormalizer(int temporalAnnotation, boolean doSGappedStuff, int leaveItAll, boolean doAdverbialNP, HeadFinder headFinder) {
        this.temporalAnnotation = temporalAnnotation;
        this.doSGappedStuff = doSGappedStuff;
        this.leaveItAll = leaveItAll;
        this.doAdverbialNP = doAdverbialNP;
        this.headFinder = headFinder;
    }

    @Override
    protected String cleanUpLabel(String label) {
        if (label == null) {
            return "ROOT";
        }
        if (this.leaveItAll == 1) {
            return this.tlp.categoryAndFunction(label);
        }
        if (this.leaveItAll == 2) {
            return label;
        }
        boolean nptemp = NPTmpPattern.matcher(label).matches();
        boolean pptemp = PPTmpPattern.matcher(label).matches();
        boolean advptemp = ADVPTmpPattern.matcher(label).matches();
        boolean anytemp = TmpPattern.matcher(label).matches();
        boolean subj = NPSbjPattern.matcher(label).matches();
        boolean npadv = NPAdvPattern.matcher(label).matches();
        label = this.tlp.basicCategory(label);
        if (anytemp && this.temporalAnnotation == 2) {
            label = label + "-TMP";
        } else if (pptemp && (this.temporalAnnotation == 5 || this.temporalAnnotation == 6 || this.temporalAnnotation == 7 || this.temporalAnnotation == 8 || this.temporalAnnotation == 9)) {
            label = label + "-TMP";
        } else if (advptemp && (this.temporalAnnotation == 8 || this.temporalAnnotation == 9)) {
            label = label + "-TMP";
        } else if (this.temporalAnnotation > 0 && nptemp) {
            label = label + "-TMP";
        }
        if (this.doAdverbialNP && npadv) {
            label = label + "-ADV";
        }
        if (this.doSGappedStuff && subj) {
            label = label + "-SBJ";
        }
        return label;
    }

    private static boolean includesEmptyNPSubj(Tree t) {
        if (t == null) {
            return false;
        }
        Tree[] kids = t.children();
        if (kids == null) {
            return false;
        }
        boolean foundNullSubj = false;
        for (int i = 0; i < kids.length; ++i) {
            Tree[] kidkids = kids[i].children();
            if (!NPSbjPattern.matcher(kids[i].value()).matches()) continue;
            kids[i].setValue("NP");
            if (kidkids == null || kidkids.length != 1 || !kidkids[0].value().equals("-NONE-")) continue;
            foundNullSubj = true;
        }
        return foundNullSubj;
    }

    @Override
    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        TreeTransformer transformer1 = new TreeTransformer(){

            @Override
            public Tree transformTree(Tree t) {
                String lab;
                if (NPTmpRetainingTreeNormalizer.this.doSGappedStuff && (lab = t.label().value()).equals("S") && NPTmpRetainingTreeNormalizer.includesEmptyNPSubj(t)) {
                    LabelFactory lf = t.label().labelFactory();
                    t.setLabel(lf.newLabel(t.label().value() + "-G"));
                }
                return t;
            }
        };
        Filter<Tree> subtreeFilter = new Filter<Tree>(){

            @Override
            public boolean accept(Tree t) {
                Tree[] kids = t.children();
                Label l = t.label();
                if ("RS".equals(t.label().value()) || "RM".equals(t.label().value()) || "IP".equals(t.label().value()) || "CODE".equals(t.label().value())) {
                    return false;
                }
                return l == null || l.value() == null || !l.value().equals("-NONE-") || t.isLeaf() || kids.length != 1 || !kids[0].isLeaf();
            }
        };
        Filter<Tree> nodeFilter = new Filter<Tree>(){

            @Override
            public boolean accept(Tree t) {
                if (t.isLeaf() || t.isPreTerminal()) {
                    return true;
                }
                if (t.numChildren() != 1) {
                    return true;
                }
                return t.label() == null || t.label().value() == null || !t.label().value().equals(t.children()[0].label().value());
            }
        };
        TreeTransformer transformer2 = new TreeTransformer(){

            @Override
            public Tree transformTree(Tree t) {
                Tree ht;
                Tree oldT;
                String lab;
                if (NPTmpRetainingTreeNormalizer.this.temporalAnnotation == 2) {
                    lab = t.label().value();
                    if (TmpPattern.matcher(lab).matches()) {
                        oldT = t;
                        do {
                            int j;
                            if ((ht = NPTmpRetainingTreeNormalizer.this.headFinder.determineHead(oldT)).label().value().equals("POS") && (j = oldT.indexOf(ht)) > 0) {
                                ht = oldT.getChild(j - 1);
                            }
                            LabelFactory lf = ht.label().labelFactory();
                            ht.setLabel(lf.newLabel(ht.label().value() + "-TMP"));
                            oldT = ht;
                        } while (!ht.isPreTerminal());
                        if (lab.startsWith("PP")) {
                            int sz;
                            ht = NPTmpRetainingTreeNormalizer.this.headFinder.determineHead(t);
                            int j = t.indexOf(ht);
                            if (j + 1 < (sz = t.children().length)) {
                                ht = t.getChild(j + 1);
                            }
                            if (ht.label().value().startsWith("NP")) {
                                while (!ht.isLeaf()) {
                                    LabelFactory lf = ht.label().labelFactory();
                                    ht.setLabel(lf.newLabel(ht.label().value() + "-TMP"));
                                    ht = NPTmpRetainingTreeNormalizer.this.headFinder.determineHead(ht);
                                }
                            }
                        }
                    }
                } else if (NPTmpRetainingTreeNormalizer.this.temporalAnnotation == 3) {
                    lab = t.label().value();
                    if (NPTmpPattern.matcher(lab).matches()) {
                        Tree ht2 = NPTmpRetainingTreeNormalizer.this.headFinder.determineHead(t);
                        if (ht2.isPreTerminal()) {
                            LabelFactory lf = ht2.label().labelFactory();
                            Tree[] kids = t.children();
                            for (int i = 0; i < kids.length; ++i) {
                                if (!kids[i].isPreTerminal()) continue;
                                kids[i].setLabel(lf.newLabel(kids[i].value() + "-TMP"));
                            }
                        } else {
                            Tree oldT2 = t;
                            do {
                                oldT2 = ht2 = NPTmpRetainingTreeNormalizer.this.headFinder.determineHead(oldT2);
                            } while (!ht2.isPreTerminal());
                            LabelFactory lf = ht2.label().labelFactory();
                            ht2.setLabel(lf.newLabel(ht2.label().value() + "-TMP"));
                        }
                    }
                } else if (NPTmpRetainingTreeNormalizer.this.temporalAnnotation == 4) {
                    lab = t.label().value();
                    if (NPTmpPattern.matcher(lab).matches()) {
                        oldT = t;
                        do {
                            int j;
                            if ((ht = NPTmpRetainingTreeNormalizer.this.headFinder.determineHead(oldT)).label().value().equals("POS") && (j = oldT.indexOf(ht)) > 0) {
                                ht = oldT.getChild(j - 1);
                            }
                            if (!ht.isPreTerminal() && !ht.value().startsWith("NP")) continue;
                            LabelFactory lf = ht.labelFactory();
                            ht.setLabel(lf.newLabel(ht.label().value() + "-TMP"));
                            oldT = ht;
                        } while (ht.value().startsWith("NP"));
                    }
                } else if (NPTmpRetainingTreeNormalizer.this.temporalAnnotation == 5 || NPTmpRetainingTreeNormalizer.this.temporalAnnotation == 6 || NPTmpRetainingTreeNormalizer.this.temporalAnnotation == 7) {
                    lab = t.value();
                    if (NPTmpPattern.matcher(lab).matches() || PPTmpPattern.matcher(lab).matches()) {
                        oldT = t;
                        do {
                            if ((ht = NPTmpRetainingTreeNormalizer.this.headFinder.determineHead(oldT)).value().equals("POS")) {
                                int j = oldT.indexOf(ht);
                                if (j > 0) {
                                    ht = oldT.getChild(j - 1);
                                }
                            } else if ((NPTmpRetainingTreeNormalizer.this.temporalAnnotation == 6 || NPTmpRetainingTreeNormalizer.this.temporalAnnotation == 7) && (ht.value().equals("IN") || ht.value().equals("TO"))) {
                                Tree[] kidlets = oldT.children();
                                for (int k = kidlets.length - 1; k > 0; --k) {
                                    if (!kidlets[k].value().startsWith("NP")) continue;
                                    ht = kidlets[k];
                                }
                            }
                            LabelFactory lf = ht.labelFactory();
                            if (ht.isPreTerminal() || ht.value().startsWith("NP")) {
                                ht.setLabel(lf.newLabel(ht.value() + "-TMP"));
                            }
                            if (NPTmpRetainingTreeNormalizer.this.temporalAnnotation != 7 || !oldT.value().startsWith("PP")) continue;
                            oldT.setLabel(lf.newLabel(NPTmpRetainingTreeNormalizer.this.tlp.basicCategory(oldT.value())));
                        } while ((oldT = ht).value().startsWith("NP") || oldT.value().startsWith("PP"));
                    }
                } else if (NPTmpRetainingTreeNormalizer.this.temporalAnnotation == 8) {
                    lab = t.value();
                    if (NPTmpPattern.matcher(lab).matches() || PPTmpPattern.matcher(lab).matches() || ADVPTmpPattern.matcher(lab).matches()) {
                        oldT = t;
                        do {
                            int j;
                            if ((ht = NPTmpRetainingTreeNormalizer.this.headFinder.determineHead(oldT)).value().equals("POS") && (j = oldT.indexOf(ht)) > 0) {
                                ht = oldT.getChild(j - 1);
                            }
                            if (!ht.isPreTerminal() && !ht.value().startsWith("NP")) continue;
                            LabelFactory lf = ht.labelFactory();
                            ht.setLabel(lf.newLabel(ht.value() + "-TMP"));
                        } while ((oldT = ht).value().startsWith("NP"));
                    }
                } else if (NPTmpRetainingTreeNormalizer.this.temporalAnnotation == 9) {
                    lab = t.value();
                    if (NPTmpPattern.matcher(lab).matches() || PPTmpPattern.matcher(lab).matches() || ADVPTmpPattern.matcher(lab).matches()) {
                        NPTmpRetainingTreeNormalizer.this.addTMP9(t);
                    }
                } else if (NPTmpRetainingTreeNormalizer.this.temporalAnnotation == 1 && (lab = t.label().value()) != null && NPTmpPattern.matcher(lab).matches()) {
                    oldT = t;
                    do {
                        int j;
                        if ((ht = NPTmpRetainingTreeNormalizer.this.headFinder.determineHead(oldT)).label().value().equals("POS") && (j = oldT.indexOf(ht)) > 0) {
                            ht = oldT.getChild(j - 1);
                        }
                        oldT = ht;
                    } while (!ht.isPreTerminal());
                    if (ht.label().value().startsWith("N")) {
                        LabelFactory lf = ht.label().labelFactory();
                        ht.setLabel(lf.newLabel(ht.label().value() + "-TMP"));
                    }
                }
                if (NPTmpRetainingTreeNormalizer.this.doAdverbialNP) {
                    lab = t.value();
                    if (NPAdvPattern.matcher(lab).matches()) {
                        oldT = t;
                        do {
                            int j;
                            if ((ht = NPTmpRetainingTreeNormalizer.this.headFinder.determineHead(oldT)).label().value().equals("POS") && (j = oldT.indexOf(ht)) > 0) {
                                ht = oldT.getChild(j - 1);
                            }
                            if (!ht.isPreTerminal() && !ht.value().startsWith("NP")) continue;
                            LabelFactory lf = ht.labelFactory();
                            ht.setLabel(lf.newLabel(ht.label().value() + "-ADV"));
                            oldT = ht;
                        } while (ht.value().startsWith("NP"));
                    }
                }
                return t;
            }
        };
        if (tree.label().value().equals("S")) {
            tree = tf.newTreeNode("ROOT", Collections.singletonList(tree));
        }
        for (Tree subtree : tree) {
            if (!subtree.isPhrasal() || !"VB".equals(subtree.label().value())) continue;
            subtree.setValue("VP");
        }
        if ((tree = tree.transform(transformer1)) == null) {
            return null;
        }
        if ((tree = tree.prune(subtreeFilter, tf)) == null) {
            return null;
        }
        if ((tree = tree.spliceOut(nodeFilter, tf)) == null) {
            return null;
        }
        return tree.transform(transformer2, tf);
    }

    private void addTMP9(Tree tree) {
        int j;
        Tree ht = this.headFinder.determineHead(tree);
        if (ht.value().equals("POS") && (j = tree.indexOf(ht)) > 0) {
            ht = tree.getChild(j - 1);
        }
        if (ht.isPreTerminal() || ht.value().startsWith("NP") || ht.value().startsWith("PP") || ht.value().startsWith("ADVP")) {
            if (!TmpPattern.matcher(ht.value()).matches()) {
                LabelFactory lf = ht.labelFactory();
                ht.setLabel(lf.newLabel(ht.value() + "-TMP"));
            }
            if (ht.value().startsWith("NP") || ht.value().startsWith("PP") || ht.value().startsWith("ADVP")) {
                this.addTMP9(ht);
            }
        }
        Tree[] kidlets = tree.children();
        for (int k = 0; k < kidlets.length; ++k) {
            LabelFactory lf;
            ht = kidlets[k];
            if (tree.isPrePreTerminal() && !TmpPattern.matcher(ht.value()).matches()) {
                lf = ht.labelFactory();
                ht.setLabel(lf.newLabel(ht.value() + "-TMP"));
                continue;
            }
            if (!ht.value().startsWith("NP")) continue;
            if (!TmpPattern.matcher(ht.value()).matches()) {
                lf = ht.labelFactory();
                ht.setLabel(lf.newLabel(ht.value() + "-TMP"));
            }
            this.addTMP9(ht);
        }
    }
}

