/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;

public class LabeledScoredTreeLeaf
extends Tree {
    private Label label;
    private double score;

    public LabeledScoredTreeLeaf() {
    }

    public LabeledScoredTreeLeaf(Label label) {
        this.label = label;
    }

    public LabeledScoredTreeLeaf(Label label, double score) {
        this.label = label;
        this.score = score;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Tree[] children() {
        return EMPTY_TREE_ARRAY;
    }

    @Override
    public void setChildren(Tree[] children) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return ((Object)this.label).toString();
    }

    @Override
    public StringBuffer toStringBuffer(StringBuffer sb) {
        return sb.append(this.toString());
    }

    @Override
    public Label label() {
        return this.label;
    }

    @Override
    public void setLabel(Label label) {
        this.label = label;
    }

    @Override
    public double score() {
        return this.score;
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public void insertDtr(Tree dtr, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChild(int i, Tree t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChild(Tree t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tree setChild(int i, Tree t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TreeFactory treeFactory() {
        LabelFactory lf = this.label() != null ? this.label().labelFactory() : StringLabel.factory();
        return new LabeledScoredTreeFactory(lf);
    }

    public static TreeFactory factory() {
        return LabeledScoredTreeNode.factory();
    }

    public static TreeFactory factory(LabelFactory lf) {
        return LabeledScoredTreeNode.factory(lf);
    }
}

