/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Filter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class GrammaticalStructureFactory {
    private final Constructor con;
    private final Filter<String> puncFilter;
    private final HeadFinder hf;

    public GrammaticalStructureFactory(String name) {
        this(name, null);
    }

    public GrammaticalStructureFactory(String name, Filter<String> puncFilter) {
        this(name, puncFilter, null);
    }

    public GrammaticalStructureFactory(String name, Filter<String> puncFilter, HeadFinder hf) {
        Class<?> h;
        Class<?> f;
        Class<?> t;
        Class<?> c;
        try {
            c = Class.forName(name);
            if (!Class.forName("edu.stanford.nlp.trees.GrammaticalStructure").isAssignableFrom(c)) {
                throw new ClassNotFoundException();
            }
            t = Class.forName("edu.stanford.nlp.trees.Tree");
            f = Class.forName("edu.stanford.nlp.util.Filter");
            h = Class.forName("edu.stanford.nlp.trees.HeadFinder");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class " + name + " does not exist or does not extend edu.stanford.nlp.trees.GrammaticalStructure.");
        }
        try {
            this.con = puncFilter == null ? (hf == null ? c.getConstructor(t) : c.getConstructor(t, h)) : (hf == null ? c.getConstructor(t, f) : c.getConstructor(t, f, h));
            this.puncFilter = puncFilter;
            this.hf = hf;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException();
        }
    }

    public GrammaticalStructure newGrammaticalStructure(Tree t) {
        try {
            if (this.puncFilter == null) {
                if (this.hf == null) {
                    return (GrammaticalStructure)this.con.newInstance(t);
                }
                return (GrammaticalStructure)this.con.newInstance(t, this.hf);
            }
            if (this.hf == null) {
                return (GrammaticalStructure)this.con.newInstance(t, this.puncFilter);
            }
            return (GrammaticalStructure)this.con.newInstance(t, this.puncFilter, this.hf);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate " + this.con.getDeclaringClass().getName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(this.con.getDeclaringClass().getName() + "(Tree t) does not have public access");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

