/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraph;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;

public abstract class GrammaticalStructure
extends TreeGraph {
    protected Set<Dependency> dependencies = null;
    protected List<TypedDependency> typedDependencies = null;
    protected List<TypedDependency> allTypedDependencies = null;
    private static final long serialVersionUID = 2286294455343892678L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrammaticalStructure(Tree t, Collection<GrammaticalRelation> relations, Lock relationsLock, HeadFinder hf, Filter<String> puncFilter) {
        super(t);
        this.root.percolateHeads(hf);
        NoPunctFilter puncDepFilter = new NoPunctFilter(puncFilter);
        NoPunctTypedDependencyFilter puncTypedDepFilter = new NoPunctTypedDependencyFilter(puncFilter);
        this.dependencies = this.root.dependencies(puncDepFilter);
        for (Dependency p : this.dependencies) {
            TreeGraphNode gov = (TreeGraphNode)p.governor();
            TreeGraphNode dep = (TreeGraphNode)p.dependent();
            dep.addArc(GrammaticalRelation.getAnnotationClass(GrammaticalRelation.GOVERNOR), gov);
        }
        if (relationsLock != null) {
            relationsLock.lock();
        }
        try {
            GrammaticalStructure.analyzeNode(this.root, this.root, relations);
        }
        finally {
            if (relationsLock != null) {
                relationsLock.unlock();
            }
        }
        this.typedDependencies = this.getDeps(false, puncTypedDepFilter);
        this.allTypedDependencies = this.getDeps(true, puncTypedDepFilter);
    }

    public GrammaticalStructure(Tree t, Collection<GrammaticalRelation> relations, HeadFinder hf, Filter<String> puncFilter) {
        this(t, relations, null, hf, puncFilter);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        return sb.toString();
    }

    private static void analyzeNode(TreeGraphNode t, TreeGraphNode root, Collection<GrammaticalRelation> relations) {
        if (t.numChildren() > 0) {
            TreeGraphNode tHigh = t.highestNodeWithSameHead();
            for (GrammaticalRelation egr : relations) {
                if (!egr.isApplicable(t)) continue;
                for (Tree u : egr.getRelatedNodes(t, root)) {
                    tHigh.addArc(GrammaticalRelation.getAnnotationClass(egr), (TreeGraphNode)u);
                }
            }
            for (TreeGraphNode kid : t.children()) {
                GrammaticalStructure.analyzeNode(kid, root, relations);
            }
        }
    }

    private List<TypedDependency> getDeps(boolean getExtra, Filter<TypedDependency> f) {
        ArrayList<TypedDependency> basicDep = Generics.newArrayList();
        for (Dependency d : this.dependencies()) {
            TreeGraphNode gov = (TreeGraphNode)d.governor();
            TreeGraphNode dep = (TreeGraphNode)d.dependent();
            GrammaticalRelation reln = this.getGrammaticalRelation(gov, dep);
            basicDep.add(new TypedDependency(reln, gov, dep));
        }
        if (getExtra) {
            TreeGraphNode root = this.root();
            this.getDep(root, root, basicDep, f);
        }
        Collections.sort(basicDep);
        return basicDep;
    }

    private void getDep(TreeGraphNode t, TreeGraphNode root, List<TypedDependency> basicDep, Filter<TypedDependency> f) {
        if (t.numChildren() > 0) {
            Map<Class<? extends CoreAnnotation>, Object> depMap = this.getAllDependents(t);
            for (Class<? extends CoreAnnotation> depName : depMap.keySet()) {
                for (Object depNode : (HashSet)depMap.get(depName)) {
                    List<GrammaticalRelation> rels;
                    TreeGraphNode dep;
                    TreeGraphNode gov = t.headWordNode();
                    if (gov == (dep = ((TreeGraphNode)depNode).headWordNode()) || (rels = GrammaticalStructure.getListGrammaticalRelation(t, (TreeGraphNode)depNode)).isEmpty()) continue;
                    for (GrammaticalRelation rel : rels) {
                        TypedDependency newDep = new TypedDependency(rel, gov, dep);
                        if (basicDep.contains(newDep) || !f.accept(newDep)) continue;
                        basicDep.add(newDep);
                    }
                }
            }
            for (TreeGraphNode kid : t.children()) {
                this.getDep(kid, root, basicDep, f);
            }
        }
    }

    public Set<Dependency> dependencies() {
        return this.dependencies;
    }

    public Set<TreeGraphNode> getDependents(TreeGraphNode t) {
        TreeSet<TreeGraphNode> deps = Generics.newTreeSet();
        Set<Tree> nodes = this.root.subTrees();
        for (TreeGraphNode treeGraphNode : nodes) {
            TreeGraphNode gov = GrammaticalStructure.getGovernor(treeGraphNode);
            if (gov == null || gov != t) continue;
            deps.add(treeGraphNode);
        }
        return deps;
    }

    public static TreeGraphNode getGovernor(TreeGraphNode t) {
        return GrammaticalStructure.getNodeInRelation(t, GrammaticalRelation.GOVERNOR);
    }

    public static TreeGraphNode getNodeInRelation(TreeGraphNode t, GrammaticalRelation r) {
        return t.followArcToNode(GrammaticalRelation.getAnnotationClass(r));
    }

    public GrammaticalRelation getGrammaticalRelation(int govIndex, int depIndex) {
        TreeGraphNode gov = this.getNodeByIndex(govIndex);
        TreeGraphNode dep = this.getNodeByIndex(depIndex);
        return this.getGrammaticalRelation(gov, dep);
    }

    public GrammaticalRelation getGrammaticalRelation(TreeGraphNode gov, TreeGraphNode dep) {
        GrammaticalRelation reln = GrammaticalRelation.DEPENDENT;
        TreeGraphNode govH = gov.highestNodeWithSameHead();
        TreeGraphNode depH = dep.highestNodeWithSameHead();
        Set<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>> arcLabels = govH.arcLabelsToNode(depH);
        for (Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation> arcLabel : arcLabels) {
            GrammaticalRelation reln2;
            if (arcLabel == null) continue;
            try {
                reln2 = GrammaticalRelation.getRelation(arcLabel);
            }
            catch (Exception e) {
                continue;
            }
            if (!reln.isAncestor(reln2)) continue;
            reln = reln2;
        }
        return reln;
    }

    public static List<GrammaticalRelation> getListGrammaticalRelation(TreeGraphNode gov, TreeGraphNode dep) {
        ArrayList<GrammaticalRelation> list = new ArrayList<GrammaticalRelation>();
        TreeGraphNode govH = gov.highestNodeWithSameHead();
        TreeGraphNode depH = dep.highestNodeWithSameHead();
        Set<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>> arcLabels = govH.arcLabelsToNode(depH);
        if (dep != depH) {
            Set<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>> arcLabels2 = govH.arcLabelsToNode(dep);
            arcLabels.addAll(arcLabels2);
        }
        for (Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation> arcLabel : arcLabels) {
            if (arcLabel == null) continue;
            GrammaticalRelation reln2 = GrammaticalRelation.getRelation(arcLabel);
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    GrammaticalRelation gr = (GrammaticalRelation)list.get(i);
                    if (gr.isAncestor(reln2)) {
                        int index = list.indexOf(gr);
                        list.set(index, reln2);
                        continue;
                    }
                    if (reln2.isAncestor(gr)) continue;
                    list.add(reln2);
                }
                continue;
            }
            list.add(reln2);
        }
        return list;
    }

    public Collection<TypedDependency> typedDependencies() {
        return this.typedDependencies(false);
    }

    public Collection<TypedDependency> allTypedDependencies() {
        return this.typedDependencies(true);
    }

    public List<TypedDependency> typedDependencies(boolean includeExtras) {
        List<TypedDependency> dependencies = includeExtras ? this.allTypedDependencies : this.typedDependencies;
        this.correctDependencies(dependencies);
        return dependencies;
    }

    public Collection<TypedDependency> typedDependenciesCollapsed() {
        return this.typedDependenciesCollapsed(false);
    }

    public Collection<TypedDependency> typedDependenciesCollapsedTree() {
        List<TypedDependency> tdl = this.typedDependencies(false);
        this.collapseDependenciesTree(tdl);
        return tdl;
    }

    public List<TypedDependency> typedDependenciesCollapsed(boolean includeExtras) {
        List<TypedDependency> tdl = this.typedDependencies(includeExtras);
        this.collapseDependencies(tdl, false);
        return tdl;
    }

    public List<TypedDependency> typedDependenciesCCprocessed(boolean includeExtras) {
        List<TypedDependency> tdl = this.typedDependencies(includeExtras);
        this.collapseDependencies(tdl, true);
        return tdl;
    }

    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess) {
    }

    protected void collapseDependenciesTree(List<TypedDependency> list) {
    }

    protected void correctDependencies(Collection<TypedDependency> list) {
    }

    public List<String> getDependencyPath(int nodeIndex, int rootIndex) {
        TreeGraphNode node = this.getNodeByIndex(nodeIndex);
        TreeGraphNode root = this.getNodeByIndex(rootIndex);
        return this.getDependencyPath(node, root);
    }

    public List<String> getDependencyPath(TreeGraphNode node, TreeGraphNode root) {
        ArrayList<String> path = new ArrayList<String>();
        while (!node.equals(root)) {
            TreeGraphNode gov = GrammaticalStructure.getGovernor(node);
            System.out.println("Governor for \"" + node.value() + "\": \"" + gov.value() + "\"");
            List<GrammaticalRelation> relations = GrammaticalStructure.getListGrammaticalRelation(gov, node);
            StringBuilder sb = new StringBuilder();
            for (GrammaticalRelation relation : relations) {
                sb.append(sb.length() == 0 ? "" : "+").append(relation.toString());
            }
            path.add(sb.toString());
            node = gov;
        }
        return path;
    }

    private Map<Class<? extends CoreAnnotation>, Object> getAllDependents(TreeGraphNode node) {
        HashMap<Class<? extends CoreAnnotation>, Object> newMap = Generics.newHashMap();
        for (Class<?> o : node.label.keySet()) {
            try {
                o.asSubclass(GrammaticalRelation.GrammaticalRelationAnnotation.class);
                newMap.put(o, node.label.get(o));
            }
            catch (Exception e) {}
        }
        return newMap;
    }

    public boolean isConnected(Collection<TypedDependency> list) {
        return this.getRoots(list).size() <= 1;
    }

    public Collection<TypedDependency> getRoots(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> roots = new ArrayList<TypedDependency>();
        HashSet<TreeGraphNode> deps = new HashSet<TreeGraphNode>();
        for (TypedDependency typedDep : list) {
            deps.add(typedDep.dep());
        }
        HashSet<TreeGraphNode> govs = new HashSet<TreeGraphNode>();
        for (TypedDependency typedDep : list) {
            TreeGraphNode gov = typedDep.gov();
            if (!deps.contains(gov) && !govs.contains(gov)) {
                roots.add(typedDep);
            }
            govs.add(gov);
        }
        return roots;
    }

    private static class NoPunctTypedDependencyFilter
    implements Filter<TypedDependency> {
        private Filter<String> npf;
        private static final long serialVersionUID = -2872766864289207468L;

        NoPunctTypedDependencyFilter(Filter<String> f) {
            this.npf = f;
        }

        @Override
        public boolean accept(TypedDependency d) {
            if (d == null) {
                return false;
            }
            TreeGraphNode s = d.dep();
            if (s == null) {
                return false;
            }
            CyclicCoreLabel l = s.label();
            if (l == null) {
                return false;
            }
            return this.npf.accept(l.value());
        }
    }

    private static class NoPunctFilter
    implements Filter<Dependency> {
        private Filter<String> npf;
        private static final long serialVersionUID = -2319891944796663180L;

        NoPunctFilter(Filter<String> f) {
            this.npf = f;
        }

        @Override
        public boolean accept(Dependency d) {
            if (d == null) {
                return false;
            }
            Label lab = d.dependent();
            if (lab == null) {
                return false;
            }
            return this.npf.accept(lab.value());
        }
    }
}

