/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.trees.CoordinationTransformer;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class EnglishGrammaticalStructure
extends GrammaticalStructure {
    private static final long serialVersionUID = -1866362375001969402L;
    public static final String CONJ_MARKER = "conj_";
    public static final String DEFAULT_PARSER_FILE = "/u/nlp/data/lexparser/englishPCFG.ser.gz";
    private static final boolean DEBUG = false;
    private static String[][] MULTIWORD_PREPS = new String[][]{{"according", "to"}, {"across", "from"}, {"ahead", "of"}, {"such", "as"}, {"along", "with"}, {"due", "to"}, {"alongside", "of"}, {"apart", "from"}, {"as", "of"}, {"as", "to"}, {"away", "from"}, {"based", "on"}, {"because", "of"}, {"close", "by"}, {"close", "to"}, {"due", "to"}, {"compared", "to"}, {"compared", "with"}, {"depending", "on"}, {"followed", "by"}, {"inside", "of"}, {"instead", "of"}, {"next", "to"}, {"near", "to"}, {"out", "of"}, {"outside", "of"}, {"prior", "to"}, {"together", "with"}};

    public EnglishGrammaticalStructure(Tree t) {
        this(t, false);
    }

    public EnglishGrammaticalStructure(Tree t, boolean threadSafe) {
        this(t, new PennTreebankLanguagePack().punctuationWordRejectFilter(), threadSafe);
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter) {
        this(t, puncFilter, (HeadFinder)new SemanticHeadFinder(true), false);
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter, boolean threadSafe) {
        this(t, puncFilter, (HeadFinder)new SemanticHeadFinder(true), threadSafe);
    }

    public EnglishGrammaticalStructure(Tree t, HeadFinder hf) {
        this(t, null, hf, false);
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter, HeadFinder hf) {
        this(t, puncFilter, hf, false);
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter, HeadFinder hf, boolean threadSafe) {
        super(new CoordinationTransformer().transformTree(t), EnglishGrammaticalRelations.values(threadSafe), threadSafe ? EnglishGrammaticalRelations.valuesLock() : null, hf, puncFilter);
    }

    public static TreeGraphNode getSubject(TreeGraphNode t) {
        TreeGraphNode subj = EnglishGrammaticalStructure.getNodeInRelation(t, EnglishGrammaticalRelations.NOMINAL_SUBJECT);
        if (subj != null) {
            return subj;
        }
        subj = EnglishGrammaticalStructure.getNodeInRelation(t, EnglishGrammaticalRelations.CLAUSAL_SUBJECT);
        if (subj != null) {
            return subj;
        }
        return EnglishGrammaticalStructure.getNodeInRelation(t, EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT);
    }

    @Override
    protected void correctDependencies(Collection<TypedDependency> list) {
        EnglishGrammaticalStructure.correctSubjPassAndPoss(list);
    }

    private static void printListSorted(String title, Collection<TypedDependency> list) {
        ArrayList<TypedDependency> lis = new ArrayList<TypedDependency>(list);
        Collections.sort(lis);
        if (title != null) {
            System.err.println(title);
        }
        System.err.println(lis);
    }

    @Override
    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess) {
        this.correctDependencies(list);
        EnglishGrammaticalStructure.eraseMultiConj(list);
        EnglishGrammaticalStructure.collapseMWP(list);
        EnglishGrammaticalStructure.collapseFlatMWP(list);
        EnglishGrammaticalStructure.collapsePrepAndPoss(list);
        EnglishGrammaticalStructure.collapseConj(list);
        if (CCprocess) {
            EnglishGrammaticalStructure.treatCC(list);
        }
        EnglishGrammaticalStructure.collapseReferent(list);
        Collections.sort(list);
    }

    @Override
    protected void collapseDependenciesTree(List<TypedDependency> list) {
        this.correctDependencies(list);
        EnglishGrammaticalStructure.eraseMultiConj(list);
        EnglishGrammaticalStructure.collapseMWP(list);
        EnglishGrammaticalStructure.collapseFlatMWP(list);
        EnglishGrammaticalStructure.collapsePrepAndPoss(list);
        EnglishGrammaticalStructure.collapseConj(list);
        Collections.sort(list);
    }

    protected static GrammaticalRelation conjValue(Object conj) {
        String newConj = conj.toString().toLowerCase();
        if (conj.toString().equals("not") || conj.toString().equals("instead") || conj.toString().equals("rather")) {
            newConj = "negcc";
        } else if (conj.toString().equals("to") || conj.toString().equals("also") || conj.toString().contains("well")) {
            newConj = "and";
        }
        return EnglishGrammaticalRelations.getConj(newConj);
    }

    private static void treatCC(Collection<TypedDependency> list) {
        HashMap map = new HashMap();
        HashMap<TreeGraphNode, TypedDependency> subjectMap = new HashMap<TreeGraphNode, TypedDependency>();
        HashMap<TreeGraphNode, TypedDependency> objectMap = new HashMap<TreeGraphNode, TypedDependency>();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.dep())) {
                map.put(typedDep.dep(), new TreeSet());
            }
            ((Set)map.get(typedDep.dep())).add(typedDep);
            if (!(typedDep.reln().getParent() != EnglishGrammaticalRelations.NOMINAL_SUBJECT && typedDep.reln().getParent() != EnglishGrammaticalRelations.SUBJECT && typedDep.reln().getParent() != EnglishGrammaticalRelations.CLAUSAL_SUBJECT || subjectMap.containsKey(typedDep.gov()))) {
                subjectMap.put(typedDep.gov(), typedDep);
            }
            if (typedDep.reln() != EnglishGrammaticalRelations.DIRECT_OBJECT || objectMap.containsKey(typedDep.gov())) continue;
            objectMap.put(typedDep.gov(), typedDep);
        }
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>(list);
        for (TypedDependency td : list) {
            if (!EnglishGrammaticalRelations.getConjs().contains(td.reln())) continue;
            TreeGraphNode gov = td.gov();
            TreeGraphNode dep = td.dep();
            Set gov_relations = (Set)map.get(gov);
            if (gov_relations != null) {
                for (TypedDependency td1 : gov_relations) {
                    TreeGraphNode newGov = td1.gov();
                    GrammaticalRelation newRel = td1.reln();
                    newTypedDeps.add(new TypedDependency(newRel, newGov, dep));
                }
            }
            if (subjectMap.containsKey(gov) && (dep.parent().value().startsWith("VB") || dep.parent().value().startsWith("JJ")) && !subjectMap.containsKey(dep)) {
                TypedDependency tdsubj = (TypedDependency)subjectMap.get(gov);
                GrammaticalRelation relation = tdsubj.reln();
                if (relation == EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT && (dep.parent().value().equals("VB") || dep.parent().value().startsWith("JJ"))) {
                    relation = EnglishGrammaticalRelations.NOMINAL_SUBJECT;
                }
                if (relation == EnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT && (dep.parent().value().equals("VB") || dep.parent().value().startsWith("JJ"))) {
                    relation = EnglishGrammaticalRelations.CLAUSAL_SUBJECT;
                }
                newTypedDeps.add(new TypedDependency(relation, dep, tdsubj.dep()));
            }
            if (!objectMap.containsKey(gov) || !dep.parent().value().startsWith("VB") || objectMap.containsKey(dep)) continue;
            TypedDependency tdobj = (TypedDependency)objectMap.get(gov);
            newTypedDeps.add(new TypedDependency(tdobj.reln(), dep, tdobj.dep()));
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static void collapseConj(Collection<TypedDependency> list) {
        for (TypedDependency td : list) {
            if (td.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
            TreeGraphNode gov = td.gov();
            GrammaticalRelation conj = EnglishGrammaticalStructure.conjValue(td.dep().value());
            for (TypedDependency td1 : list) {
                if (td1.reln() == EnglishGrammaticalRelations.CONJUNCT && td1.gov() == gov) {
                    td1.setReln(conj);
                    continue;
                }
                if (td1.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
                conj = EnglishGrammaticalStructure.conjValue(td1.dep().value());
            }
        }
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (TypedDependency td : list) {
            if (td.reln() == EnglishGrammaticalRelations.COORDINATION) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static void collapseReferent(Collection<TypedDependency> list) {
        ArrayList<Pair<TreeGraphNode, TreeGraphNode>> refs = new ArrayList<Pair<TreeGraphNode, TreeGraphNode>>();
        for (TypedDependency typedDependency : list) {
            if (typedDependency.reln() != EnglishGrammaticalRelations.REFERENT) continue;
            Pair<TreeGraphNode, TreeGraphNode> ref = new Pair<TreeGraphNode, TreeGraphNode>(typedDependency.dep(), typedDependency.gov());
            refs.add(ref);
        }
        for (Pair pair : refs) {
            TreeGraphNode dep = (TreeGraphNode)pair.first();
            TreeGraphNode ant = (TreeGraphNode)pair.second();
            for (TypedDependency td : list) {
                if (td.dep() != dep || td.reln() == EnglishGrammaticalRelations.RELATIVE) continue;
                td.setDep(ant);
            }
        }
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (TypedDependency td : list) {
            if (td.reln() == EnglishGrammaticalRelations.REFERENT) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static void correctSubjPassAndPoss(Collection<TypedDependency> list) {
        ArrayList<TreeGraphNode> list_auxpass = new ArrayList<TreeGraphNode>();
        for (TypedDependency td : list) {
            if (td.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
            list_auxpass.add(td.gov());
        }
        for (TypedDependency td : list) {
            if (td.reln() == EnglishGrammaticalRelations.NOMINAL_SUBJECT && list_auxpass.contains(td.gov())) {
                td.setReln(EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT);
            }
            if (td.reln() == EnglishGrammaticalRelations.CLAUSAL_SUBJECT && list_auxpass.contains(td.gov())) {
                td.setReln(EnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT);
            }
            String tag = td.dep().parent().value();
            if (td.reln() != GrammaticalRelation.DEPENDENT || !tag.equals("PRP$") && !tag.equals("WP$")) continue;
            td.setReln(EnglishGrammaticalRelations.POSSESSION_MODIFIER);
        }
    }

    private static void collapsePrepAndPoss(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        HashMap map = new HashMap();
        ArrayList<TreeGraphNode> partmod = new ArrayList<TreeGraphNode>();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.gov())) {
                map.put(typedDep.gov(), new TreeSet());
            }
            ((SortedSet)map.get(typedDep.gov())).add(typedDep);
            if (typedDep.reln() != EnglishGrammaticalRelations.PARTICIPIAL_MODIFIER) continue;
            partmod.add(typedDep.dep());
        }
        for (TypedDependency td1 : list) {
            TypedDependency tdNew;
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            TreeGraphNode td1Dep = td1.dep();
            String td1DepPOS = td1Dep.parent().value();
            SortedSet possibles = (SortedSet)map.get(td1Dep);
            if (possibles == null) continue;
            TypedDependency prepDep = null;
            TypedDependency ccDep = null;
            TypedDependency conjDep = null;
            TypedDependency prep2Dep = null;
            TypedDependency prepOtherDep = null;
            TreeSet<TypedDependency> otherDtrs = new TreeSet<TypedDependency>();
            boolean pobj = true;
            for (TypedDependency td2 : possibles) {
                String td3DepPOS;
                TreeGraphNode td3Dep;
                Set possibles2;
                if (td2.reln() != EnglishGrammaticalRelations.CONJUNCT) continue;
                TreeGraphNode td2Dep = td2.dep();
                String td2DepPOS = td2Dep.parent().value();
                if ((td2DepPOS.equals("IN") || td2DepPOS.equals("TO")) && td2Dep.value().equals(td1Dep.value())) {
                    conjDep = td2;
                    possibles2 = (Set)map.get(td2Dep);
                    if (possibles2 == null) continue;
                    for (TypedDependency td3 : possibles2) {
                        td3Dep = td3.dep();
                        td3DepPOS = td3Dep.parent().value();
                        if (!(td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || prep2Dep != null || td3DepPOS.equals("RB") || td3DepPOS.equals("IN") || td3DepPOS.equals("TO"))) {
                            prep2Dep = td3;
                            if (td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                            pobj = false;
                            continue;
                        }
                        otherDtrs.add(td3);
                    }
                    continue;
                }
                if (!td2DepPOS.equals("IN") && !td2DepPOS.equals("TO")) continue;
                conjDep = td2;
                possibles2 = (Set)map.get(td2Dep);
                if (possibles2 == null) continue;
                for (TypedDependency td3 : possibles2) {
                    td3Dep = td3.dep();
                    td3DepPOS = td3Dep.parent().value();
                    if (!(td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || prepOtherDep != null || td3DepPOS.equals("RB") || td3DepPOS.equals("IN") || td3DepPOS.equals("TO"))) {
                        prepOtherDep = td3;
                        if (td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                        pobj = false;
                        continue;
                    }
                    otherDtrs.add(td3);
                }
            }
            if (conjDep != null) {
                int index = conjDep.dep().index();
                for (TypedDependency td2 : possibles) {
                    if (td2.reln() == EnglishGrammaticalRelations.COORDINATION && td2.dep().index() < index) {
                        ccDep = td2;
                        continue;
                    }
                    TreeGraphNode td2Dep = td2.dep();
                    String td2DepPOS = td2Dep.parent().value();
                    if (!(td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.RELATIVE || td2.reln() != GrammaticalRelation.DEPENDENT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !td1DepPOS.equals("IN") && !td1DepPOS.equals("TO") && !td1DepPOS.equals("VBG") || prepDep != null || td2DepPOS.equals("RB") || td2DepPOS.equals("IN") || td2DepPOS.equals("TO") || td2.dep().index() >= index)) {
                        prepDep = td2;
                        if (td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                        pobj = false;
                        continue;
                    }
                    if (td2 == conjDep) continue;
                    otherDtrs.add(td2);
                }
            }
            if (prepDep != null && ccDep != null && conjDep != null && prep2Dep != null) {
                TypedDependency tdNew2;
                boolean agent = false;
                if (td1Dep.value().equals("by")) {
                    Set aux_pass_poss = (Set)map.get(td1.gov());
                    if (aux_pass_poss != null) {
                        for (TypedDependency td_pass : aux_pass_poss) {
                            if (td_pass.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
                            agent = true;
                        }
                    }
                    if (!partmod.isEmpty() && partmod.contains(td1.gov())) {
                        agent = true;
                    }
                }
                if (agent) {
                    tdNew2 = new TypedDependency(EnglishGrammaticalRelations.AGENT, td1.gov(), prepDep.dep());
                    agent = false;
                } else {
                    GrammaticalRelation reln = td1.reln() == EnglishGrammaticalRelations.RELATIVE ? EnglishGrammaticalRelations.RELATIVE : (pobj ? EnglishGrammaticalRelations.getPrep(td1Dep.value().toLowerCase()) : EnglishGrammaticalRelations.getPrepC(td1Dep.value().toLowerCase()));
                    tdNew2 = new TypedDependency(reln, td1.gov(), prepDep.dep());
                }
                newTypedDeps.add(tdNew2);
                TypedDependency tdNew22 = new TypedDependency(EnglishGrammaticalStructure.conjValue(ccDep.dep().value()), prepDep.dep(), prep2Dep.dep());
                newTypedDeps.add(tdNew22);
                td1.setReln(GrammaticalRelation.KILL);
                prepDep.setReln(GrammaticalRelation.KILL);
                ccDep.setReln(GrammaticalRelation.KILL);
                conjDep.setReln(GrammaticalRelation.KILL);
                prep2Dep.setReln(GrammaticalRelation.KILL);
                for (TypedDependency otd : otherDtrs) {
                    if (otd.dep().parent().value().equals("IN")) {
                        otd.setReln(EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER);
                    }
                    otd.setGov(td1.gov());
                }
            }
            if (prepDep == null || ccDep == null || conjDep == null || prepOtherDep == null) continue;
            TreeGraphNode copy = new TreeGraphNode(td1.gov());
            CyclicCoreLabel label = new CyclicCoreLabel(td1.gov().label());
            label.set(CoreAnnotations.CopyAnnotation.class, true);
            copy.setLabel(label);
            boolean agent = false;
            if (td1Dep.value().equals("by")) {
                Set aux_pass_poss = (Set)map.get(td1.gov());
                if (aux_pass_poss != null) {
                    for (TypedDependency td_pass : aux_pass_poss) {
                        if (td_pass.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
                        agent = true;
                    }
                }
                if (!partmod.isEmpty() && partmod.contains(td1.gov())) {
                    agent = true;
                }
            }
            if (agent) {
                tdNew = new TypedDependency(EnglishGrammaticalRelations.AGENT, td1.gov(), prepDep.dep());
                agent = false;
            } else {
                GrammaticalRelation reln = td1.reln() == EnglishGrammaticalRelations.RELATIVE ? EnglishGrammaticalRelations.RELATIVE : (pobj ? EnglishGrammaticalRelations.getPrep(td1Dep.value().toLowerCase()) : EnglishGrammaticalRelations.getPrepC(td1Dep.value().toLowerCase()));
                tdNew = new TypedDependency(reln, td1.gov(), prepDep.dep());
            }
            newTypedDeps.add(tdNew);
            TypedDependency tdNew2 = new TypedDependency(EnglishGrammaticalStructure.conjValue(ccDep.dep().value()), td1.gov(), copy);
            newTypedDeps.add(tdNew2);
            GrammaticalRelation reln = td1.reln() == EnglishGrammaticalRelations.RELATIVE ? EnglishGrammaticalRelations.RELATIVE : (pobj ? EnglishGrammaticalRelations.getPrep(prepOtherDep.gov().value().toLowerCase()) : EnglishGrammaticalRelations.getPrepC(prepOtherDep.gov().value().toLowerCase()));
            TypedDependency tdNew3 = new TypedDependency(reln, copy, prepOtherDep.dep());
            newTypedDeps.add(tdNew3);
            td1.setReln(GrammaticalRelation.KILL);
            prepDep.setReln(GrammaticalRelation.KILL);
            ccDep.setReln(GrammaticalRelation.KILL);
            conjDep.setReln(GrammaticalRelation.KILL);
            prepOtherDep.setReln(GrammaticalRelation.KILL);
            for (TypedDependency otd : otherDtrs) {
                if (otd.dep().parent().value().equals("IN")) {
                    otd.setReln(EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER);
                }
                otd.setGov(td1.gov());
            }
        }
        for (TypedDependency td1 : list) {
            boolean agent = false;
            boolean pobj = true;
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            TreeGraphNode td1Dep = td1.dep();
            String td1DepPOS = td1Dep.parent().value();
            Set possibles = (Set)map.get(td1Dep);
            if (possibles == null) continue;
            for (TypedDependency td2 : possibles) {
                TypedDependency td3;
                if (td2.reln() == EnglishGrammaticalRelations.COORDINATION || td2.reln() == EnglishGrammaticalRelations.CONJUNCT) continue;
                TreeGraphNode td2Dep = td2.dep();
                String td2DepPOS = td2Dep.parent().value();
                if (td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.RELATIVE || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !td1DepPOS.equals("IN") && !td1DepPOS.equals("TO") && !td1DepPOS.equals("VBG") || td2DepPOS.equals("RB") || td2DepPOS.equals("IN") || td2DepPOS.equals("TO") || EnglishGrammaticalStructure.isConjWithNoPrep(td2.gov(), possibles)) continue;
                if (td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) {
                    pobj = false;
                }
                if (td1Dep.value().equals("by")) {
                    Set aux_pass_poss = (Set)map.get(td1.gov());
                    if (aux_pass_poss != null) {
                        for (TypedDependency td_pass : aux_pass_poss) {
                            if (td_pass.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
                            agent = true;
                        }
                    }
                    if (!partmod.isEmpty() && partmod.contains(td1.gov())) {
                        agent = true;
                    }
                }
                if (agent) {
                    td3 = new TypedDependency(EnglishGrammaticalRelations.AGENT, td1.gov(), td2.dep());
                    agent = false;
                } else {
                    GrammaticalRelation reln = td1.reln() == EnglishGrammaticalRelations.RELATIVE ? EnglishGrammaticalRelations.RELATIVE : (pobj ? EnglishGrammaticalRelations.getPrep(td1Dep.value().toLowerCase()) : EnglishGrammaticalRelations.getPrepC(td1Dep.value().toLowerCase()));
                    td3 = new TypedDependency(reln, td1.gov(), td2.dep());
                }
                newTypedDeps.add(td3);
                td1.setReln(GrammaticalRelation.KILL);
                td2.setReln(GrammaticalRelation.KILL);
            }
            if (td1.reln() != GrammaticalRelation.KILL) continue;
            for (TypedDependency td2 : possibles) {
                if (td2.reln() == GrammaticalRelation.KILL || td2.reln() == EnglishGrammaticalRelations.COORDINATION || td2.reln() == EnglishGrammaticalRelations.CONJUNCT) continue;
                td2.setGov(td1.gov());
            }
        }
        for (TypedDependency td : list) {
            boolean keep = true;
            if (td.reln() == GrammaticalRelation.KILL) {
                keep = false;
            } else if (td.reln() == EnglishGrammaticalRelations.POSSESSIVE_MODIFIER) {
                keep = false;
                TreeGraphNode dep = td.dep();
                for (TypedDependency typedD : list) {
                    if (!typedD.gov().equals(dep)) continue;
                    keep = true;
                    break;
                }
            }
            if (!keep) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static boolean isConjWithNoPrep(TreeGraphNode node, Collection<TypedDependency> list) {
        for (TypedDependency td : list) {
            String tdDepPOS;
            if (td.gov() != node || td.reln() != EnglishGrammaticalRelations.CONJUNCT || (tdDepPOS = td.dep().parent().value()).equals("IN") || tdDepPOS.equals("TO")) continue;
            return true;
        }
        return false;
    }

    private static void collapseMultiwordPreps(List<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = Generics.newArrayList();
        for (String[] mwp : MULTIWORD_PREPS) {
            for (TypedDependency td1 : list) {
                if (!td1.dep().value().equalsIgnoreCase(mwp[0])) continue;
                for (TypedDependency td2 : list) {
                    GrammaticalRelation gr;
                    if (td2.gov() != td1.dep() && td2.gov() != td1.gov() || td2.reln().getSpecific() == null || !td2.reln().getSpecific().equals(mwp[1])) continue;
                    if (td2.reln().getShortName().startsWith("prep_")) {
                        gr = EnglishGrammaticalRelations.getPrep(mwp[0] + "_" + mwp[1]);
                        newTypedDeps.add(new TypedDependency(gr, td1.gov(), td2.dep()));
                    } else if (td2.reln().getShortName().startsWith("prepc_")) {
                        gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + "_" + mwp[1]);
                        newTypedDeps.add(new TypedDependency(gr, td1.gov(), td2.dep()));
                    }
                    td1.setReln(GrammaticalRelation.KILL);
                    td2.setReln(GrammaticalRelation.KILL);
                }
            }
        }
        for (TypedDependency td : list) {
            if (td.reln() == GrammaticalRelation.KILL) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static void collapseMWP(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            TreeGraphNode mwp0 = null;
            TreeGraphNode mwp1 = null;
            TreeGraphNode governor = null;
            TypedDependency prep = null;
            TypedDependency dep = null;
            TypedDependency pobj = null;
            for (TypedDependency td : list) {
                if (!td.gov().value().equalsIgnoreCase(mwp[0]) || !td.dep().value().equalsIgnoreCase(mwp[1]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp0 = td.gov();
                mwp1 = td.dep();
                dep = td;
            }
            for (TypedDependency td1 : list) {
                if (td1.dep() != mwp0 || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                prep = td1;
                governor = prep.gov();
            }
            for (TypedDependency td2 : list) {
                GrammaticalRelation gr;
                if (td2.gov() == mwp1 && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + "_" + mwp[1]);
                    newTypedDeps.add(new TypedDependency(gr, governor, pobj.dep()));
                }
                if (td2.gov() != mwp1 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + "_" + mwp[1]);
                newTypedDeps.add(new TypedDependency(gr, governor, pobj.dep()));
            }
            if (prep == null || dep == null || pobj == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void collapseFlatMWP(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            TreeGraphNode mwp1 = null;
            TreeGraphNode governor = null;
            TypedDependency prep = null;
            TypedDependency dep = null;
            TypedDependency pobj = null;
            for (TypedDependency td : list) {
                if (!td.gov().value().equalsIgnoreCase(mwp[1]) || !td.dep().value().equalsIgnoreCase(mwp[0]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp1 = td.gov();
                dep = td;
            }
            for (TypedDependency td1 : list) {
                if (td1.dep() != mwp1 || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                prep = td1;
                governor = prep.gov();
            }
            for (TypedDependency td2 : list) {
                GrammaticalRelation gr;
                if (td2.gov() == mwp1 && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + "_" + mwp[1]);
                    newTypedDeps.add(new TypedDependency(gr, governor, pobj.dep()));
                }
                if (td2.gov() != mwp1 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + "_" + mwp[1]);
                newTypedDeps.add(new TypedDependency(gr, governor, pobj.dep()));
            }
            if (prep == null || dep == null || pobj == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov() == mwp1) {
                    td1.setGov(governor);
                }
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void eraseMultiConj(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (TypedDependency td1 : list) {
            if (td1.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
            TreeGraphNode x = td1.dep();
            for (TypedDependency td2 : list) {
                if (!td2.gov().equals(x) || td2.reln() != GrammaticalRelation.DEPENDENT) continue;
                td2.setReln(GrammaticalRelation.KILL);
            }
        }
        for (TypedDependency td : list) {
            if (td.reln() == GrammaticalRelation.KILL) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    public static void main(String[] args) {
        MemoryTreebank tb = new MemoryTreebank();
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        String sentFileName = props.getProperty("sentFile");
        String fileName = null;
        if (sentFileName == null && treeFileName == null) {
            try {
                System.err.println("Usage: java EnglishGrammaticalStructure [options]* [-sentFile file|-treeFile file] [-testGraph]");
                System.err.println("  options: -basic, -collapsed [the default], -CCprocessed, -collapsedTree, -parseTree, -test; -parserFile file");
                PennTreeReader tr = new PennTreeReader((Reader)new StringReader("((S (NP (NNP Sam)) (VP (VBD died) (NP-TMP (NN today)))))"), new LabeledScoredTreeFactory());
                ((AbstractCollection)tb).add(tr.readTree());
            }
            catch (Exception e) {
                System.err.println("Horrible error: " + e);
                e.printStackTrace();
            }
        } else if (treeFileName != null) {
            fileName = treeFileName;
            tb.loadPath(treeFileName);
        } else {
            fileName = sentFileName;
            String[] opts = new String[]{"-retainTmpSubcategories"};
            String parserFile = props.getProperty("parserFile");
            if (parserFile == null || "".equals(parserFile)) {
                parserFile = DEFAULT_PARSER_FILE;
            }
            LexicalizedParser lp = new LexicalizedParser(parserFile);
            lp.setOptionFlags(opts);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(sentFileName));
            }
            catch (FileNotFoundException e) {
                System.err.println("Cannot find " + sentFileName);
                System.exit(1);
            }
            try {
                String line;
                System.err.println("Processing sentence file " + sentFileName);
                while ((line = reader.readLine()) != null) {
                    PTBTokenizer<Word> ptb = PTBTokenizer.newPTBTokenizer(new StringReader(line));
                    List words = ptb.tokenize();
                    lp.parse(words);
                    Tree parseTree = lp.getBestParse();
                    ((AbstractCollection)tb).add(parseTree);
                }
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("IOexception reading key file " + sentFileName);
                System.exit(1);
            }
        }
        boolean basic = props.getProperty("basic") != null;
        boolean collapsed = props.getProperty("collapsed") != null;
        boolean CCprocessed = props.getProperty("CCprocessed") != null;
        boolean tree = props.getProperty("collapsedTree") != null;
        boolean parseTree = props.getProperty("parseTree") != null;
        boolean test = props.getProperty("test") != null;
        System.err.println("Printing trees and the typed dependencies for file " + fileName);
        for (Tree t : tb) {
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(t);
            if (test) {
                System.out.println("============= parse tree =======================");
                t.pennPrint();
                System.out.println();
                System.out.println("------------- GrammaticalStructure -------------");
                System.out.println(gs);
                System.out.println("------------- basic dependencies ---------------");
                System.out.println(StringUtils.join(gs.typedDependencies(false), "\n"));
                System.out.println("------------- collapsed dependencies -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsed(true), "\n"));
                System.out.println("------------- collapsed dependencies tree -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsedTree(), "\n"));
                System.out.println("------------- CCprocessed dependencies --------");
                System.out.println(StringUtils.join(gs.typedDependenciesCCprocessed(true), "\n"));
                System.out.println("-----------------------------------------------");
                boolean connected = gs.isConnected(gs.typedDependenciesCollapsed(true));
                System.out.println("collapsed dependencies form a connected graph: " + connected);
                if (connected) continue;
                System.out.println("possible offending nodes: " + gs.getRoots(gs.typedDependenciesCollapsed(true)));
                continue;
            }
            if (parseTree) {
                System.out.println("============= parse tree =======================");
                t.pennPrint();
                System.out.println();
            }
            if (basic) {
                if (collapsed || CCprocessed || tree) {
                    System.out.println("------------- basic dependencies ---------------");
                }
                System.out.println(StringUtils.join(gs.typedDependencies(false), "\n"));
                System.out.println();
            }
            if (collapsed) {
                if (basic || CCprocessed || tree) {
                    System.out.println("----------- collapsed dependencies -----------");
                }
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsed(true), "\n"));
                System.out.println();
            }
            if (CCprocessed) {
                if (basic || collapsed || tree) {
                    System.out.println("---------- CCprocessed dependencies ----------");
                }
                System.out.println(StringUtils.join(gs.typedDependenciesCCprocessed(true), "\n"));
                System.out.println();
            }
            if (tree) {
                if (basic || CCprocessed || collapsed) {
                    System.out.println("----------- collapsed dependencies tree-----------");
                }
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsedTree(), "\n"));
                System.out.println();
            }
            if (!(!basic & !collapsed & !CCprocessed & !tree)) continue;
            System.out.println(StringUtils.join(gs.typedDependenciesCollapsed(true), "\n"));
            System.out.println();
        }
    }
}

