/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filter;
import java.util.Comparator;

public class Dependencies {
    private Dependencies() {
    }

    public static Comparator<Dependency> dependencyIndexComparator() {
        return ComparatorHolder.dc;
    }

    private static class ComparatorHolder {
        private static final Comparator<Dependency> dc = new DependencyIdxComparator();

        private ComparatorHolder() {
        }

        private static class DependencyIdxComparator
        implements Comparator<Dependency> {
            private DependencyIdxComparator() {
            }

            @Override
            public int compare(Dependency dep1, Dependency dep2) {
                CoreMap dep1lab = (CoreMap)((Object)dep1.dependent());
                CoreMap dep2lab = (CoreMap)((Object)dep2.dependent());
                int dep1idx = (Integer)dep1lab.get(CoreAnnotations.IndexAnnotation.class);
                int dep2idx = (Integer)dep2lab.get(CoreAnnotations.IndexAnnotation.class);
                return dep1idx - dep2idx;
            }
        }
    }

    public static class DependentPuncWordRejectFilter
    implements Filter<Dependency> {
        private final Filter wordRejectFilter;

        public DependentPuncWordRejectFilter(Filter wrf) {
            this.wordRejectFilter = wrf;
        }

        @Override
        public boolean accept(Dependency d) {
            if (d == null) {
                return false;
            }
            if (!(d.dependent() instanceof HasWord)) {
                return false;
            }
            String word = ((HasWord)((Object)d.dependent())).word();
            return this.wordRejectFilter.accept(word);
        }
    }

    public static class DependentPuncTagRejectFilter
    implements Filter<Dependency> {
        private Filter<String> tagRejectFilter;
        private static final long serialVersionUID = -7732189363171164852L;

        public DependentPuncTagRejectFilter(Filter<String> trf) {
            this.tagRejectFilter = trf;
        }

        @Override
        public boolean accept(Dependency d) {
            if (d == null) {
                return false;
            }
            if (!(d.dependent() instanceof HasTag)) {
                return false;
            }
            String tag = ((HasTag)((Object)d.dependent())).tag();
            return this.tagRejectFilter.accept(tag);
        }
    }
}

