/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.CoordinationTransformer;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.WordNetConnection;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CollocationFinder {
    private static boolean DEBUG = false;
    private final Tree qTree;
    private final HeadFinder hf;
    private final List<Collocation> collocationCollector;
    private final WordNetConnection wnConnect;

    public CollocationFinder(Tree t, WordNetConnection w) {
        this(t, w, new CollinsHeadFinder());
    }

    public CollocationFinder(Tree t, WordNetConnection w, HeadFinder hf) {
        this(t, w, hf, false);
    }

    public CollocationFinder(Tree t, WordNetConnection w, HeadFinder hf, boolean threadSafe) {
        CoordinationTransformer transformer = new CoordinationTransformer();
        this.wnConnect = w;
        this.qTree = transformer.transformTree(t);
        this.collocationCollector = Generics.newArrayList();
        this.hf = hf;
        this.getCollocationsList(threadSafe);
        if (DEBUG) {
            System.err.println("Collected collocations: " + this.collocationCollector);
        }
    }

    public Tree getMangledTree() {
        return this.getMangledTree(this.qTree);
    }

    private Tree getMangledTree(Tree t) {
        Collocation matchingColl = null;
        for (Tree child : t.children()) {
            child = this.getMangledTree(child);
        }
        for (Collocation c : this.collocationCollector) {
            if (!t.equals(c.parentNode) || matchingColl != null && (c.span.first() > matchingColl.span.first() || c.span.second() < matchingColl.span.second())) continue;
            matchingColl = c;
            if (!DEBUG) continue;
            System.err.println("Found matching collocation for tree:");
            t.pennPrint();
            System.err.print("  head label: " + c.headLabel);
            System.err.println("; collocation string: " + c.collocationString);
            System.err.println("  Constituents: " + c.indicesOfConstituentChildren);
        }
        if (matchingColl == null) {
            return t;
        }
        if (DEBUG) {
            System.err.println("Collapsing " + matchingColl);
        }
        Object[] allChildren = t.children();
        StringBuffer mutatedString = new StringBuffer(160);
        for (int i : matchingColl.indicesOfConstituentChildren) {
            String strToAppend = CollocationFinder.mergeLeavesIntoCollocatedString(allChildren[i]);
            mutatedString.append(strToAppend);
            mutatedString.append("_");
        }
        mutatedString = mutatedString.deleteCharAt(mutatedString.length() - 1);
        if (DEBUG) {
            System.err.println("allChildren is: " + Arrays.toString(allChildren));
        }
        for (int index = matchingColl.indicesOfConstituentChildren.size() - 1; index > 0; --index) {
            int thisConstituent = matchingColl.indicesOfConstituentChildren.get(index);
            allChildren = (Tree[])ArrayUtils.removeAt(allChildren, thisConstituent);
            if (!DEBUG) continue;
            System.err.println(" deleted " + thisConstituent + "; allChildren is: " + Arrays.toString(allChildren));
        }
        String newNodeString = mutatedString.toString();
        int firstChildIndex = matchingColl.indicesOfConstituentChildren.get(0);
        Object newCollocationChild = allChildren[firstChildIndex];
        if (DEBUG) {
            System.err.println("Manipulating: " + newCollocationChild);
        }
        ((Tree)newCollocationChild).setValue(matchingColl.headLabel.value());
        Tree newCollocationLeaf = ((Tree)newCollocationChild).treeFactory().newLeaf(newNodeString);
        ((Tree)newCollocationChild).setChildren(Collections.singletonList(newCollocationLeaf));
        if (DEBUG) {
            System.err.println("  changed to: " + newCollocationChild);
        }
        allChildren[firstChildIndex] = newCollocationChild;
        t.setChildren((Tree[])allChildren);
        if (DEBUG) {
            System.err.println("Restructured tree is:");
            t.pennPrint();
            System.err.println();
        }
        return t;
    }

    private void getCollocationsList(boolean threadSafe) {
        this.getCollocationsList(this.qTree, threadSafe);
    }

    public void PrintCollocationStrings(PrintWriter pw) {
        for (Collocation c : this.collocationCollector) {
            String cs = c.collocationString;
            pw.println(cs + " (" + (c.span.first() + 1) + "," + (c.span.second() + 1) + ")");
        }
    }

    private void getCollocationsList(Tree t, boolean threadSafe) {
        int leftMostLeaf = Trees.leftEdge(t, this.qTree);
        if (t.isPreTerminal()) {
            return;
        }
        List<Tree> children = t.getChildrenAsList();
        if (children.isEmpty()) {
            return;
        }
        Label headLabel = this.hf.determineHead(t).label();
        StringBuffer testString = null;
        Integer leftSistersBuffer = 0;
        for (int i = 0; i < children.size(); ++i) {
            ArrayList<Integer> childConstituents = new ArrayList<Integer>();
            childConstituents.add(i);
            Tree subtree = children.get(i);
            Integer currWindowLength = 0;
            this.getCollocationsList(subtree, threadSafe);
            testString = new StringBuffer(160);
            testString.append(CollocationFinder.treeAsStemmedCollocation(subtree, threadSafe));
            testString.append("_");
            Integer thisSubtreeLength = subtree.yield().size();
            currWindowLength = currWindowLength + thisSubtreeLength;
            StringBuffer testStringNonStemmed = new StringBuffer(160);
            testStringNonStemmed.append(CollocationFinder.treeAsNonStemmedCollocation(subtree));
            testStringNonStemmed.append("_");
            for (int j = i + 1; j < children.size(); ++j) {
                Collocation col;
                Pair<Integer, Integer> c;
                Tree sisterNode = children.get(j);
                childConstituents.add(j);
                testString.append(CollocationFinder.treeAsStemmedCollocation(sisterNode, threadSafe));
                testStringNonStemmed.append(CollocationFinder.treeAsNonStemmedCollocation(sisterNode));
                currWindowLength = currWindowLength + sisterNode.yield().size();
                if (DEBUG) {
                    // empty if block
                }
                if (!StringUtils.lookingAt(testString.toString(), "(?:[Tt]he|THE|[Aa][Nn]?)[ _]") && this.wordNetContains(testString.toString())) {
                    c = new Pair<Integer, Integer>(leftMostLeaf + leftSistersBuffer, leftMostLeaf + leftSistersBuffer + currWindowLength - 1);
                    col = new Collocation(c, t, (ArrayList)childConstituents.clone(), testString.toString(), headLabel);
                    this.collocationCollector.add(col);
                    if (DEBUG) {
                        System.err.println("Found collocation in wordnet: " + testString.toString());
                        System.err.println("  Span of collocation is: " + c + "; childConstituents is: " + c);
                    }
                }
                testString.append("_");
                if (!StringUtils.lookingAt(testStringNonStemmed.toString(), "(?:[Tt]he|THE|[Aa][Nn]?)[ _]") && this.wordNetContains(testStringNonStemmed.toString())) {
                    c = new Pair<Integer, Integer>(leftMostLeaf + leftSistersBuffer, leftMostLeaf + leftSistersBuffer + currWindowLength - 1);
                    col = new Collocation(c, t, (ArrayList)childConstituents.clone(), testStringNonStemmed.toString(), headLabel);
                    this.collocationCollector.add(col);
                    if (DEBUG) {
                        System.err.println("Found collocation in wordnet: " + testStringNonStemmed.toString());
                        System.err.println("  Span of collocation is: " + c + "; childConstituents is: " + c);
                    }
                }
                testStringNonStemmed.append("_");
            }
            leftSistersBuffer = leftSistersBuffer + thisSubtreeLength;
        }
    }

    private static String treeAsStemmedCollocation(Tree t, boolean threadSafe) {
        List<WordTag> list = CollocationFinder.getStemmedWordTagsFromTree(t, threadSafe);
        StringBuffer s = new StringBuffer(160);
        WordTag firstWord = list.remove(0);
        s.append(firstWord.word());
        for (WordTag wt : list) {
            s.append("_");
            s.append(wt.word());
        }
        return s.toString();
    }

    private static String treeAsNonStemmedCollocation(Tree t) {
        List<WordTag> list = CollocationFinder.getNonStemmedWordTagsFromTree(t);
        StringBuffer s = new StringBuffer(160);
        WordTag firstWord = list.remove(0);
        s.append(firstWord.word());
        for (WordTag wt : list) {
            s.append("_");
            s.append(wt.word());
        }
        return s.toString();
    }

    private static String mergeLeavesIntoCollocatedString(Tree t) {
        StringBuffer sb = new StringBuffer(160);
        Sentence<TaggedWord> sent = t.taggedYield();
        for (TaggedWord aSent : sent) {
            sb.append(aSent.word()).append("_");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static String mergeLeavesIntoCollocatedString(Tree[] trees) {
        StringBuffer sb = new StringBuffer(160);
        for (Tree t : trees) {
            Sentence<TaggedWord> sent = t.taggedYield();
            for (TaggedWord aSent : sent) {
                sb.append(aSent.word()).append("_");
            }
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static List<WordTag> getStemmedWordTagsFromTree(Tree t, boolean threadSafe) {
        ArrayList<WordTag> stemmedWordTags = Generics.newArrayList();
        Sentence<TaggedWord> s = t.taggedYield();
        for (TaggedWord w : s) {
            WordTag wt = threadSafe ? Morphology.stemStaticSynchronized(w.word(), w.tag()) : Morphology.stemStatic(w.word(), w.tag());
            stemmedWordTags.add(wt);
        }
        return stemmedWordTags;
    }

    private static List<WordTag> getNonStemmedWordTagsFromTree(Tree t) {
        ArrayList<WordTag> wordTags = Generics.newArrayList();
        Sentence<TaggedWord> s = t.taggedYield();
        for (TaggedWord w : s) {
            WordTag wt = new WordTag(w.word(), w.tag());
            wordTags.add(wt);
        }
        return wordTags;
    }

    private boolean wordNetContains(String s) {
        return this.wnConnect.wordNetContains(s);
    }

    private static class Collocation {
        Pair<Integer, Integer> span;
        Tree parentNode;
        Label headLabel;
        List<Integer> indicesOfConstituentChildren;
        String collocationString;

        private Collocation(Pair<Integer, Integer> span, Tree parentNode, ArrayList<Integer> indicesOfConstituentChildren, String collocationString, Label headLabel) {
            this.span = span;
            this.parentNode = parentNode;
            this.collocationString = collocationString;
            this.indicesOfConstituentChildren = indicesOfConstituentChildren;
            this.headLabel = headLabel;
        }

        public String toString() {
            return this.collocationString + this.indicesOfConstituentChildren + "/" + this.headLabel;
        }
    }
}

