/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.PennTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTokenizerFactory;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Function;
import java.io.Serializable;

public abstract class AbstractTreebankLanguagePack
implements TreebankLanguagePack {
    private static final long serialVersionUID = -6506749780512708352L;
    protected char gfCharacter;
    protected static final char DEFAULT_GF_CHAR = '-';
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private final Filter<String> punctTagStringAcceptFilter = Filters.collectionAcceptFilter(this.punctuationTags());
    private final Filter<String> punctWordStringAcceptFilter = Filters.collectionAcceptFilter(this.punctuationWords());
    private final Filter<String> sFPunctTagStringAcceptFilter = Filters.collectionAcceptFilter(this.sentenceFinalPunctuationTags());
    private final Filter<String> eIPunctTagStringAcceptFilter = Filters.collectionAcceptFilter(this.evalBIgnoredPunctuationTags());
    private final Filter<String> startSymbolAcceptFilter = Filters.collectionAcceptFilter(this.startSymbols());

    public AbstractTreebankLanguagePack() {
        this('-');
    }

    public AbstractTreebankLanguagePack(char gfChar) {
        this.gfCharacter = gfChar;
    }

    @Override
    public abstract String[] punctuationTags();

    @Override
    public abstract String[] punctuationWords();

    @Override
    public abstract String[] sentenceFinalPunctuationTags();

    @Override
    public String[] evalBIgnoredPunctuationTags() {
        return this.punctuationTags();
    }

    @Override
    public boolean isPunctuationTag(String str) {
        return this.punctTagStringAcceptFilter.accept(str);
    }

    @Override
    public boolean isPunctuationWord(String str) {
        return this.punctWordStringAcceptFilter.accept(str);
    }

    @Override
    public boolean isSentenceFinalPunctuationTag(String str) {
        return this.sFPunctTagStringAcceptFilter.accept(str);
    }

    @Override
    public boolean isEvalBIgnoredPunctuationTag(String str) {
        return this.eIPunctTagStringAcceptFilter.accept(str);
    }

    @Override
    public Filter<String> punctuationTagAcceptFilter() {
        return this.punctTagStringAcceptFilter;
    }

    @Override
    public Filter<String> punctuationTagRejectFilter() {
        return Filters.notFilter(this.punctTagStringAcceptFilter);
    }

    @Override
    public Filter<String> punctuationWordAcceptFilter() {
        return this.punctWordStringAcceptFilter;
    }

    @Override
    public Filter<String> punctuationWordRejectFilter() {
        return Filters.notFilter(this.punctWordStringAcceptFilter);
    }

    @Override
    public Filter<String> sentenceFinalPunctuationTagAcceptFilter() {
        return this.sFPunctTagStringAcceptFilter;
    }

    @Override
    public Filter<String> evalBIgnoredPunctuationTagAcceptFilter() {
        return this.eIPunctTagStringAcceptFilter;
    }

    @Override
    public Filter<String> evalBIgnoredPunctuationTagRejectFilter() {
        return Filters.notFilter(this.eIPunctTagStringAcceptFilter);
    }

    @Override
    public String getEncoding() {
        return DEFAULT_ENCODING;
    }

    @Override
    public char[] labelAnnotationIntroducingCharacters() {
        return EMPTY_CHAR_ARRAY;
    }

    private int postBasicCategoryIndex(String category) {
        int i;
        boolean sawAtZero = false;
        char seenAtZero = '\u0000';
        int leng = category.length();
        for (i = 0; i < leng; ++i) {
            char ch = category.charAt(i);
            if (!this.isLabelAnnotationIntroducingCharacter(ch)) continue;
            if (i == 0) {
                sawAtZero = true;
                seenAtZero = ch;
                continue;
            }
            if (!sawAtZero || ch != seenAtZero) break;
            sawAtZero = false;
        }
        return i;
    }

    @Override
    public String basicCategory(String category) {
        if (category == null) {
            return null;
        }
        return category.substring(0, this.postBasicCategoryIndex(category));
    }

    @Override
    public String stripGF(String category) {
        if (category == null) {
            return null;
        }
        int index = category.lastIndexOf(this.gfCharacter);
        if (index > 0) {
            category = category.substring(0, index);
        }
        return category;
    }

    @Override
    public Function<String, String> getBasicCategoryFunction() {
        return new BasicCategoryStringFunction(this);
    }

    @Override
    public String categoryAndFunction(String category) {
        if (category == null) {
            return null;
        }
        String catFunc = category;
        int i = this.lastIndexOfNumericTag(catFunc);
        while (i >= 0) {
            catFunc = catFunc.substring(0, i);
            i = this.lastIndexOfNumericTag(catFunc);
        }
        return catFunc;
    }

    private int lastIndexOfNumericTag(String category) {
        if (category == null) {
            return -1;
        }
        int last = -1;
        for (int i = category.length() - 1; i >= 0; --i) {
            if (!this.isLabelAnnotationIntroducingCharacter(category.charAt(i))) continue;
            boolean onlyDigitsFollow = false;
            for (int j = i + 1; j < category.length(); ++j) {
                onlyDigitsFollow = true;
                if (Character.isDigit(category.charAt(j))) continue;
                onlyDigitsFollow = false;
                break;
            }
            if (!onlyDigitsFollow) continue;
            last = i;
        }
        return last;
    }

    @Override
    public Function<String, String> getCategoryAndFunctionFunction() {
        return new CategoryAndFunctionStringFunction(this);
    }

    @Override
    public boolean isLabelAnnotationIntroducingCharacter(char ch) {
        char[] cutChars;
        for (char cutChar : cutChars = this.labelAnnotationIntroducingCharacters()) {
            if (ch != cutChar) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStartSymbol(String str) {
        return this.startSymbolAcceptFilter.accept(str);
    }

    @Override
    public Filter<String> startSymbolAcceptFilter() {
        return this.startSymbolAcceptFilter;
    }

    @Override
    public abstract String[] startSymbols();

    @Override
    public String startSymbol() {
        String[] ssyms = this.startSymbols();
        if (ssyms == null || ssyms.length == 0) {
            return null;
        }
        return ssyms[0];
    }

    @Override
    public TokenizerFactory<? extends HasWord> getTokenizerFactory() {
        return WhitespaceTokenizer.factory(false);
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory() {
        throw new UnsupportedOperationException("No GrammaticalStructureFactory defined for " + this.getClass().getName());
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory(Filter<String> puncFilt) {
        return this.grammaticalStructureFactory();
    }

    public char getGfCharacter() {
        return this.gfCharacter;
    }

    @Override
    public void setGfCharacter(char gfCharacter) {
        this.gfCharacter = gfCharacter;
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        return new PennTreeReaderFactory();
    }

    @Override
    public TokenizerFactory<Tree> treeTokenizerFactory() {
        return new TreeTokenizerFactory(this.treeReaderFactory());
    }

    private static class CategoryAndFunctionStringFunction
    implements Function<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private TreebankLanguagePack tlp;

        CategoryAndFunctionStringFunction(TreebankLanguagePack tlp) {
            this.tlp = tlp;
        }

        @Override
        public String apply(String in) {
            return this.tlp.categoryAndFunction(in);
        }
    }

    private static class BasicCategoryStringFunction
    implements Function<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private TreebankLanguagePack tlp;

        BasicCategoryStringFunction(TreebankLanguagePack tlp) {
            this.tlp = tlp;
        }

        @Override
        public String apply(String in) {
            return this.tlp.basicCategory(in);
        }
    }
}

