/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.MutableDouble;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TwoDimensionalCounter<K1, K2>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<K1, ClassicCounter<K2>> map;
    private double total;
    private MapFactory<K1, ClassicCounter<K2>> outerMF;
    private MapFactory<K2, MutableDouble> innerMF;
    private double defaultValue = 0.0;

    public void defaultReturnValue(double rv) {
        this.defaultValue = rv;
    }

    public double defaultReturnValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TwoDimensionalCounter)) {
            return false;
        }
        return ((Object)((TwoDimensionalCounter)o).map).equals(this.map);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode() + 17;
    }

    public ClassicCounter<K2> getCounter(K1 o) {
        ClassicCounter<K2> c = this.map.get(o);
        if (c == null) {
            c = new ClassicCounter<K2>(this.innerMF);
            c.setDefaultReturnValue(this.defaultValue);
            this.map.put(o, c);
        }
        return c;
    }

    public Set<Map.Entry<K1, ClassicCounter<K2>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        int result = 0;
        for (K1 o : this.firstKeySet()) {
            ClassicCounter<K2> c = this.map.get(o);
            result += c.size();
        }
        return result;
    }

    public boolean containsKey(K1 o1, K2 o2) {
        if (!this.map.containsKey(o1)) {
            return false;
        }
        ClassicCounter<K2> c = this.map.get(o1);
        return c.containsKey(o2);
    }

    public void incrementCount(K1 o1, K2 o2) {
        this.incrementCount(o1, o2, 1.0);
    }

    public void incrementCount(K1 o1, K2 o2, double count) {
        ClassicCounter<K2> c = this.getCounter(o1);
        c.incrementCount(o2, count);
        this.total += count;
    }

    public void decrementCount(K1 o1, K2 o2) {
        this.incrementCount(o1, o2, -1.0);
    }

    public void decrementCount(K1 o1, K2 o2, double count) {
        this.incrementCount(o1, o2, -count);
    }

    public void setCount(K1 o1, K2 o2, double count) {
        ClassicCounter<K2> c = this.getCounter(o1);
        double oldCount = this.getCount(o1, o2);
        this.total -= oldCount;
        c.setCount(o2, count);
        this.total += count;
    }

    public double remove(K1 o1, K2 o2) {
        ClassicCounter<K2> c = this.getCounter(o1);
        double oldCount = this.getCount(o1, o2);
        this.total -= oldCount;
        c.remove(o2);
        if (c.size() == 0) {
            this.map.remove(o1);
        }
        return oldCount;
    }

    public double getCount(K1 o1, K2 o2) {
        ClassicCounter<K2> c = this.getCounter(o1);
        if (c.totalCount() == 0.0 && !c.keySet().contains(o2)) {
            return this.defaultReturnValue();
        }
        return c.getCount(o2);
    }

    public double totalCount() {
        return this.total;
    }

    public double totalCount(K1 k1) {
        ClassicCounter<K2> c = this.getCounter(k1);
        return c.totalCount();
    }

    public Set<K1> firstKeySet() {
        return this.map.keySet();
    }

    public ClassicCounter<K2> setCounter(K1 o, ClassicCounter<K2> c) {
        ClassicCounter<K2> old = this.getCounter(o);
        this.total -= old.totalCount();
        this.map.put(o, c);
        this.total += c.totalCount();
        return old;
    }

    public static <K1, K2> TwoDimensionalCounter<K2, K1> reverseIndexOrder(TwoDimensionalCounter<K1, K2> cc) {
        TwoDimensionalCounter<K2, K1> result = new TwoDimensionalCounter<K2, K1>(cc.outerMF, cc.innerMF);
        for (K1 key1 : cc.firstKeySet()) {
            ClassicCounter<K2> c = cc.getCounter(key1);
            for (K2 key2 : c.keySet()) {
                double count = c.getCount(key2);
                result.setCount(key2, key1, count);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        for (K1 key1 : this.map.keySet()) {
            ClassicCounter<K2> c = this.getCounter(key1);
            for (K2 key2 : c.keySet()) {
                double score = c.getCount(key2);
                buff.append(key1).append("\t").append(key2).append("\t").append(score).append("\n");
            }
        }
        return buff.toString();
    }

    public String toMatrixString(int cellSize) {
        ArrayList<K1> firstKeys = new ArrayList<K1>(this.firstKeySet());
        ArrayList<K2> secondKeys = new ArrayList<K2>(this.secondKeySet());
        Collections.sort(firstKeys);
        Collections.sort(secondKeys);
        double[][] counts = this.toMatrix(firstKeys, secondKeys);
        return ArrayMath.toString(counts, cellSize, firstKeys.toArray(), secondKeys.toArray(), (NumberFormat)new DecimalFormat(), true);
    }

    public double[][] toMatrix(List<K1> firstKeys, List<K2> secondKeys) {
        double[][] counts = new double[firstKeys.size()][secondKeys.size()];
        for (int i = 0; i < firstKeys.size(); ++i) {
            for (int j = 0; j < secondKeys.size(); ++j) {
                counts[i][j] = this.getCount(firstKeys.get(i), secondKeys.get(j));
            }
        }
        return counts;
    }

    public String toCSVString(NumberFormat nf) {
        ArrayList<K1> firstKeys = new ArrayList<K1>(this.firstKeySet());
        ArrayList<K2> secondKeys = new ArrayList<K2>(this.secondKeySet());
        Collections.sort(firstKeys);
        Collections.sort(secondKeys);
        StringBuilder b = new StringBuilder();
        String[] headerRow = new String[secondKeys.size() + 1];
        headerRow[0] = "";
        for (int j = 0; j < secondKeys.size(); ++j) {
            headerRow[j + 1] = secondKeys.get(j).toString();
        }
        b.append(StringUtils.toCSVString(headerRow)).append("\n");
        for (Object rowLabel : firstKeys) {
            String[] row = new String[secondKeys.size() + 1];
            row[0] = rowLabel.toString();
            for (int j = 0; j < secondKeys.size(); ++j) {
                Object colLabel = secondKeys.get(j);
                row[j + 1] = nf.format(this.getCount(rowLabel, colLabel));
            }
            b.append(StringUtils.toCSVString(row)).append("\n");
        }
        return b.toString();
    }

    public Set<K2> secondKeySet() {
        HashSet<K2> result = new HashSet<K2>();
        for (K1 k1 : this.firstKeySet()) {
            for (K2 k2 : this.getCounter(k1).keySet()) {
                result.add(k2);
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public ClassicCounter<Pair<K1, K2>> flatten() {
        ClassicCounter<Pair<K1, K2>> result = new ClassicCounter<Pair<K1, K2>>();
        result.setDefaultReturnValue(this.defaultValue);
        for (K1 key1 : this.firstKeySet()) {
            ClassicCounter<K2> inner = this.getCounter(key1);
            for (K2 key2 : inner.keySet()) {
                result.setCount(new Pair<K1, K2>(key1, key2), inner.getCount(key2));
            }
        }
        return result;
    }

    public void addAll(TwoDimensionalCounter<K1, K2> c) {
        for (K1 key : c.firstKeySet()) {
            ClassicCounter<K2> inner = c.getCounter(key);
            ClassicCounter<K2> myInner = this.getCounter(key);
            Counters.addInPlace(myInner, inner);
            this.total += inner.totalCount();
        }
    }

    public void addAll(K1 key, ClassicCounter<K2> c) {
        ClassicCounter<K2> myInner = this.getCounter(key);
        Counters.addInPlace(myInner, c);
        this.total += c.totalCount();
    }

    public void subtractAll(K1 key, ClassicCounter<K2> c) {
        ClassicCounter<K2> myInner = this.getCounter(key);
        Counters.subtractInPlace(myInner, c);
        this.total -= c.totalCount();
    }

    public void subtractAll(TwoDimensionalCounter<K1, K2> c, boolean removeKeys) {
        for (K1 key : c.firstKeySet()) {
            ClassicCounter<K2> inner = c.getCounter(key);
            ClassicCounter<K2> myInner = this.getCounter(key);
            Counters.subtractInPlace(myInner, inner);
            if (removeKeys) {
                Counters.retainNonZeros(myInner);
            }
            this.total -= inner.totalCount();
        }
    }

    public void removeZeroCounts() {
        HashSet<K1> firstKeySet = new HashSet<K1>(this.firstKeySet());
        for (Object k1 : firstKeySet) {
            ClassicCounter<K2> c = this.getCounter(k1);
            Counters.retainNonZeros(c);
            if (c.size() != 0) continue;
            this.map.remove(k1);
        }
    }

    public void remove(K1 key) {
        ClassicCounter<K2> counter = this.map.get(key);
        if (counter != null) {
            this.total -= counter.totalCount();
        }
        this.map.remove(key);
    }

    public void clean() {
        for (K1 key1 : new HashSet<K1>(this.map.keySet())) {
            ClassicCounter<K2> c = this.map.get(key1);
            for (K2 key2 : new HashSet<K2>(c.keySet())) {
                if (!SloppyMath.isCloseTo(0.0, c.getCount(key2))) continue;
                c.remove(key2);
            }
            if (!c.keySet().isEmpty()) continue;
            this.map.remove(key1);
        }
    }

    public MapFactory<K1, ClassicCounter<K2>> getOuterMapFactory() {
        return this.outerMF;
    }

    public MapFactory<K2, MutableDouble> getInnerMapFactory() {
        return this.innerMF;
    }

    public TwoDimensionalCounter() {
        this(MapFactory.hashMapFactory(), MapFactory.hashMapFactory());
    }

    public TwoDimensionalCounter(MapFactory<K1, ClassicCounter<K2>> outerFactory, MapFactory<K2, MutableDouble> innerFactory) {
        this.innerMF = innerFactory;
        this.outerMF = outerFactory;
        this.map = outerFactory.newMap();
        this.total = 0.0;
    }

    public static void main(String[] args) {
        TwoDimensionalCounter<String, String> cc = new TwoDimensionalCounter<String, String>();
        cc.setCount("a", "c", 1.0);
        cc.setCount("b", "c", 1.0);
        cc.setCount("a", "d", 1.0);
        cc.setCount("a", "d", -1.0);
        cc.setCount("b", "d", 1.0);
        System.out.println(cc);
        cc.incrementCount("b", "d", 1.0);
        System.out.println(cc);
        TwoDimensionalCounter cc2 = TwoDimensionalCounter.reverseIndexOrder(cc);
        System.out.println(cc2);
    }
}

