/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.MutableDouble;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeneralizedCounter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object[] zeroKey = new Object[0];
    private Map map = new HashMap();
    private int depth;
    private double total;
    private transient MutableDouble tempMDouble = null;

    private GeneralizedCounter() {
    }

    public GeneralizedCounter(int depth) {
        this.depth = depth;
    }

    public Set entrySet() {
        return this.entrySet(new HashSet(), zeroKey, true);
    }

    private Set entrySet(Set s, Object[] key, boolean useLists) {
        if (this.depth == 1) {
            Set keys = this.map.keySet();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                Object[] newKey = new Object[key.length + 1];
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                Object finalKey = i.next();
                newKey[key.length] = finalKey;
                MutableDouble value = (MutableDouble)this.map.get(finalKey);
                Double value1 = new Double(value.doubleValue());
                if (useLists) {
                    s.add(new Entry(Arrays.asList(newKey), value1));
                    continue;
                }
                s.add(new Entry(newKey[0], value1));
            }
        } else {
            Set keys = this.map.keySet();
            for (Object o : keys) {
                Object[] newKey = new Object[key.length + 1];
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                newKey[key.length] = o;
                this.conditionalizeHelper(o).entrySet(s, newKey, true);
            }
        }
        return s;
    }

    public Set lowestLevelCounterEntrySet() {
        return this.lowestLevelCounterEntrySet(new HashSet(), zeroKey, true);
    }

    private Set lowestLevelCounterEntrySet(Set s, Object[] key, boolean useLists) {
        Set keys = this.map.keySet();
        if (this.depth == 2) {
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                Object[] newKey = new Object[key.length + 1];
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                Object finalKey = i.next();
                newKey[key.length] = finalKey;
                ClassicCounter c = this.conditionalizeHelper(finalKey).oneDimensionalCounterView();
                if (useLists) {
                    s.add(new Entry(Arrays.asList(newKey), c));
                    continue;
                }
                s.add(new Entry(newKey[0], c));
            }
        } else {
            for (Object o : keys) {
                Object[] newKey = new Object[key.length + 1];
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                newKey[key.length] = o;
                this.conditionalizeHelper(o).lowestLevelCounterEntrySet(s, newKey, true);
            }
        }
        return s;
    }

    public double totalCount() {
        if (this.depth() == 1) {
            return this.total;
        }
        double result = 0.0;
        for (Object o : this.topLevelKeySet()) {
            result += this.conditionalizeOnce(o).totalCount();
        }
        return result;
    }

    public Set topLevelKeySet() {
        return this.map.keySet();
    }

    public Set keySet() {
        return this.keySet(new HashSet(), zeroKey, true);
    }

    private Set keySet(Set s, Object[] key, boolean useList) {
        if (this.depth == 1) {
            Set keys = this.map.keySet();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                Object[] newKey = new Object[key.length + 1];
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                newKey[key.length] = i.next();
                if (useList) {
                    s.add(Arrays.asList(newKey));
                    continue;
                }
                s.add(newKey[0]);
            }
        } else {
            Set keys = this.map.keySet();
            for (Object o : keys) {
                Object[] newKey = new Object[key.length + 1];
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                newKey[key.length] = o;
                this.conditionalizeHelper(o).keySet(s, newKey, true);
            }
        }
        return s;
    }

    public int depth() {
        return this.depth;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public double getCount(Object o) {
        Number count;
        if (this.depth > 1) {
            this.wrongDepth();
        }
        if ((count = (Number)this.map.get(o)) != null) {
            return count.doubleValue();
        }
        return 0.0;
    }

    public double getCount(Object o1, Object o2) {
        GeneralizedCounter gc1;
        if (this.depth != 2) {
            this.wrongDepth();
        }
        if ((gc1 = (GeneralizedCounter)this.map.get(o1)) == null) {
            return 0.0;
        }
        return gc1.getCount(o2);
    }

    public double getCount(Object o1, Object o2, Object o3) {
        GeneralizedCounter gc1;
        if (this.depth != 3) {
            this.wrongDepth();
        }
        if ((gc1 = (GeneralizedCounter)this.map.get(o1)) == null) {
            return 0.0;
        }
        return gc1.getCount(o2, o3);
    }

    public double[] getCounts(List l) {
        if (l.size() != this.depth) {
            this.wrongDepth();
        }
        double[] counts = new double[this.depth + 1];
        GeneralizedCounter next = this;
        counts[0] = next.totalCount();
        Iterator i = l.iterator();
        int j = 1;
        Object o = i.next();
        while (i.hasNext()) {
            next = next.conditionalizeHelper(o);
            counts[j] = next.totalCount();
            o = i.next();
            ++j;
        }
        counts[this.depth] = next.getCount(o);
        return counts;
    }

    private GeneralizedCounter conditionalizeHelper(Object o) {
        if (this.depth > 1) {
            GeneralizedCounter next = (GeneralizedCounter)this.map.get(o);
            if (next == null) {
                next = new GeneralizedCounter(this.depth - 1);
                this.map.put(o, next);
            }
            return next;
        }
        throw new RuntimeException("Error -- can't conditionalize a distribution of depth 1");
    }

    public GeneralizedCounter conditionalize(List l) {
        int n = l.size();
        if (n >= this.depth()) {
            throw new RuntimeException("Error -- attempted to conditionalize a GeneralizedCounter of depth " + this.depth() + " on a vector of length " + n);
        }
        GeneralizedCounter next = this;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            next = next.conditionalizeHelper(i.next());
        }
        return next;
    }

    public GeneralizedCounter conditionalizeOnce(Object o) {
        if (this.depth() < 1) {
            throw new RuntimeException("Error -- attempted to conditionalize a GeneralizedCounter of depth " + this.depth());
        }
        return this.conditionalizeHelper(o);
    }

    public void incrementCount(List l, Object o) {
        this.incrementCount(l, o, 1.0);
    }

    public void incrementCount(List l, Object o, double count) {
        if (l.size() != this.depth - 1) {
            this.wrongDepth();
        }
        GeneralizedCounter next = this;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            next.addToTotal(count);
            Object o2 = i.next();
            next = next.conditionalizeHelper(o2);
        }
        next.addToTotal(count);
        next.incrementCount1D(o, count);
    }

    public void incrementCount(List l) {
        this.incrementCount(l, 1.0);
    }

    public void incrementCount(List l, double count) {
        if (l.size() != this.depth) {
            this.wrongDepth();
        }
        GeneralizedCounter next = this;
        Iterator i = l.iterator();
        Object o = i.next();
        while (i.hasNext()) {
            next.addToTotal(count);
            next = next.conditionalizeHelper(o);
            o = i.next();
        }
        next.incrementCount1D(o, count);
    }

    public void incrementCount2D(Object first, Object second) {
        this.incrementCount2D(first, second, 1.0);
    }

    public void incrementCount2D(Object first, Object second, double count) {
        if (this.depth != 2) {
            this.wrongDepth();
        }
        this.addToTotal(count);
        GeneralizedCounter next = this.conditionalizeHelper(first);
        next.incrementCount1D(second, count);
    }

    public void incrementCount3D(Object first, Object second, Object third) {
        this.incrementCount3D(first, second, third, 1.0);
    }

    public void incrementCount3D(Object first, Object second, Object third, double count) {
        if (this.depth != 3) {
            this.wrongDepth();
        }
        this.addToTotal(count);
        GeneralizedCounter next = this.conditionalizeHelper(first);
        next.incrementCount2D(second, third, count);
    }

    private void addToTotal(double d) {
        this.total += d;
    }

    public void incrementCount1D(Object o) {
        this.incrementCount1D(o, 1.0);
    }

    public void incrementCount1D(Object o, double count) {
        if (this.depth > 1) {
            this.wrongDepth();
        }
        this.addToTotal(count);
        if (this.tempMDouble == null) {
            this.tempMDouble = new MutableDouble();
        }
        this.tempMDouble.set(count);
        MutableDouble oldMDouble = this.map.put(o, this.tempMDouble);
        if (oldMDouble != null) {
            this.tempMDouble.set(count + oldMDouble.doubleValue());
        }
        this.tempMDouble = oldMDouble;
    }

    public boolean containsKey(List key) {
        GeneralizedCounter next = this;
        for (int i = 0; i < key.size() - 1; ++i) {
            if ((next = next.conditionalizeHelper(key.get(i))) != null) continue;
            return false;
        }
        return next.map.containsKey(key.get(key.size() - 1));
    }

    public GeneralizedCounter reverseKeys() {
        GeneralizedCounter result = new GeneralizedCounter();
        Set entries = this.entrySet();
        for (Entry entry : entries) {
            List list = (List)entry.getKey();
            double count = (Double)entry.getValue();
            Collections.reverse(list);
            result.incrementCount(list, count);
        }
        return result;
    }

    private void wrongDepth() {
        throw new RuntimeException("Error -- attempt to operate with key of wrong length. depth=" + this.depth);
    }

    public ClassicCounter counterView() {
        return new CounterView();
    }

    public ClassicCounter oneDimensionalCounterView() {
        if (this.depth != 1) {
            throw new UnsupportedOperationException();
        }
        return new OneDimensionalCounterView();
    }

    public String toString() {
        return this.map.toString();
    }

    public String toString(String param) {
        if (param.equals("contingency")) {
            StringBuffer sb = new StringBuffer();
            Set keys = this.topLevelKeySet();
            ArrayList list = new ArrayList(keys);
            Collections.sort(list);
            for (Object obj : list) {
                sb.append(obj);
                sb.append(" = ");
                GeneralizedCounter gc = this.conditionalizeOnce(obj);
                sb.append(gc);
                sb.append("\n");
            }
            return sb.toString();
        }
        if (param.equals("sorted")) {
            StringBuffer sb = new StringBuffer();
            Set keys = this.topLevelKeySet();
            ArrayList list = new ArrayList(keys);
            Collections.sort(list);
            sb.append("{\n");
            for (Object obj : list) {
                sb.append(obj);
                sb.append(" = ");
                GeneralizedCounter gc = this.conditionalizeOnce(obj);
                sb.append(gc);
                sb.append("\n");
            }
            sb.append("}\n");
            return sb.toString();
        }
        return this.toString();
    }

    public static void main(String[] args) {
        Object[] a1 = new Object[]{"a", "b"};
        Object[] a2 = new Object[]{"a", "b"};
        System.out.println(a1.equals(a2));
        GeneralizedCounter gc = new GeneralizedCounter(3);
        gc.incrementCount(Arrays.asList("a", "j", "x"), 3.0);
        gc.incrementCount(Arrays.asList("a", "l", "x"), 3.0);
        gc.incrementCount(Arrays.asList("b", "k", "y"), 3.0);
        gc.incrementCount(Arrays.asList("b", "k", "z"), 3.0);
        System.out.println("incremented counts.");
        System.out.println(gc.dumpKeys());
        System.out.println("string representation of generalized counter:");
        System.out.println(gc.toString());
        gc.printKeySet();
        System.out.println("entry set:\n" + gc.entrySet());
        GeneralizedCounter.arrayPrintDouble(gc.getCounts(Arrays.asList("a", "j", "x")));
        GeneralizedCounter.arrayPrintDouble(gc.getCounts(Arrays.asList("a", "j", "z")));
        GeneralizedCounter.arrayPrintDouble(gc.getCounts(Arrays.asList("b", "k", "w")));
        GeneralizedCounter.arrayPrintDouble(gc.getCounts(Arrays.asList("b", "k", "z")));
        GeneralizedCounter gc1 = gc.conditionalize(Arrays.asList("a"));
        gc1.incrementCount(Arrays.asList("j", "x"));
        gc1.incrementCount2D("j", "z");
        GeneralizedCounter gc2 = gc1.conditionalize(Arrays.asList("j"));
        gc2.incrementCount1D("x");
        System.out.println("Pretty-printing gc after incrementing gc1:");
        gc.prettyPrint();
        System.out.println("Total: " + gc.totalCount());
        gc1.printKeySet();
        System.out.println("another entry set:\n" + gc1.entrySet());
        ClassicCounter c = gc.counterView();
        System.out.println("string representation of counter view:");
        System.out.println(c.toString());
        double d1 = c.getCount(Arrays.asList("a", "j", "x"));
        double d2 = c.getCount(Arrays.asList("a", "j", "w"));
        System.out.println(d1 + " " + d2);
        ClassicCounter c1 = gc1.counterView();
        System.out.println("Count of {j,x} -- should be 3.0\t" + c1.getCount(Arrays.asList("j", "x")));
        System.out.println(c.keySet() + " size " + c.keySet().size());
        System.out.println(c1.keySet() + " size " + c1.keySet().size());
        System.out.println(c1.equals(c));
        System.out.println(c.equals(c1));
        System.out.println(c.equals(c));
        System.out.println("### testing equality of regular Counter...");
        ClassicCounter<String> z1 = new ClassicCounter<String>();
        ClassicCounter<String> z2 = new ClassicCounter<String>();
        z1.incrementCount("a1");
        z1.incrementCount("a2");
        z2.incrementCount("b");
        System.out.println(z1.equals(z2));
        System.out.println(z1.toString());
        System.out.println(z1.keySet().toString());
    }

    private void printKeySet() {
        Set keys = this.keySet();
        System.out.println("printing keyset:");
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    private static void arrayPrintDouble(double[] o) {
        int n = o.length;
        for (int i = 0; i < n; ++i) {
            System.out.print(o[i] + "\t");
        }
        System.out.println();
    }

    private Set dumpKeys() {
        return this.map.keySet();
    }

    public void prettyPrint() {
        this.prettyPrint(new PrintWriter(System.out, true));
    }

    public void prettyPrint(PrintWriter pw) {
        this.prettyPrint(pw, "  ");
    }

    public void prettyPrint(PrintWriter pw, String bufferIncrement) {
        this.prettyPrint(pw, "", bufferIncrement);
    }

    private void prettyPrint(PrintWriter pw, String buffer, String bufferIncrement) {
        if (this.depth == 1) {
            for (Map.Entry e : this.entrySet()) {
                Object key = e.getKey();
                double count = (Double)e.getValue();
                pw.println(buffer + key + "\t" + count);
            }
        } else {
            for (Object key : this.topLevelKeySet()) {
                GeneralizedCounter gc1 = this.conditionalize(Arrays.asList(key));
                pw.println(buffer + key + "\t" + gc1.totalCount());
                gc1.prettyPrint(pw, buffer + bufferIncrement, bufferIncrement);
            }
        }
    }

    private class OneDimensionalCounterView
    extends ClassicCounter {
        private OneDimensionalCounterView() {
        }

        @Override
        public double incrementCount(Object o, double count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCount(Object o, double count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalCount() {
            return GeneralizedCounter.this.totalCount();
        }

        @Override
        public double getCount(Object o) {
            return GeneralizedCounter.this.getCount(o);
        }

        @Override
        public int size() {
            return GeneralizedCounter.this.map.size();
        }

        @Override
        public Set keySet() {
            return GeneralizedCounter.this.keySet(new HashSet(), zeroKey, false);
        }

        @Override
        public double remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return GeneralizedCounter.this.map.containsKey(key);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return GeneralizedCounter.this.isEmpty();
        }

        @Override
        public Set entrySet() {
            return GeneralizedCounter.this.entrySet(new HashSet(), zeroKey, false);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassicCounter)) {
                return false;
            }
            return ((Object)this.entrySet()).equals(((ClassicCounter)o).entrySet());
        }

        @Override
        public int hashCode() {
            int total = 17;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                total = 37 * total + i.next().hashCode();
            }
            return total;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("{");
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Entry e = (Entry)i.next();
                sb.append(e.toString());
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private class CounterView
    extends ClassicCounter {
        private CounterView() {
        }

        @Override
        public double incrementCount(Object o, double count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCount(Object o, double count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalCount() {
            return GeneralizedCounter.this.totalCount();
        }

        @Override
        public double getCount(Object o) {
            List o1 = (List)o;
            if (o1.size() != GeneralizedCounter.this.depth) {
                return 0.0;
            }
            return GeneralizedCounter.this.getCounts(o1)[GeneralizedCounter.this.depth];
        }

        @Override
        public int size() {
            return GeneralizedCounter.this.map.size();
        }

        @Override
        public Set keySet() {
            return GeneralizedCounter.this.keySet();
        }

        @Override
        public double remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof List)) {
                return false;
            }
            return GeneralizedCounter.this.containsKey((List)key);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return GeneralizedCounter.this.isEmpty();
        }

        @Override
        public Set entrySet() {
            return GeneralizedCounter.this.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassicCounter)) {
                return false;
            }
            return ((Object)this.entrySet()).equals(((ClassicCounter)o).entrySet());
        }

        @Override
        public int hashCode() {
            int total = 17;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                total = 37 * total + i.next().hashCode();
            }
            return total;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("{");
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Entry e = (Entry)i.next();
                sb.append(e.toString());
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private static class Entry
    implements Map.Entry {
        private Object key;
        private Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object key1 = e.getKey();
            if (this.key == null || !this.key.equals(key1)) {
                return false;
            }
            Object value1 = e.getValue();
            return this.value != null && this.value.equals(value1);
        }

        @Override
        public int hashCode() {
            if (this.key == null || this.value == null) {
                return 0;
            }
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }
}

