/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.BasicDocument;
import edu.stanford.nlp.ling.Document;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.AbstractListProcessor;
import edu.stanford.nlp.process.StripTagsProcessor;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.util.Function;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PTBEscapingProcessor<IN extends HasWord, L, F>
extends AbstractListProcessor<IN, HasWord, L, F>
implements Function<List<IN>, List<HasWord>> {
    protected Map<String, String> stringSubs;
    protected char[] oldChars;
    protected static final String[] oldStrings = new String[]{"(", ")", "[", "]", "{", "}", "/", "*"};
    protected static final String[] newStrings = new String[]{"-LRB-", "-RRB-", "-LSB-", "-RSB-", "-LCB-", "-RCB-", "\\/", "\\*"};
    protected static final char[] defaultOldChars = new char[]{'*', '/'};
    protected boolean fixQuotes = true;

    public PTBEscapingProcessor() {
        this(PTBEscapingProcessor.makeStringMap(), defaultOldChars, true);
    }

    public PTBEscapingProcessor(Map<String, String> stringSubs, char[] oldChars, boolean fixQuotes) {
        this.stringSubs = stringSubs;
        this.oldChars = oldChars;
        this.fixQuotes = fixQuotes;
    }

    protected static Map<String, String> makeStringMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < oldStrings.length; ++i) {
            map.put(oldStrings[i], newStrings[i]);
        }
        return map;
    }

    @Override
    public List<HasWord> apply(List<IN> hasWordsList) {
        return this.process(hasWordsList);
    }

    public static String unprocess(String s) {
        for (int i = 0; i < newStrings.length; ++i) {
            if (!newStrings[i].equals(s)) continue;
            return oldStrings[i];
        }
        return s;
    }

    @Override
    public List<HasWord> process(List<IN> input) {
        ArrayList<HasWord> output = new ArrayList<HasWord>();
        for (HasWord h : input) {
            String s = h.word();
            String newS = this.stringSubs.get(s);
            if (newS != null) {
                h.setWord(newS);
            } else {
                h.setWord(this.escapeString(s));
            }
            output.add(h);
        }
        if (this.fixQuotes) {
            return this.fixQuotes(output);
        }
        return output;
    }

    private List<HasWord> fixQuotes(List<HasWord> input) {
        int inputSize = input.size();
        LinkedList<HasWord> result = new LinkedList<HasWord>();
        if (inputSize == 0) {
            return result;
        }
        if (input.get(inputSize - 1).word().equals("\"")) {
            boolean begin = false;
            for (int i = inputSize - 1; i >= 0; --i) {
                HasWord hw = input.get(i);
                String tok = hw.word();
                if (tok.equals("\"")) {
                    if (begin) {
                        hw.setWord("``");
                        begin = false;
                    } else {
                        hw.setWord("''");
                        begin = true;
                    }
                }
                result.addFirst(hw);
            }
        } else {
            boolean begin = true;
            for (int i = 0; i < inputSize; ++i) {
                HasWord hw = input.get(i);
                String tok = hw.word();
                if (tok.equals("\"")) {
                    if (begin) {
                        hw.setWord("``");
                        begin = false;
                    } else {
                        hw.setWord("''");
                        begin = true;
                    }
                }
                result.addLast(hw);
            }
        }
        return result;
    }

    private String escapeString(String s) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char curChar = s.charAt(i);
            if (curChar == '\\') {
                buff.append(curChar);
                if (++i >= s.length()) continue;
                curChar = s.charAt(i);
                buff.append(curChar);
                continue;
            }
            for (int j = 0; j < this.oldChars.length; ++j) {
                if (curChar != this.oldChars[j]) continue;
                buff.append('\\');
                break;
            }
            buff.append(curChar);
        }
        return buff.toString();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: java edu.stanford.nlp.process.PTBEscapingProcessor fileOrUrl");
            System.exit(0);
        }
        String filename = args[0];
        try {
            Document d = null;
            if (filename.startsWith("http://")) {
                BasicDocument dpre = new BasicDocument(WhitespaceTokenizer.factory()).init(new URL(filename));
                StripTagsProcessor notags = new StripTagsProcessor();
                d = notags.processDocument(dpre);
            } else {
                d = new BasicDocument(WhitespaceTokenizer.factory()).init(new File(filename));
            }
            PTBEscapingProcessor proc = new PTBEscapingProcessor();
            Document newD = proc.processDocument(d);
            for (HasWord word : newD) {
                System.out.println(word);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

